#include <stdio.h>
char *malloc();

char *
readhdf(infile_name,imagenum,
	xdim,ydim,
	pal,palsize,palnum,palfile)
     char *infile_name;
     int imagenum;
     int *xdim, *ydim;
     char *pal;
     int *palsize, palnum;
     char  *palfile;
{
  int ispal, nspace, npals, i, maxrgb;
  char errstr[132];
  static char  *imageHolder;

  for (i=0; i<=imagenum; i++)
    {
      if (DFR8getdims(infile_name, xdim, ydim, &ispal) == -1)
	{
	  perror("readhdf/DFR8getdims: reading file");
	  exit(1);
	}
    }

  *palsize = 256;		/* By default */
  nspace = *xdim * *ydim;
  imageHolder=malloc((unsigned)nspace);
  if (imageHolder == NULL)
    {
      sprintf(errstr,"hdfread: can't malloc space (%d) for image\n",nspace);
      perror(errstr);
      exit(1);
    }
  if (DFR8getimage(infile_name,imageHolder,*xdim,*ydim,pal) != 0)
    {
      fprintf(stderr,"readhdf: failed DFR8getimage\n");
      exit(-1);
    }
  if ((palfile != NULL) || (palnum != 0))
    {
      if (palfile==NULL) palfile=infile_name;
      npals = DFPnpals(palfile);
      switch (npals)
	{
	case -1:
	  fprintf(stderr,"readhdf: getting number of palettes\n");
	  exit(-1);
	  break;
	case  0:
	  /* set up fake palette - ramp R, G, B */
	  fprintf(stderr,"Fake palette needed\n"); 
	  for (i=0; i<256; i += 3)   pal[i] = i; 
	  for (i=256; i<511; i += 3) pal[i+1] = i; 
	  for (i=512; i<766; i += 3) pal[i+2] = i; 
	  break;
	default:
	  i = DFPreadref(palfile,palnum);
	  if (i==-1)
	    {
	      fprintf(stderr,
		      "Palette (%d) does not exist in file (%s):",
		      palnum,palfile);
	      if (ispal)
		fprintf(stderr," Default palette loaded.\n");
	      else
		fprintf(stderr," No palette loaded.\n");
	    }
	  else
	    DFPgetpal(palfile,pal);
	  break;
	}
    }
  return(imageHolder);
}
