/*
	Author		: Sreedhar Sivakumaran
	Notes		:
	
		Test function to test switching of connection from
		one source to another repeatedly.
*/

#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <dtmint.h>
#include <dtm.h>
#include "test.h"

extern	char	*sherr() ;

static int writemsg( port )
int	port ;
{
char	data[ MAXMSGLEN ] ;
int	status ;

	strcpy( data, MSGDATA );
	strcat( data, MSGDATA );

	PAUSE ;
	
	while( (status = DTMavailWrite( port )) == FALSE ) 
	{
		fprintf( stdout, "%%Test: availWrite == FALSE\n" );
	}
	if( status != TRUE )
	{
		fprintf( stderr, "%%Test: Port %d, availWrite fails %s\n",
				port, sherr( DTMerrno ) ) ;
		return 0 ;
	}
	else
	{
		fprintf( stderr, "%%Test: Port %d, availWrite success\n",
				port );
	}

	if( DTMwriteMsg( port, MSGHEADER, sizeof( MSGHEADER ), 
		data, 2*sizeof( MSGDATA ) - 1, DTM_CHAR ) == DTMERROR )
	{
		fprintf( stderr, "%%Test: Port %d, composite write fails, %s\n", port, sherr( DTMerrno ) ); 
		return 0 ;	
	}
	else
	{
		fprintf( stdout, "%%Test: Port %d, composite write succeeds\n", port );
		return 1 ;
	}
}

writeport( port )
int	port ;
{
int	count ;
int	status ;

	/*	Write on outport	*/

	while( (status = DTMavailWrite( port )) == FALSE ) 
	{
		fprintf( stdout, "%%Test: availWrite == FALSE\n" );
	}
	if( status != TRUE )
	{
		fprintf( stderr, "%%Test: Port %d, availWrite fails %s\n",
				port, sherr( DTMerrno ) ) ;
		return 0 ;
	}
	else
	{
		fprintf( stdout, "%%Test: Port %d, availWrite success\n", port );
	}
	
	if( DTMbeginWrite( port, MSGHEADER, sizeof( MSGHEADER ) ) == DTMERROR )
	{
		fprintf( stderr, "%%Test: ERROR - Outport %d beginWrite, %s\n",
			 port, sherr( DTMerrno ) );
		return 0 ;
	} 
	else
	{
		fprintf( stdout, "%%Test: Port %d - Header '%s' written\n", port, MSGHEADER );
	}
	PAUSE ;

	count = 0 ;
	while( count < 2 )
	{
	int	size ;
	int	status ;

		if( count != 1 ) size = sizeof( MSGDATA ) - 1 ;
		else size = sizeof( MSGDATA );

		while( (status = DTMavailWrite( port )) == FALSE ) 
		{
			fprintf( stdout, "%%Test: availWrite == FALSE\n" );
		}
		if( status != TRUE )
		{
			fprintf( stderr, "%%Test: Port %d, availWrite fails %s\n",
					port, sherr( DTMerrno ) ) ;
			return 0 ;
		}
		else
		{
			fprintf( stdout, "%%Test: Port %d, availWrite success\n", port );
		}
		if( DTMwriteDataset( port, MSGDATA, size, DTM_CHAR ) == DTMERROR )
		{
			fprintf( stderr, "%%Test: ERROR - Outport %d writeDataset, %s\n",
				 port, sherr( DTMerrno ) );
			return 0 ;
		}
		else
		{
			fprintf( stdout, "%%Test: Port %d - %d. Data '%s' written\n", port, count, MSGDATA );
		}
		++count ;
	}

	if( DTMendWrite( port ) == DTMERROR )
	{
		fprintf( stderr, "%%Test: ERROR - Outport %d endWrite, %s\n",
			 port, sherr( DTMerrno ) );
		return 0 ;
	}	
	else
	{
		fprintf( stdout, "%%Test: Port %d - Write over\n", port );
	}
}

int	DTMtestSwitch( outpname )
char	*outpname ;
{
	int		outport[ TEST_DTM_PORTS ] ;
	char	buf[ MAXMSGLEN ] ;
	int		temp ;
	int		count ;
	int		total ;
	int		qservice = DTM_ASYNC ;

	/* Open 3 connections to server	*/

	for( temp = 0 ; temp < 3 ; temp++ )
	{
		/*	
			Open the out port. 
		*/
		fprintf( stdout, "OPENING PORT %s\n", outpname );
		if( (outport[ temp ] = DTMmakeOutPort( outpname, qservice )) == DTMERROR )
		{
			fprintf( stderr, "%%Test: Outport open error, %s\n", sherr( DTMerrno ) );
			return 0 ;
		}
		else
		{
			fprintf( stdout, "%%Test: Outport %d opened\n", temp );
		}
		qservice = DTM_SYNC ;
		outpname[ strlen( outpname ) - 1 ] += 1 ;	 
	}
	
	/*	Alternatively write to same server using all 3 connections.	*/

	fprintf( stdout, "Testing alternate writemsg/writeport\n" );
	count = 0 ;
	total = 0 ;
	while( count < 5 )
	{
		for( temp = 0 ; temp < 3 ; temp++ )
		{
			writemsg( outport[ temp ] );
			writeport( outport[ temp ] );
			writemsg( outport[ temp ] );
			writeport( outport[ temp ] );
			writemsg( outport[ temp ] );
			writeport( outport[ temp ] );
			PAUSE ;	
		}
		
		count++ ;
	}

	fprintf( stdout, "Testing writemsg\n" );
	count = 0 ;
	while( count < 10 )
	{
		for( temp = 0 ; temp < 3 ; temp++ )
		{
			writemsg( outport[ temp ] );
		}
		PAUSE ;	
		count++ ;
	}

	fprintf( stdout, "Testing writeport\n" );
	count = 0 ;
	while( count < 10 )
	{
		for( temp = 0 ; temp < 3 ; temp++ )
		{
			writeport( outport[ temp ] );
		}
		PAUSE ;	
		count++ ;
	}

	/* Close the 3 connections	*/

	for( temp = 0 ; temp < 3 ; temp++ )
	{
		/*	Close the out port.		*/

		if( DTMdestroyPort( outport[ temp ] ) == DTMERROR )
		{
			fprintf( stderr, "%%Test: Outport %d destroy error, %s\n", outport[ temp ], sherr( DTMerrno ) );
			return 0 ;
		}
	}

	return 1 ;
}
