/**********************************************************************
**
** server.c - main module for the text based DTM port server.
**
**	Jeff Terstriep			jefft@ncsa.uiuc.edu
**	Networking Development Group
**	National Center for Supercomputing Applications
**
**********************************************************************/

/*
 * $Log: server.c,v $
 * Revision 1.4  1991/11/15  19:44:20  jplevyak
 * Add definition for FALSE (removed indirect dependacy on dtmint.h).
 *
 * Revision 1.3  1991/10/29  17:15:59  jplevyak
 * Modified to add a quiet mode, and to terminate after it has made
 * all the connections when it is reading from a file.
 *
 * Revision 1.2  1991/10/16  23:23:14  jplevyak
 * Added some debugging statements.
 *
 * Revision 1.1  1991/10/11  23:16:11  jefft
 * Initial revision
 *
 */

#include	<stdio.h>
#include	<string.h>
#include	"debug.h"

#define	FALSE	0
#define	TRUE	1

int server_fd = -1;
int	quietMode = FALSE;

/*
**
** The following function are called from within yyparse(), these function
** should call the function appropriate for this particular application.
**
*/

agentStatement(agent, inports, outports, path, args)
  char  *agent, **inports, **outports, *path, *args;
{
  addAgent(agent, inports, outports, path, args);
}


invokeStatement(refname, agent, x, y)
  char	*refname, *agent;
  int	x, y;
{
  invokeProcess(refname, agent);
}


connectStatement(src, dstlist)
  char  *src, **dstlist;
{
  makeRouting(src, dstlist);
}




static void usage(p)
  char 	*p;
{

  fprintf(stderr, "Usage: %s [-f <filename>] [-addr <DTM port>] [-help]\n", p);
  fprintf(stderr, "\tIf input file is not given %s reads from stdin.\n", p);
  exit(-1);
}


main(argc, argv)
  int	argc;
  char	*argv[];
{
  int	i, done = 0;
  int	fromFile = FALSE;
  FILE	*infile = NULL;
  char	line[256], regmsg[256], *token;

  /* default input file from stdin */
  infile = stdin;


  /* parse command line arguements */
  for (i=1; i<argc; i+=1)
    if (!strcmp(argv[i], "-f"))  {
	  fromFile = TRUE;
      if ((infile = fopen(argv[++i], "r")) == NULL)  {
        fprintf(stderr, "Error: could not open config file.\n");
        exit(-1);
        }
      }

    else if (!strcmp(argv[i], "-addr"))  {
      if ((server_fd = DTMmakeNameServerPort(argv[++i])) == -1)  {
        fprintf(stderr ,"Error: could not create port: '%s'\n", argv[i]);
        exit(-1);
        }
      }

    else if (!strcmp(argv[i], "-help"))
      usage(argv[0]);

	else if (!strcmp(argv[i], "-d" ))
	  uDTMdbg = -1; 

	else if (!strcmp(argv[i], "-q" ))
	  quietMode = TRUE; 


  /* create dynamically assigned name server port (if necessary) */
  if (server_fd == -1)
    if ((server_fd = DTMmakeNameServerPort(":0")) == -1)  {
      fprintf(stderr, "Error: could not create name server port.\n");
      exit(-1);
      }

  /* get the address of the nameserver */
  DTMgetNameServerAddr(server_fd, line, sizeof line);
  initServerAddr(line);

  /* parse file  */
  while (fgets(line, sizeof line, infile) != NULL)  {
    lexi_buf(line); yyparse();

    if (DTMrecvRegistration(server_fd, regmsg, sizeof regmsg))
      registerPort(regmsg);
    }

  while (1) {
	sleep( 1 );
    if (DTMrecvRegistration(server_fd, regmsg, sizeof regmsg))  {
      registerPort(regmsg);
      if ( establishAllRoutes(server_fd) && fromFile ) break; 
	  }
	}
}
