/************************************************************************
**
** Reader - sample reader.  Simply reads each header message and prints
**		it to stderr.
**
************************************************************************/

/*
 * $Log: reader.c,v $
 * Revision 1.2  1991/10/15  18:17:46  jplevyak
 * Changed DTMSYNC to DTM_SYNC
 *
 * Revision 1.1  1991/10/11  23:16:06  jefft
 * Initial revision
 *
 */

#include	<stdio.h>
#include	<dtm.h>


main(argc, argv)
  int	argc;
  char	*argv[];
{
  int	i, inport = -1;
  char	header[DTM_MAX_HEADER];


  /* scan the command line for port information */
  for (i=1; i<argc; i+=1)
    if (!strcmp(argv[i], "-DTMIN"))
      inport = DTMmakeInPort(argv[++i], DTM_SYNC);

  /* make sure the port has been initialized */
  if (inport == -1)  {
    fprintf(stderr,"%s: Error - couldn't open port\n", argv[0]);
    exit(-1);
    }

  /* receive each message and print header				*/
  /* this program will eventually die when no new messages are sent	*/
  /* within the timeout period (currently 2 minutes).			*/

  while (DTMbeginRead(inport, header, sizeof header) >= 0)  {
    DTMendRead(inport);
    fprintf(stderr, "Header recieved = '%s'\n", header);
    }
}
