* **********************************************************************
* ** NOAA/USGS GENERAL MAP PROJECTION PACKAGE ..... DR. A. A. ELASSAL **
* **          MATHEMATICAL ANALYSIS BY JOHN SNYDER                    **
* ** GCTP/II                 VERSION 1.0.2           SEPTEMBER 1,1986 **
* **********************************************************************
*              *  GENERAL VERTICAL NEAR-SIDE PERSPECTIVE  *
* **********************************************************************
*
      SUBROUTINE PJ15Z0
*
      IMPLICIT REAL*8 (A-Z)
      INTEGER*4 SWITCH,I,ZONE,IPFILE,IFLG
      CHARACTER*16 ANGS(2)
      COMMON /SPHRZ0/ AZZ
* **** PARAMETERS **** A,P,LON0,LAT0,X0,Y0,SINPH0,COSPH0 ***************
      DIMENSION DATA(1),GEOG(1),PROJ(1)
      DATA HALFPI /1.57079632679489661923D0/
      DATA EPSLN /1.0D-10/
      DATA ZERO,ONE /0.0D0,1.0D0/
      DATA SWITCH /0/
*
* ......................................................................
*      .  INITIALIZATION OF PROJECTION PARAMETERS (ENTRY INPUT)  .
* ......................................................................
*
      ENTRY IS15Z0 (ZONE,DATA,IPFILE,IFLG)
*
      IFLG = 0
      IF (SWITCH.NE.0 .AND. SWITCH.EQ.ZONE) RETURN
      A = DATA(1)
      IF (A .LE. ZERO) A = AZZ
      P = ONE + DATA(3) / A
      CALL UNITZ0 (DATA(5),5,LON0,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      CALL UNITZ0 (DATA(6),5,LAT0,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      X0 = DATA(7)
      Y0 = DATA(8)
      SINPH0 = DSIN (LAT0)
      COSPH0 = DCOS (LAT0)
*
* LIST RESULTS OF PARAMETER INITIALIZATION.
*
      CALL DMSLZ0 (LON0,0,ANGS(1),IPFILE,IFLG)
      CALL DMSLZ0 (LAT0,0,ANGS(2),IPFILE,IFLG)
      IF (IPFILE .NE. 0) WRITE (IPFILE,2000) A,DATA(3),ANGS,X0,Y0
 2000 FORMAT (' INITIALIZATION PARAMETERS (GENERAL VERTICAL NEAR-SIDE',
     .        ' PERSPECTIVE PROJECTION)'/
     .        ' RADIUS OF SPHERE             =',F16.4,' METERS'/
     .        ' HEIGHT OF PERSPECTIVE POINT'/
     .        ' ABOVE SPHERE                 =',F16.4,' METERS'/
     .        ' LONGITUDE OF CENTER          =',A16/
     .        ' LATITUDE  OF CENTER          =',A16/
     .        ' FALSE EASTING                =',F16.4,' METERS'/
     .        ' FALSE NORTHING               =',F16.4,' METERS')
      SWITCH = ZONE
      RETURN
*
* ......................................................................
*                      .  FORWARD TRANSFORMATION  .
* ......................................................................
*
      ENTRY PF15Z0 (GEOG,PROJ,IFLG)
*
      IFLG = 0
      IF (SWITCH .NE. 0) GO TO 120
      IF (IPFILE .NE. 0) WRITE (IPFILE,2010)
 2010 FORMAT (' UNINITIALIZED TRANSFORMATION')
      IFLG = 1500
      RETURN
  120 LON = ADJLZ0 (GEOG(1) - LON0)
      SINPHI = DSIN (GEOG(2))
      COSPHI = DCOS (GEOG(2))
      COSLON = DCOS (LON)
      G = SINPH0 * SINPHI + COSPH0 * COSPHI * COSLON
      IF (G .GE. (ONE / P)) GO TO 140
      IF (IPFILE .NE. 0) WRITE (IPFILE,2020)
 2020 FORMAT (' POINT CANNOT BE PROJECTED')
      IFLG = 1501
      RETURN
  140 KSP = (P - ONE) / (P - G)
      PROJ(1) = X0 + A * KSP * COSPHI * DSIN (LON)
      PROJ(2) = Y0 + A * KSP * (COSPH0 * SINPHI - SINPH0 * COSPHI *
     .          COSLON)
      RETURN
*
* ......................................................................
*                      .  INVERSE TRANSFORMATION  .
* ......................................................................
*
      ENTRY PI15Z0 (PROJ,GEOG,IFLG)
*
      IFLG = 0
      IF (SWITCH .NE. 0) GO TO 220
      IF (IPFILE .NE. 0) WRITE (IPFILE,2010)
      IFLG = 1500
      RETURN
  220 X = PROJ(1) - X0
      Y = PROJ(2) - Y0
      RH = DSQRT (X * X + Y * Y)
      R = RH / A
      CON = P - ONE
      COM = P + ONE
      IF (R .LE. DSQRT (CON / COM)) GO TO 230
      IF (IPFILE .NE. 0) WRITE (IPFILE,2030)
 2030 FORMAT (' IMPROPER PARAMETER')
      IFLG = 1502
      RETURN
  230 SINZ = (P - DSQRT (ONE - R * R * COM / CON)) /
     .       (CON / R + R / CON)
      Z = ASINZ0 (SINZ)
      SINZ = DSIN (Z)
      COSZ = DCOS (Z)
      GEOG(1) = LON0
      IF (DABS(RH) .GT. EPSLN) GO TO 240
      GEOG(2) = LAT0
      RETURN
  240 GEOG(2) = ASINZ0 (COSZ * SINPH0 + Y * SINZ * COSPH0 / RH)
      CON = DABS (LAT0) - HALFPI
      IF (DABS (CON) .GT. EPSLN) GO TO 260
      IF (LAT0 .LT. ZERO) GO TO 250
      GEOG(1) = ADJLZ0 (LON0 + DATAN2 (X , -Y))
      RETURN
  250 GEOG(1) = ADJLZ0 (LON0 - DATAN2 (-X , Y))
      RETURN
  260 CON = COSZ - SINPH0 * DSIN (GEOG(2))
      IF (DABS(CON).LE.EPSLN .AND. DABS(X).LE.EPSLN) RETURN
      GEOG(1) = ADJLZ0 (LON0 + DATAN2 ((X*SINZ*COSPH0) , (CON*RH)))
      RETURN
*
      END
