* **********************************************************************
* ** NOAA/USGS GENERAL MAP PROJECTION PACKAGE ..... DR. A. A. ELASSAL **
* **          MATHEMATICAL ANALYSIS BY JOHN SNYDER                    **
* ** GCTP/II                 VERSION 1.0.2           SEPTEMBER 1,1986 **
* **********************************************************************
*                       *  TRANSVERSE MERCATOR  *
* **********************************************************************
*
      SUBROUTINE PJ09Z0
*
      IMPLICIT REAL*8 (A-Z)
      INTEGER*4 SWITCH,I,ZONE,IND,NIT,IPFILE,IFLG
      CHARACTER*16 ANGS(2)
      COMMON /ELLPZ0/ AZ,EZ,ESZ,E0Z,E1Z,E2Z,E3Z,E4Z
* * PARAMETERS **** A,E,ES,KS0,LON0,LAT0,X0,Y0,E0,E1,E2,E3,ESP,ML0,IND *
      DIMENSION DATA(1),GEOG(1),PROJ(1)
      DATA ZERO,HALF,ONE,TWO,THREE /0.0D0,0.5D0,1.0D0,2.0D0,3.0D0/
      DATA FOUR,FIVE,SIX,EIGHT,NINE /4.0D0,5.0D0,6.0D0,8.0D0,9.0D0/
      DATA HALFPI /1.57079632679489661923D0/
      DATA TEN /10.0D0/
      DATA TOL,EPSLN,NIT /1.0D-5,1.0D-10,6/
      DATA SWITCH /0/
*
* ......................................................................
*      .  INITIALIZATION OF PROJECTION PARAMETERS (ENTRY INPUT)  .
* ......................................................................
*
      ENTRY IS09Z0 (ZONE,DATA,IPFILE,IFLG)
*
      IFLG = 0
      IF (SWITCH.NE.0 .AND. SWITCH.EQ.ZONE) RETURN
      IF (DATA(1) .LE. ZERO) GO TO 100
      A = DATA(1)
      B = DATA(2)
      IF (B .GT. ZERO) GO TO 040
      E = ZERO
      ES = ZERO
      E0 = ONE
      E1 = ZERO
      E2 = ZERO
      E3 = ZERO
      GO TO 120
  040 IF (B .GT. ONE) GO TO 060
      E = DSQRT (B)
      ES = B
      GO TO 080
  060 ES = ONE - (B / A) ** 2
      E = DSQRT (ES)
  080 E0 = E0FNZ0 (ES)
      E1 = E1FNZ0 (ES)
      E2 = E2FNZ0 (ES)
      E3 = E3FNZ0 (ES)
      GO TO 120
  100 A = AZ
      E = EZ
      ES = ESZ
      E0 = E0Z
      E1 = E1Z
      E2 = E2Z
      E3 = E3Z
  120 KS0 = DATA(3)
      CALL UNITZ0 (DATA(5),5,LON0,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      CALL UNITZ0 (DATA(6),5,LAT0,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      X0 = DATA(7)
      Y0 = DATA(8)
      ML0 = A * MLFNZ0 (E0,E1,E2,E3,LAT0)
      IND = 1
      IF (E .LT. TOL) GO TO 130
      IND = 0
      ESP = ES / (ONE - ES)
*
* LIST RESULTS OF PARAMETER INITIALIZATION.
*
  130 CALL DMSLZ0 (LON0,0,ANGS(1),IPFILE,IFLG)
      CALL DMSLZ0 (LAT0,0,ANGS(2),IPFILE,IFLG)
      IF (IPFILE .NE. 0) WRITE (IPFILE,2000) A,ES,KS0,ANGS,X0,Y0
 2000 FORMAT (' INITIALIZATION PARAMETERS (TRANSVERSE MERCATOR',
     .        ' PROJECTION)'/
     .        ' SEMI-MAJOR AXIS OF ELLIPSOID =',F16.4,' METERS'/
     .        ' ECCENTRICITY SQUARED         =',F16.13/
     .        ' SCALE FACTOR AT C. MERIDIAN  =',F9.6/
     .        ' LONGITUDE OF C. MERIDIAN     =',A16/
     .        ' LATITUDE OF ORIGIN           =',A16/
     .        ' FALSE EASTING                =',F16.4,' METERS'/
     .        ' FALSE NORTHING               =',F16.4,' METERS')
      SWITCH = ZONE
      RETURN
*
* ......................................................................
*                      .  FORWARD TRANSFORMATION  .
* ......................................................................
*
      ENTRY PF09Z0 (GEOG,PROJ,IFLG)
*
      IFLG = 0
      IF (SWITCH .NE. 0) GO TO 220
      IF (IPFILE .NE. 0) WRITE (IPFILE,2010)
 2010 FORMAT (' UNINITIALIZED TRANSFORMATION')
      IFLG = 900
      RETURN
  220 DLON = ADJLZ0 (GEOG(1) - LON0)
      LAT = GEOG(2)
      IF (IND .EQ. 0) GO TO 240
      COSPHI = DCOS (LAT)
      B = COSPHI * DSIN (DLON)
      IF (DABS(DABS(B) - ONE) .GT. EPSLN) GO TO 230
      IF (IPFILE .NE. 0) WRITE (IPFILE,2020)
 2020 FORMAT (' POINT PROJECTS INTO INFINITY')
      IFLG = 901
      RETURN
  230 PROJ(1) = HALF * A * KS0 * DLOG ((ONE + B) / (ONE - B))
      CON = DACOS (COSPHI * DCOS (DLON) / DSQRT (ONE - B * B))
      IF (LAT .LT. ZERO) CON =-CON
      PROJ(2) = A * KS0 * (CON - LAT0)
      RETURN
*
  240 SINPHI = DSIN (LAT)
      COSPHI = DCOS (LAT)
      AL = COSPHI * DLON
      ALS = AL * AL
      C = ESP * COSPHI * COSPHI
      TQ = DTAN (LAT)
      T = TQ * TQ
      N = A / DSQRT (ONE - ES * SINPHI * SINPHI)
      ML = A * MLFNZ0 (E0,E1,E2,E3,LAT)
      PROJ(1) = KS0 * N * AL * (ONE + ALS / SIX * (ONE - T + C +
     .          ALS / 20.0D0 * (FIVE - 18.0D0 * T + T * T + 72.0D0 *
     .          C - 58.0D0 * ESP))) + X0
      PROJ(2) = KS0 * (ML - ML0 + N * TQ * (ALS * (HALF + ALS / 24.0D0 *
     .          (FIVE - T + NINE * C + FOUR * C * C + ALS / 30.0D0 *
     .          (61.0D0 - 58.0D0 * T + T * T + 600.0D0 * C -
     .          330.0D0 * ESP))))) + Y0
      RETURN
*
* ......................................................................
*                      .  INVERSE TRANSFORMATION  .
* ......................................................................
*
      ENTRY PI09Z0 (PROJ,GEOG,IFLG)
*
      IFLG = 0
      IF (SWITCH .NE. 0) GO TO 320
      IF (IPFILE .NE. 0) WRITE (IPFILE,2010)
      IFLG = 900
      RETURN
  320 X = PROJ(1) - X0
      Y = PROJ(2) - Y0
      IF (IND .EQ. 0) GO TO 340
      F = DEXP (X / (A * KS0))
      G = HALF * (F - ONE / F)
      C = LAT0 + Y / (A * KS0)
      H = DCOS (C)
      CON = DSQRT ((ONE - H * H) / (ONE + G * G))
      GEOG(2) = ASINZ0 (CON)
      IF (C .LT. ZERO) GEOG(2) =-GEOG(2)
      IF (G.NE.ZERO .OR. H.NE.ZERO) GO TO 330
      GEOG(1) = LON0
      RETURN
  330 GEOG(1) = ADJLZ0 (DATAN2 (G,H) + LON0)
      RETURN
*
  340 CON = (ML0 + Y / KS0) / A
      PHI = PHI3Z0 (CON,E0,E1,E2,E3,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      IF (DABS(PHI) .LT. HALFPI) GO TO 400
      GEOG(2) = DSIGN (HALFPI , Y)
      GEOG(1) = LON0
      RETURN
  400 SINPHI = DSIN (PHI)
      COSPHI = DCOS (PHI)
      TANPHI = DTAN (PHI)
      C = ESP * COSPHI * COSPHI
      CS = C * C
      T = TANPHI * TANPHI
      TS = T * T
      CON = ONE - ES * SINPHI * SINPHI
      N = A / DSQRT (CON)
      R = N * (ONE - ES) / CON
      D = X / (N * KS0)
      DS = D * D
      GEOG(2) = PHI - (N * TANPHI * DS / R) * (HALF - DS / 24.0D0 *
     .          (FIVE + THREE * T + TEN * C - FOUR * CS - NINE * ESP -
     .          DS / 30.0D0 * (61.0D0 + 90.0D0 * T + 298.0D0 * C +
     .          45.0D0 * TS - 252.0D0 * ESP - THREE * CS)))
      GEOG(1) = ADJLZ0 (LON0 + (D * (ONE - DS / SIX * (ONE + TWO *
     .          T + C - DS / 20.0D0 * (FIVE - TWO * C + 28.0D0 * T -
     .          THREE * CS + EIGHT * ESP + 24.0D0 * TS))) / COSPHI))
      RETURN
*
      END
