* **********************************************************************
* ** NOAA/USGS GENERAL MAP PROJECTION PACKAGE ..... DR. A. A. ELASSAL **
* **          MATHEMATICAL ANALYSIS BY JOHN SNYDER                    **
* ** GCTP/II                 VERSION 1.0.2           SEPTEMBER 1,1986 **
* **********************************************************************
*                            *  MERCATOR  *
* **********************************************************************
*
      SUBROUTINE PJ05Z0
*
      IMPLICIT REAL*8 (A-Z)
      INTEGER*4 SWITCH,I,ZONE,IPFILE,IFLG
      CHARACTER*16 ANGS(2)
      COMMON /ELLPZ0/ AZ,EZ,ESZ,E0Z,E1Z,E2Z,E3Z,E4Z
* **** PARAMETERS **** A,E,ES,LON0,X0,Y0,NS,F,RH0,LAT1,M1 **************
      DIMENSION DATA(1),GEOG(1),PROJ(1)
      DATA HALFPI /1.57079632679489661923D0/
      DATA EPSLN /1.0D-10/
      DATA ZERO,ONE /0.0D0,1.0D0/
      DATA SWITCH /0/
*
* ......................................................................
*      .  INITIALIZATION OF PROJECTION PARAMETERS (ENTRY INPUT)  .
* ......................................................................
*
      ENTRY IS05Z0 (ZONE,DATA,IPFILE,IFLG)
*
      IFLG = 0
      IF (SWITCH.NE.0 .AND. SWITCH.EQ.ZONE) RETURN
      IF (DATA(1) .LE. ZERO) GO TO 100
      A = DATA(1)
      B = DATA(2)
      IF (B .GT. ZERO) GO TO 040
      E = ZERO
      ES = ZERO
      GO TO 120
  040 IF (B .GT. ONE) GO TO 060
      E = DSQRT (B)
      ES = B
      GO TO 120
  060 ES = ONE - (B / A) ** 2
      E = DSQRT (ES)
      GO TO 120
  100 A = AZ
      E = EZ
      ES = ESZ
  120 CALL UNITZ0 (DATA(5),5,LON0,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      CALL UNITZ0 (DATA(6),5,LAT1,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      M1 = DCOS(LAT1) / (DSQRT( ONE - ES * DSIN(LAT1) **2))
      X0 = DATA(7)
      Y0 = DATA(8)
*
* LIST RESULTS OF PARAMETER INITIALIZATION.
*
      CALL DMSLZ0 (LAT1,0,ANGS(1),IPFILE,IFLG)
      CALL DMSLZ0 (LON0,0,ANGS(2),IPFILE,IFLG)
      IF (IPFILE .NE. 0) WRITE (IPFILE,2000) A,ES,ANGS,X0,Y0
 2000 FORMAT (' INITIALIZATION PARAMETERS (MERCATOR',
     .        ' PROJECTION)'/
     .        ' SEMI-MAJOR AXIS OF ELLIPSOID =',F16.4,' METERS'/
     .        ' ECCENTRICITY SQUARED         =',F16.13/
     .        ' LATITUDE OF TRUE SCALE       =',A16/
     .        ' CENTRAL LONGITUDE            =',A16/
     .        ' FALSE EASTING                =',F16.4,' METERS'/
     .        ' FALSE NORTHING               =',F16.4,' METERS')
      SWITCH = ZONE
      RETURN
*
* ......................................................................
*                      .  FORWARD TRANSFORMATION  .
* ......................................................................
*
      ENTRY PF05Z0 (GEOG,PROJ,IFLG)
*
      IFLG = 0
      IF (SWITCH .NE. 0) GO TO 220
      IF (IPFILE .NE. 0) WRITE (IPFILE,2010)
 2010 FORMAT (' UNINITIALIZED TRANSFORMATION')
      IFLG = 500
      RETURN
  220 IF (DABS(DABS(GEOG(2)) - HALFPI) .GT. EPSLN) GO TO 240
      IF (IPFILE .NE. 0) WRITE (IPFILE,2020)
 2020 FORMAT (' TRANSFORMATION CANNOT BE COMPUTED AT THE POLES')
      IFLG = 501
      RETURN
  240 SINPHI = DSIN (GEOG(2))
      TS = TSFNZ0 (E,GEOG(2),SINPHI)
      PROJ(1) = X0 + A * M1 * ADJLZ0 (GEOG(1) - LON0)
      PROJ(2) = Y0 - A * M1 * DLOG (TS)
      RETURN
*
* ......................................................................
*                      .  INVERSE TRANSFORMATION  .
* ......................................................................
*
      ENTRY PI05Z0 (PROJ,GEOG,IFLG)
*
      IFLG = 0
      IF (SWITCH .NE. 0) GO TO 260
      IF (IPFILE .NE. 0) WRITE (IPFILE,2010)
      IFLG = 500
      RETURN
  260 X = PROJ(1) - X0
      Y = PROJ(2) - Y0
      TS = DEXP (- Y / (A * M1))
      GEOG(2) = PHI2Z0 (E,TS,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      GEOG(1) = ADJLZ0 (LON0 + X / (A * M1))
      RETURN
*
      END
