/* SCCS @(#)preenhfdfham.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      preenhfdfham.layout.c                           */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   preenhfdfham.layout.c                               */
/*                                                                      */
/* DESCRIPTION  :   Preprocessing enhancement (Hamming filter)          */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "widgetstructure.h"
#include "preenhfdfham.layout.h"

#define MAX_ARGS 100
#define MIN(A,B)    ((A)<(B)?(A):(B))

extern XmFontList gFontlist, gSmall_fontlist;


static void 
param_SET_callb (options_OK, Paramprepro, callData)
     Widget options_OK;
     xs_struc_paramprepro *Paramprepro;
     caddr_t callData;
{
  char stitre[30];
  int radius;
  
  radius = (int) ((MIN(dir_desc[index_image[0]].nligne, dir_desc[index_image[0]].ncolonne) + 1)/10);
  sprintf (stitre, "%d", radius); 
  XmTextSetString (Paramprepro->alpha, stitre);
}


/********************************************************
/   Creation Function for PREPRO_hamming_param_widget 
/*******************************************************/

xs_struc_paramprepro
* build_PREPRO_hamming_param_widget(PREPRO_hamming_filter_param)
	Widget PREPRO_hamming_filter_param;
{
	Widget PREPRO_hamming_param_widget;
	Widget param_SET;
	Widget hamming_radius_Label_2;
	Widget Coefficient_text;
	xs_struc_paramprepro *Paramprepro;
	Widget PREPRO_hamming_Label_3;
	Widget radius_min_Label_0;
	Widget radius_max_Label_1;
	Arg args[MAX_ARGS];
	int n;

	Paramprepro = 
	  (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));

	/* Creating PREPRO_hamming_param_widget Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight,240); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,199); n++;
	XtSetArg(args[n],XmNx,1); n++;

	PREPRO_hamming_param_widget = 
	       XmCreateForm(PREPRO_hamming_filter_param,
			    "PREPRO_hamming_param_widget",args,n);
	XtManageChild(PREPRO_hamming_param_widget);

	Paramprepro->parent = PREPRO_hamming_param_widget;

	/* Creating param_SET Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNbottomPosition,96); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[106],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 20); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition, 80); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition, 84); n++;


	param_SET = XmCreatePushButton(PREPRO_hamming_param_widget, 
				       "param_SET",args,n);

	XtManageChild(param_SET);

	
	/* Adding Callbacks for param_SET */ 

	XtAddCallback(param_SET,XmNactivateCallback,
		      param_SET_callb, Paramprepro);


	/* Creating hamming_radius_Label_2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[487],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,5); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,30); n++;

	hamming_radius_Label_2 = 
	         XmCreateLabel(PREPRO_hamming_param_widget,
			       "hamming_radius_Label_2",args,n);
	XtManageChild(hamming_radius_Label_2);

	/* Creating Coefficient_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,15); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,53); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,50); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	Coefficient_text = 
	  XmCreateText(PREPRO_hamming_param_widget,"Coefficient_text",args,n);
	XtManageChild(Coefficient_text);

	Paramprepro->alpha = Coefficient_text;

	/* Creating PREPRO_hamming_Label_3 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[498],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PREPRO_hamming_Label_3 = 
	       XmCreateLabel(PREPRO_hamming_param_widget,
			     "PREPRO_hamming_Label_3",args,n);
	XtManageChild(PREPRO_hamming_Label_3);

	/* Creating radius_min_Label_0 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_END); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("0 <",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,13); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,50); n++;

	radius_min_Label_0 = 
	      XmCreateLabel(PREPRO_hamming_param_widget,
			    "radius_min_Label_0",args,n);
	XtManageChild(radius_min_Label_0);

	/* Creating radius_max_Label_1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("< (size img/2)",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,55); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,50); n++;

	radius_max_Label_1 = 
	      XmCreateLabel(PREPRO_hamming_param_widget,
			    "radius_max_Label_1",args,n);
	XtManageChild(radius_max_Label_1);

	return(Paramprepro);
}
