/* SCCS @(#)urgent4.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      urgent4.c                                       */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   urgent4.c                                           */
/*                                                                      */
/* DESCRIPTION  :   Some operations                                     */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <sys/file.h>
#include <sys/time.h>
#include <stdio.h>
#include <strings.h>
#include <math.h>

#include "threshold4.h"

#define TAILLE	    1024


/*****************************************************************************/

static 
int min_max(image, lin, col, mmin, mmax)
int *image, lin, col, *mmin, *mmax;
{
    int *i, size, f, n;

    size = lin * col;
    i = image;
    *mmin = *mmax = *i;
    i++;

    for (n = 1 ; n < size; n++)
    {
	f = *i;
	if (f > *mmax) *mmax = f;
	if (f < *mmin) *mmin = f;
	i++;
    }
}

/*****************************************************************************/

int bilinear_interp(a1, a2, a3, a4, dx, dy, p)
    float a1, a2, a3, a4, *p;
    int dx, dy;
{
    float vx1, vx2, *t;
    int i, j;

    t = p;

    for (j = 0; j <= dy; j++)
    {
	for (i = 0; i<= dx; i++)
	{
	    {
		vx1 = a1 + (a2 - a1) / dx * i;
		vx2 = a4 + (a3 - a4) / dx * i;
		*t = vx1 + (vx2 - vx1) / dy * j;
		t++;
	    }
	}
    }
}



/*****************************************************************************/
/*   use laplacian p-tile to create gray level histogram		     */
/*									     */
/*   calculate laplacian histogram and get the laplacian value corresponding */
/*   to the p_tile given by the user. filter the image with the laplacian    */
/*   value, use the pixels surviving the filter to construct histogram.	     */
/*****************************************************************************/

int lapla_ptl (image, imageout, ligne, colonne, ligneout, percnt)
    float *image;
    float **imageout;
    int ligne, colonne;
    int *ligneout;
    float percnt;
{
    int **im;
    int **tab;
    float *t, *p, *gradi;
    float sum;
    int i, j, mx, thr, index, count;

    mx = 30000;		    /* the maximum possible laplacian value */
    gradi = (float *)calloc(mx, sizeof(float));
			    /* locat lapla_histogram table	     */

    im = (int **)malloc((ligne + 2) * sizeof(int *));
    for (i = 0; i < ligne + 2; i++)
    {
	im[i] = (int *)calloc((colonne + 2), sizeof(int));
    }
			    /* image space for padding prolongation  */

    t = image;
    im[0][0] = *t;
    for (j = 1; j < colonne + 1; j++)
    {
	im[0][j] = *t;
	t++;
    }
    im[0][colonne + 1] = im[0][colonne];
			    /* fill up first line */

    t = image;
    for (i = 1; i < ligne + 1; i++)
    {
	im[i][0] = *t;
	for (j = 1; j < colonne + 1; j++)
	{
	    im[i][j] = *t;
	    t++;
	}
	im[i][colonne + 1] = im[i][colonne];
    }
			    /* fill left and right of the body */

    t = t - colonne;
    im[ligne + 1][0] = *t;
    for (j = 1; j < colonne + 1; j++)
    {
	im[ligne + 1][j] = *t;
	t++;
    }
    im[ligne + 1][colonne + 1] = im[ligne + 1][colonne];
			    /* fill up last line */

    tab = (int **)malloc(ligne * sizeof(int *));
    for (i = 0; i < ligne + 2; i++)
    {    
	tab[i] = (int *)calloc(colonne + 2, sizeof(int));
    }
			    /* locate space for laplacian calculation  */

    t = gradi;
    for (i = 0; i < mx; i++)
    {
	*t = 0;
	t++;
    }			  /* initialize lapla_histogram	       */

    for (i = 1; i < ligne + 1; i++)
    {
	for (j = 1; j < colonne + 1; j++)
	{
	    tab[i][j] = (int) (abs(im[i + 1][j]
				  + im[i - 1][j]
				  + im[i][j + 1]
				  + im[i][j - 1] - im[i][j] * 4)); 
			 /* calculate laplacian value of every pixel*/ 
	    index = tab[i][j];
	    if (index < mx)
		gradi[index] = gradi[index] + 1;
	    else
		gradi[mx - 1] = gradi[mx - 1] + 1; 
		        /* calculate laplacian histogram      */
	}
    }			  
    sum = 0;
    for (i = 0; i < mx; i++)
    {
	sum = sum + (float)gradi[i] / (ligne * colonne);
	if (sum >= percnt) goto st;
    }
    st: thr = i;

    count = 0;
    for (i = 1; i < ligne + 1; i++)
    {
	for (j = 1; j < colonne + 1; j++)
	{
	    if (tab[i][j] >= thr) 
	    {
		tab[i][j] = 1;
		count++;
	    }
	    else tab[i][j] = 0;
	}
    }		/* count the points who have higher laplacian_value  */  

    *imageout = p = (float *)malloc(count * sizeof(float));
 
    for (i = 1; i < ligne + 1; i++)
    {
	for (j = 1; j < colonne + 1; j++)
	{
	    if (tab[i][j] != 0)
	    {
		*p = im[i][j];
		p++;
	    }
	}
    }		/* transfer these pixels into intermediate plane     */
    if (count % 2 != 0) count--;
    *ligneout = count / 2;

    free(gradi);
    for (i = 0; i < ligne + 2; i++) {
	free(tab[i]);
	free(im[i]);
    }
    free(im);
    free(tab);

    return(0);
}


/****************************************************************************/
/*  create a reference plane of dynamic threshold, save in index_image[1]   */
/*  for time being							    */
/****************************************************************************/

int cre_plan_ref(imdep, col, lin, imarr, d)
    float *imdep;
    int col, lin;
    float **imarr;
    int d;
{
    int *block_c, *t;
    float *bc, *bcr;
    int verticl, horizon, l, c, stpoint;
    int mnn, mxx, modval, value;
    int h_num, v_num;
    float thr_array[256][256], *interp, *p;
    int **DHIST;
    int  range;

    v_num = lin / d;	    /* num. of blocks per column */
    h_num = col / d;	    /* num. of blocks per line   */   

    block_c = (int *)calloc(d * d, sizeof(int));
    interp = (float *)calloc((d + 1) * (d + 1), sizeof(float));  

    bc = imdep;
    *imarr = bcr = (float *)calloc((lin - d) * (col - d), sizeof(float));
    for (verticl = 0; verticl < v_num; verticl++)
    {
	for (horizon = 0; horizon < h_num; horizon++)
	{
	    stpoint = verticl * col * d + horizon * d;
	    t = block_c;
	    for (l = 0; l < d; l++)	   /* extract one block into block_c*/
	    {
		for (c = 0; c < d; c++)
		{
		    *t = bc[stpoint + c];
		    t++; 
		}
	        stpoint = stpoint + col;
	    }
	    min_max(block_c, d, d, &mnn, &mxx); 
					  /* calculate its min & max */
	    if (mxx <= 255) range = 256; else range = mxx + 1;
	    modval = 1;
	    value = diff_hist_thresh(block_c, d, d, &DHIST, range,
				     mnn, mxx, modval);
					   /* select local threshold */
	    thr_array[verticl][horizon] = (float)value;
	}
    }

    for (verticl = 0; verticl < v_num - 1; verticl++)  /*create thresh plane */
    {
	for (horizon = 0; horizon < h_num - 1; horizon++)
	{
	 stpoint = verticl * (col - d) * d + horizon * d;
	 p = interp;		     /* create one block by interpolation */
	 bilinear_interp(thr_array[verticl][horizon],
			 thr_array[verticl][horizon + 1],
			 thr_array[verticl + 1][horizon + 1],
			 thr_array[verticl + 1][horizon],
			 d,
			 d,
			 interp);
         for (l = 0; l < d; l++)  /*insert the block into thresh plane*/
	 {
	    for (c = 0; c < d; c++)
	     {
		bcr[stpoint + c] = *p;  /* *imarr[stpoint + c] = *p; */
		p++; 
	     }
	     p++;
	     stpoint = stpoint + col - d;
	 }
	}
    }
    free(block_c);
    free(interp);
    return(0);
}


/*****************************************************************************/

