/* SCCS @(#)affiche4.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      affiche4.c                                      */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   affiche4.c                                          */
/*                                                                      */
/* DESCRIPTION  :   Display operations                                  */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <stdio.h>
#include <sys/file.h>
#include "define.h"


extern unsigned char code2[4], code3[8];


/*****************************************************************************/
/*                							     */
/* nom      : affiche_image_color					     */
/*									     */
/* fonction : affiche une image avec 256 niveaux de gris lineaires ou	     */
/*	      logarithmiques				     		     */
/*									     */
/* entrees  : unsigned char *image      : pointeur sur image a afficher	     */
/*	      int table			: table de couleur a utiliser	     */
/*									     */
/* return   : neant						             */
/*								             */
/*****************************************************************************/

affiche_image_color (imagearr, image, type, ligne, colonne, mmin, mmax)
    unsigned char **imagearr;
    unsigned char *image;
    int type, ligne, colonne;
    float mmin, mmax;
{
    short *s;  
    int *i;
    float *f;
    register int j, jj, taille;
    register float facteur, fmin;
    unsigned char *d;

    taille = colonne * ligne;

    *imagearr = (unsigned char *)malloc(taille);

    d =  *imagearr;

    if (type == 0 || type == -1) {
             for (j=0; j<taille; j++) {
                *d = *image;
                d++;  image++;
            }
    }
    else {
        /* on initialise un pointeur du type desire sur l'image */
        switch (type) {
	    case 1: s = (short *) image; break;
	    case 2: i = (int *) image; break;
            case 3: f = (float *) image; break;
        }
        facteur = MAXBYTE / (mmax - mmin); 
        fmin = mmin;
        for (j=0; j<taille; j++) {
                switch (type) {
                    case 1 : *d = (unsigned char) ((*s - fmin) * facteur); 
                             s++;  break;
                    case 2 : *d = (unsigned char) ((*i - fmin) * facteur); 
                             i++;  break;
                    case 3 : *d = (unsigned char) ((*f - fmin) * facteur); 
                             f++;  break;
                }
                d++;
        }
    }
}

/*****************************************************************************/
/*                							     */
/* nom      : affiche_image						     */
/*									     */
/* fonction : affiche une image en noir et blanc en appliquant	             */
/*	      un seuil ou Floyd-Steinberg			             */
/*									     */
/* entrees  : unsigned char *image      : pointeur sur image a afficher	     */
/*	      int methode		: 1=seuil 2=repport d'erreur	     */
/*	      float seuil		: valeur du seuil pour l'affichage   */
/*									     */
/* return   : neant						             */
/*								             */
/*****************************************************************************/

affiche_image(imagearr, image, type, ligne, colonne, mmin, mmax, seuil, methode)
    unsigned char **imagearr;
    unsigned char *image;
    short type, ligne, colonne;
    float mmin, mmax, seuil;
    int   methode;
{
    float *f,ff,point,*err1,*err2,rr,e;
    register int x,y,xx;
    int *i;
    unsigned char *b;
    unsigned char *d;
    short *s;
    
    *imagearr = (unsigned char *)malloc(ligne*colonne);

    d =  *imagearr;

    err1 = (float *) malloc((colonne + 1) * sizeof(*err1));
    err2 = (float *) malloc((colonne + 1) * sizeof(*err2));

    /* on initialise un pointeur du type desire sur l'image */

    switch (type) {
	case -1:
        case 0: b = (unsigned char *) image; break;
	case 1:	s = (short *) image; break;
	case 2: i = (int *) image; break;
        case 3: f = (float *) image; break;
   }

   if (methode == 1) {

      /* methode du seuil */ 

      for ( y = 0 ; y < ligne ; y++)
            for ( x = 0 ; x < colonne ; x++) {
                switch (type) {
		    case -1:
	            case 0: point = (float) *b; b++ ; break;
        	    case 1: point = (float) *s; s++ ; break;
                    case 2: point = (float) *i; i++ ; break;
		    case 3: point = (float) *f; f++ ; break;
	         }
		if ( point > seuil)  *d = 255;
		else *d = 0;
		d++; 
        }
    }
    else {  
 
         /* methode du report d'erreur */

	for ( x= 0 ; x < colonne ; x++) err1[x]=err2[x]=0;
	switch (type) {
	    case -1:
	    case 0: b = (unsigned char *) image; break;
	    case 1: s = (short *) image; break;
	    case 2: i = (int *) image; break;
	    case 3: f = (float *) image; break;
	}
	for ( y = 0 ; y < ligne ; y++){
	    for ( x = 0 ; x < colonne; x++){
		switch (type){
		    case -1:
		    case 0: point = (float) *b; b++;  break;
		    case 1: point = (float) *s; s++;  break;
		    case 2: point = (float) *i; i++;  break;
		    case 3: point = *f; f++; break;
                }
		rr = point + err1[x];
		if ( rr > seuil ) 
		{ 
		  *d = 255; d++;
		  e = rr - mmax;
		}
                else 
		{
		  *d = 0; d++;
		  e = rr -mmin;
		}		
                xx = x + 1;
                ff = e * 0.375;
                err1[xx] = err1[xx] + ff;
                err2[xx] = e * 0.25;
                err2[x] = err2[x] + ff;
	    }
            err1 = err2;
            for (xx = 0; xx < colonne ; xx++) err2[xx]= 0;
	}
    }
}

/*****************************************************************************/

unsigned char diff_3 (val)
    unsigned char val;
{
    unsigned char i, mini, minpreced;

    i = 0;  mini = 255;	minpreced = 0;
    do{
	minpreced = mini;
	mini = (val>code3[i] ? val-code3[i] : code3[i]-val);
	i++;
    } while (mini <= minpreced && i!=8);
    if (i!=8) return (i-2);
    else return (mini<minpreced ? i-1 : i-2);
}

/*****************************************************************************/

unsigned char diff_2 (val)
    unsigned char val;
{
    unsigned char i, mini, minpreced;

    i = 0;  mini = 255;	minpreced = 0;
    do{
	minpreced = mini;
	mini = (val>code2[i] ? val-code2[i] : code2[i]-val);
	i++;
    } while (mini <= minpreced && i!=4);
    if (i!=4) return (i-2);
    else return (mini<minpreced ? i-1 : i-2);
}



/*****************************************************************************/
/*                							     */
/* nom      : affiche_image_couleur					     */
/*									     */
/* fonction : affiche une image RGB (3 plans) en couleur dans un canvas	     */
/*									     */
/* entrees  : unsigned char *r	        : pointeur sur le plan-image R	     */
/*	    : unsigned char *g		: pointeur sur le plan-image G	     */
/*	    : unsigned char *b		: pointeur sur le plan-image B	     */
/*									     */
/* return   : neant						             */
/*								             */
/*****************************************************************************/

affiche_image_couleur (imagearr, r, g, b, typeR, typeG, typeB, minR, minG, minB,maxR, maxG, maxB, ligne, colonne)
    unsigned char **imagearr;
    unsigned char *r, *g, *b;
    short typeR, typeG, typeB;
    float minR, minG, minB,maxR, maxG, maxB;
    int ligne, colonne;
{
    register int i, j;
    unsigned char usr, usb, usg;
    unsigned char *br, *bg, *bb;  /* les 3 plans RGB de bytes */
    short *sr, *sg, *sb;          /* les 3 plans RGB de short */
    int *ir, *ig, *ib;            /* les 3 plans RGB d'int    */
    float *fr, *fg, *fb;          /* les 3 plans RGB de float */
    float rfacteur, gfacteur, bfacteur; /* facteurs pour conversion en bytes */
    unsigned char *d;

    *imagearr = (unsigned char *)malloc(ligne*colonne);

    d =  *imagearr;

    if (typeR == 0 && typeG == 0 && typeB == 0) {
        /* les 3 plans (RGB) sont deja de type unsigned char */
        for (j=0; j<ligne; j++){
            for (i=0; i<colonne; i++) {
            /* calcul de la valeur composee de 3 bits R, 3 bits G, 2 bits B */
                *d = (unsigned char) 
                (diff_3(*r) << 5) + (diff_3(*g) << 2) + (diff_2(*b));
                d++; r++; g++; b++;
            }
        }
    }
    else {
        /* on initialise les poiteurs de type correspondant au 3 plans (RGB) */
        switch (typeR) {
            /* plan R */
	    case -1:
	    case 0: br = (unsigned char *) r; break;
	    case 1: sr = (short *) r; break;
	    case 2: ir = (int *) r; break;
            case 3: fr = (float *) r; break;
        }
        switch (typeG) {
            /* plan G */
	    case -1:
	    case 0: bg = (unsigned char *) g; break;
	    case 1: sg = (short *) g; break;
	    case 2: ig = (int *) g; break;
            case 3: fg = (float *) g; break;
        }
        switch (typeB) {
            /* plan B */
	    case -1:
	    case 0: bb = (unsigned char *) b; break;
	    case 1: sb = (short *) b; break;
	    case 2: ib = (int *) b; break;
            case 3: fb = (float *) b; break;
        }
        /* facteur et minimum pour la conversion en byte des 3 plans (RGB) */
        rfacteur = MAXBYTE / (maxR - minR); 
        gfacteur = MAXBYTE / (maxG - minG); 
        bfacteur = MAXBYTE / (maxB - minB); 
        for (j=0; j<ligne; j++){
            for (i=0; i<colonne; i++) {
                switch (typeR) {
                /* plan R */
                    case -1:
                    case 0 : usr = (unsigned char) (*br - minR) * rfacteur;
                         br++;  break;
                    case 1 : usr = (unsigned char) (*sr - minR) * rfacteur;
                         sr++;  break;
                    case 2 : usr = (unsigned char) (*ir - minR) * rfacteur;
                         ir++;  break;
                    case 3 : usr = (unsigned char) (*fr - minR) * rfacteur;
                         fr++;  break;
                }
                switch (typeG) {
                /* plan G */
                    case -1:
                    case 0 : usg = (unsigned char) (*bg - minG) * gfacteur;
                         bg++;  break;
                    case 1 : usg = (unsigned char) (*sg - minG) * gfacteur;
                         sg++;  break;
                    case 2 : usg = (unsigned char) (*ig - minG) * gfacteur;
                         ig++;  break;
                    case 3 : usg = (unsigned char) (*fg - minG) * gfacteur;
                         fg++;  break;
                }
                switch (typeB) {
                /* plan B*/
                    case -1:
                    case 0 : usb = (unsigned char) (*bb - minB) * bfacteur;
                         bb++;  break;
                    case 1 : usb = (unsigned char) (*sb - minB) * bfacteur;
                         sb++;  break;
                    case 2 : usb = (unsigned char) (*ib - minB) * bfacteur;
                         ib++;  break;
                    case 3 : usb = (unsigned char) (*fb - minB) * bfacteur;
                         fb++;  break;
                }
		/*calcul de la valeur composee de 3 bits R,3 bits G,2 bits B*/
                *d = (unsigned char) 
                (diff_3(usr) << 5) + (diff_3(usg) << 2) + (diff_2(usb));
                d++;
            }
	}
    }
}

/*****************************************************************************/
/*                							     */
/* nom      : affiche_couleur_floyd					     */
/*									     */
/* fonction : affiche une image RGB (3 plans) en couleur dans un canvas	     */
/*									     */
/* entrees  : unsigned char *r	        : pointeur sur le plan-image R	     */
/*	    : unsigned char *g		: pointeur sur le plan-image G	     */
/*	    : unsigned char *b		: pointeur sur le plan-image B	     */
/*									     */
/* return   : neant						             */
/*								             */
/*****************************************************************************/

affiche_couleur_floyd (imagearr, r, g, b, typeR, typeG, typeB, minR, minG, minB,maxR, maxG, maxB, ligne, colonne)
    unsigned char **imagearr;
    unsigned char *r, *g, *b;
    short typeR, typeG, typeB;
    float minR, minG, minB,maxR, maxG, maxB;
    int ligne, colonne;
{
    register int i, j, shift;
    unsigned char usr, usb, usg, vr, vg, vb;
    unsigned char rcode, gcode, bcode;
    short ss, err;
    short *r_err, *g_err, *b_err, *r_err_next, *g_err_next, *b_err_next;
    short *temp, *rt, *gt, *bt, *rtn, *gtn, *btn;

    unsigned char *br, *bg, *bb;  /* les 3 plans RGB de bytes */
    short *sr, *sg, *sb;          /* les 3 plans RGB de short */
    int *ir, *ig, *ib;            /* les 3 plans RGB d'int    */
    float *fr, *fg, *fb;          /* les 3 plans RGB de float */
    float rfacteur, gfacteur, bfacteur; /* facteurs pour conversion en bytes */
    unsigned char *d;

    *imagearr = (unsigned char *)malloc(ligne*colonne);

    d =  *imagearr;

    rt = r_err = (short *) malloc((colonne + 1) * sizeof(*r_err));
    gt = g_err = (short *) malloc((colonne + 1) * sizeof(*g_err));
    bt = b_err = (short *) malloc((colonne + 1) * sizeof(*b_err));
    rtn = r_err_next = (short *) malloc((colonne + 1) * sizeof(*r_err));
    gtn = g_err_next = (short *) malloc((colonne + 1) * sizeof(*g_err));
    btn = b_err_next = (short *) malloc((colonne + 1) * sizeof(*b_err));

    for (i=0; i<=colonne; i++)
	*r_err = *g_err = *b_err = *r_err_next = *g_err_next = *b_err_next = 0;

    if (typeR == 0 && typeG == 0 && typeB == 0) {
        /* les 3 plans (RGB) sont deja de type unsigned char */
        for (j=0; j<ligne; j++){
	    r_err = rt;  r_err_next = rtn;
	    g_err = gt;  g_err_next = gtn;
	    b_err = bt;  b_err_next = btn;
            for (i=0; i<colonne; i++) {
		vr = (unsigned char)( (ss = (short)*r + *r_err) > 255 ?
		    255 : (ss < 0 ? 0 : ss) );
		vg = (unsigned char)( (ss = (short)*g + *g_err) > 255 ?
		    255 : (ss < 0 ? 0 : ss) );
		vb = (unsigned char)( (ss = (short)*b + *b_err) > 255 ?
		    255 : (ss < 0 ? 0 : ss) );
		*r_err = *g_err = *b_err = 0;
		rcode = diff_3 (vr);
		gcode = diff_3 (vg);
		bcode = diff_2 (vb);
                *d = (unsigned char) (rcode << 5) + (gcode << 2) + bcode;
		err = (short)(vr - code3[rcode]);
		*(r_err+1) += *(r_err_next) = (3 * err)>>3;
		*(r_err_next+1) += err>>2;
		err = (short)(vg - code3[gcode]);
		*(g_err+1) += *(g_err_next) = (3 * err)>>3;
		*(g_err_next+1) += err>>2;
		err = (short)(vb - code2[bcode]);
		*(b_err+1) += *(b_err_next) = (3 * err)>>3;
		*(b_err_next+1) += err>>2;
                d++; r++; g++; b++;
		r_err++;  g_err++;  b_err++;
		r_err_next++;  g_err_next++;  b_err_next++;
            }
	    temp = rt;  rt = rtn;  rtn = temp;
	    temp = gt;  gt = gtn;  gtn = temp;
	    temp = bt;  bt = btn;  btn = temp;
        }
    }
    else {
        /* on initialise les poiteurs de type correspondant au 3 plans (RGB) */
        switch (typeR) {
            /* plan R */
	    case -1:
	    case 0: br = (unsigned char *) r; break;
	    case 1: sr = (short *) r; break;
	    case 2: ir = (int *) r; break;
            case 3: fr = (float *) r; break;
        }
        switch (typeG) {
            /* plan G */
	    case -1:
	    case 0: bg = (unsigned char *) g; break;
	    case 1: sg = (short *) g; break;
	    case 2: ig = (int *) g; break;
            case 3: fg = (float *) g; break;
        }
        switch (typeB) {
            /* plan B */
	    case -1:
	    case 0: bb = (unsigned char *) b; break;
	    case 1: sb = (short *) b; break;
	    case 2: ib = (int *) b; break;
            case 3: fb = (float *) b; break;
        }
        /* facteur et minimum pour la conversion en byte des 3 plans (RGB) */
        rfacteur = MAXBYTE / (maxR - minR); 
        gfacteur = MAXBYTE / (maxG - minG); 
        bfacteur = MAXBYTE / (maxB - minB); 
        for (j=0; j<ligne; j++){
	    r_err = rt;  r_err_next = rtn;
	    g_err = gt;  g_err_next = gtn;
	    b_err = bt;  b_err_next = btn;
            for (i=0; i<colonne; i++) {
               switch (typeR) {
                /* plan R */
                    case -1:
                    case 0 : usr = (unsigned char) (*br - minR) * rfacteur;
                         br++;  break;
                    case 1 : usr = (unsigned char) (*sr - minR) * rfacteur;
                         sr++;  break;
                    case 2 : usr = (unsigned char) (*ir - minR) * rfacteur;
                         ir++;  break;
                    case 3 : usr = (unsigned char) (*fr - minR) * rfacteur;
                         fr++;  break;
                }
                switch (typeG) {
                /* plan G */
                    case -1:
                    case 0 : usg = (unsigned char) (*bg - minG) * gfacteur;
                         bg++;  break;
                    case 1 : usg = (unsigned char) (*sg - minG) * gfacteur;
                         sg++;  break;
                    case 2 : usg = (unsigned char) (*ig - minG) * gfacteur;
                         ig++;  break;
                    case 3 : usg = (unsigned char) (*fg - minG) * gfacteur;
                         fg++;  break;
                }
                switch (typeB) {
                /* plan B*/
                    case -1:
                    case 0 : usb = (unsigned char) (*bb - minB) * bfacteur;
                         bb++;  break;
                    case 1 : usb = (unsigned char) (*sb - minB) * bfacteur;
                         sb++;  break;
                    case 2 : usb = (unsigned char) (*ib - minB) * bfacteur;
                         ib++;  break;
                    case 3 : usb = (unsigned char) (*fb - minB) * bfacteur;
                         fb++;  break;
                }
		vr = (unsigned char)( (ss = (short)usr + *r_err) > 255 ?
		    255 : (ss < 0 ? 0 : ss) );
		vg = (unsigned char)( (ss = (short)usg + *g_err) > 255 ?
		    255 : (ss < 0 ? 0 : ss) );
		vb = (unsigned char)( (ss = (short)usb + *b_err) > 255 ?
		    255 : (ss < 0 ? 0 : ss) );
		*r_err = *g_err = *b_err = 0;
		rcode = diff_3 (vr);
		gcode = diff_3 (vg);
		bcode = diff_2 (vb);
                *d = (unsigned char) (rcode << 5) + (gcode << 2) + bcode;
		err = (short)(vr - code3[rcode]);
		*(r_err+1) += *(r_err_next) = (3 * err)>>3;
		*(r_err_next+1) += err>>2;
		err = (short)(vg - code3[gcode]);
		*(g_err+1) += *(g_err_next) = (3 * err)>>3;
		*(g_err_next+1) += err>>2;
		err = (short)(vb - code2[bcode]);
		*(b_err+1) += *(b_err_next) = (3 * err)>>3;
		*(b_err_next+1) += err>>2;
                d++;
		r_err++;  g_err++;  b_err++;
		r_err_next++;  g_err_next++;  b_err_next++;
            }
	    temp = rt;  rt = rtn;  rtn = temp;
	    temp = gt;  gt = gtn;  gtn = temp;
	    temp = bt;  bt = btn;  btn = temp;
        }
    }
    free(rt);  free(gt);  free(bt);
    free(rtn);  free(gtn);  free(btn);
}
















