;**************************************************************************
;** rules.lisp                                                           **
;**                                                                      **
;**  Ce programme a les definitions, methodes et fonctions concernant les**
;** regles de production. La partie droite d'une regle est definie par   **
;** une fonction qui a comme nom le nom de la regle prefixe par `rhs-'   **
;** suivi du nom de la base et `-' (rhs-<nom-base>-<nom-regle>).         **
;**                                                                      **
;**  Claudia Coiteux-Rosu                                      Aout 1989 **
;**************************************************************************
;** Fonctions et methodes:                                               **
;** Definition:                                                          **
;**  add-rule                :init                                       **
;**                                                                      **
;** Effacer:                                                             **
;**  remove                                                              **
;**                                                                      **
;** Bindings et priorites:                                               **
;**  add-binding             remove-fact               set-prior         **
;**                                                                      **
;** Traitements possibles:                                               **
;**  rprint                  p-gauche                                    **
;**************************************************************************

(eval-when (compile) (load "varenv")
                     (load "net")
                     (load "bindings"))


;**************************************************************************
;** Definition d'une regle                                               **
;**************************************************************************
;** Ajoute une regle au reseau et a la base                              **
(defun add-rule (bname rname lhs fns nots desc tests db)
  (let*  ((name (concat bname '- rname))
          (old (get '*rules* name)))
    (cond ((and  old
                (equal lhs   (symeval-in-instance old 'lhs))
                (equal fns   (symeval-in-instance old 'fns))
	        (equal nots  (symeval-in-instance old 'nots))
	        (equal tests (symeval-in-instance old 'tests)))
	            (and *psy-trace* 
                         (msg rname ":" #\N #\T 
                             "La partie gauche existait deja" #\N))
                     old)

           (old (and *psy-trace* 
                     (msg rname ":" #\N #\T 
                          "Compile nouvelle partie gauche" #\N))
	        (funcall old 'remove)
	        (make-instance 'rule :name name :lhs lhs :fns fns 
                          :nots nots :desc desc :tests tests :db db))

	  (t    (and *psy-trace* (msg rname ":" #\N #\T 
                                     "Compile partie gauche" #\N))
                (make-instance 'rule :name name :lhs lhs :fns fns
                          :nots nots :desc desc :tests tests :db db)))))


;** Frame qui decrit la regle                                            **
(defflavor rule (
	name            ; nom de la regle
	(lhs  nil)      ; partie gauche
        (fns  nil)      ; fonctions de la partie gauche
	(nots nil)      ; modeles negatifs
        (desc nil)      ; description de la regle
	(tests nil)     ; tests de la regle
	(out-node nil)	; pointeur au node qui decrit ses modele positifs
                        ; join-node ou bind-node
	(not-nodes nil)	; pointeus au modeles negatifs not-nodes
        (prior 0)       ; priorite de la regle
        (db nil)        ; base de la regle
	)
         nil
        :initable-instance-variables)


;** definition de la regle                                               **
(defmethod (rule :init) (inits)
 (declare (ignore inits))
 (let ((test-list  (build-test-list tests))
       *System-Production-Error*)
      (set-in-instance db 'rules 
             (cons self (symeval-in-instance db 'rules)))
      (setq out-node (add-patterns-net lhs *psy-root*))
      (and fns (setq out-node (add-fns-net *psy-root* fns out-node)))
      (set-in-instance out-node 'next-node self)
      (setq test-list  (funcall out-node 'add-tests test-list))
      (check-test-list test-list)
      (setq not-nodes
	    (car (for not-clause in nots
		      bind (lhs-vars (symeval-in-instance out-node 'vars))
		      tcollect (make-instance 'not-node
				 :rule self
				 :not-clause not-clause
				 :lhs-vars lhs-vars))))
      (if *System-Production-Error*
        (progn
          (funcall self 'remove)
	  (msg "La regle " name " ne peut pas etre ajoute" #\N)))))


;**************************************************************************
;** Effacer une regle                                                    **
;**************************************************************************
;** Efface une regle                                                     **
(defmethod (rule remove) nil
       (funcall out-node 'remove)
       (for not-node in not-nodes do (funcall not-node 'remove))
       (funcall db 'removep self)
        db)


;**************************************************************************
;** Traitement des bindings de la regle et priorites                     **
;**************************************************************************
;**Ajoute un binding pour la regle au conflict-set                       **
(defmethod (rule add-binding) (binding xxx)
 (declare (ignore xxx))
  (or (for not-node in not-nodes
	   thereis (funcall not-node 'check-block binding))
      (funcall db 'add-conflict-set binding)))


;**Efface un binding qui bloque la reglem dans un noeud not-node         **
(defmethod (rule remove-fact) (fact xxx)
  (declare (ignore xxx))
  (for not-node in not-nodes
       do (funcall not-node 'remove-fact-blocks fact)))


;** Met une priorite a une regle                                         **
(defun set-prior (regle prior &optional base)
   (and (not base) (setq base *psy-name-db*))
   (set-in-instance (get '*rules* (concat base '- regle)) 'prior prior)
   (and *psy-runbase* (funcall *psy-db* 'resort-conflict-set)))


;**************************************************************************
;** Traitements possibles sur une regle                                  **
;**************************************************************************
;** Affichage d'une regle de la base recevant le message                 **
(defmethod (rule rprint) (rname)
  (msg #\N "   Regle: " rname #\N)
  (msg   "   Base : " (symeval-in-instance db 'name) #\N)
  (msg   "   Priorite : " prior #\N)
  (for initially   (msg "     Partie gauche  :" #\N) 
       x in lhs do (msg "                     " x #\N))
  (and fns  (for  initially
                   (msg "     Fonctions PG   :" #\N)
                  x in fns do
                   (msg "                     " x #\N)))                   
  (and nots (for  initially 
                   (msg "     Negations      :" #\N)
                  x in nots do 
                   (msg "                     " x #\N)))
  (and desc (for  initially 
                   (msg "     Description    :" #\N)
                  x in desc do 
                   (msg "                     " x #\N)))
  (and tests (for initially 
                   (msg "     Tests          :" #\N)
		  x in tests do 
                   (msg "                     " x #\N)))
  (let ((rhs (symbol-function (concat 'rhs- name)))) 
       (cond ((typep rhs 'compiled-function)
		   (msg "     La partie droite est compilee" #\N))
	     (t    (setq rhs (cddar (cdddr rhs)))
                   (msg "     Partie droite  :" #\N)
		   (for x in rhs do 
                   (msg "                     " x #\N))))))


;** Ressort de la partie gauche de la regle recevant le message          **
(defmethod (rule p-gauche)()
 (cond ((and fns nots tests) `(,@lhs ,@fns ,@nots test ,@tests))
       (fns (cond (nots `(,@lhs ,@fns ,@nots))
                  (tests `(,@lhs ,@fns test ,@tests))
                  (t  `(,@lhs ,@fns))))
       (nots (if  tests `(,@lhs ,@nots test ,@tests)
                        `(,@lhs ,@nots)))
       (tests `(,@lhs test ,@tests))
       (t `(,@lhs))))
