  /* structures de donnees pour la methode de Ohlander Price & Reddy */

struct list_seg		   /* stockage des segmentations precedentes */
{
    int l, r;		/* bornes gauche & droite de la segmentation */
    struct list_seg *next_ls;
};

struct pile_im		/* pile pour stocker les masques a segmenter */
{
    struct pile_im *next_im;
    unsigned char *im;				/* ptr sur le masque */
    int l, r;	     /* bornes gauches et droites de la segmentation */
    struct list_seg *first_ls;		/* memoire des segmentations */
};

struct list_pic
{
    int pic;				/* position du pic = maxima */
    int l, r;		  /* minimas gauche & droit associes au pic */
    int size;			        /* nb de points sous le pic */
    float ratio;				 /* rapport max/min */
    struct list_pic *next_lpic;
};

struct precede	   /* stockage du pic et de son ordre de precedence */
{
    int priorite;			    /* niveau de precedence */
    struct list_pic *lpic;	 /* ptr sur le "best" pic du niveau */
};

#define SMALL 5.0		     /* pour recherche des extremas */

Frame frame_lect;
Panel panel_lect;
Panel_item lect;

int low,		      /* position du debut de l'histogramme */
    tot;	       /* nombre de points sous l'histogramme lisse */

/********************************************************************/
/*								    */
/* Nom : lect_in						    */
/* Fonction : lecture d'un entier qui represente le choix de	    */
/* l'utilisateur lors de l'entree d'un parametre		    */
/* Entree : Panel_item item, Event *event			    */
/* Global : Frame frame_lect; Panel_item lect			    */
/* Routine : -							    */
/* Sortie : int &entier						    */
/*								    */
/* Made by Christian Girard 13.10.1989				    */
/********************************************************************/

static Panel_setting lect_in (item, event)

Panel_item item;
Event *event;

{
    static int entier;
    double d;

    if (event_id (event) == CTRLC)
    {
	flag_break = TRUE;
	entier = -9999;
	window_return (&entier);
	window_destroy (frame_lect);
	return;
    }
    else
    {
	entier = atoi ((char *) panel_get (lect, PANEL_VALUE));
	window_return (&entier);
	window_destroy (frame_lect);
	return;
    }

} /* lect_in */

/********************************************************************/
/*								    */
/* Nom : panel_int						    */
/* Fonction : Afficher la fenetre d'interaction pour lire un entier */
/* Entree : int methode						    */
/* Global : int flag_exec (du LaboImage)			    */
/*	    Frame frame_lect; Panel panel_lect; Panel_item lect	    */
/* Routine : lect_in						    */
/* Sortie : int *val						    */
/*								    */
/* Made by Christian Girard 13.10.1989				    */
/********************************************************************/

int panel_int (methode)

int methode;			    /* 1 = taille du masque pour lissage */
		/* 2 = nb de pixels pour elimination des petites regions */
{
		/* les variables */
    int *val;			      /* valeur du parametre a retourner */
    Panel_item titre;
    char stitre[50], rep[20];

		/* le code */
    frame_lect = window_create (frame, FRAME, FRAME_LABEL, "SEGMENTATION",
				WIN_X, 500, WIN_Y, 500, FRAME_NO_CONFIRM,
				TRUE, 0);
    panel_lect = window_create (frame_lect, PANEL, PANEL_LABEL_BOLD, TRUE, 0);

    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	val = (int *) macro_cour->param;
    else val = NULL;

    strcpy (stitre, paneltabs[331]);
    titre = panel_create_item (panel_lect, PANEL_MESSAGE,
			       PANEL_SHOW_ITEM, TRUE,
			       PANEL_LABEL_X, ATTR_COL(0),
			       PANEL_LABEL_Y, ATTR_ROW(0),
			       PANEL_LABEL_STRING, stitre, 0);
    
    if (methode == 1)
	strcpy (stitre, paneltabs[332]);
    else
	strcpy (stitre, paneltabs[333]);
    
    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	sprintf (rep, "%d", (*val));
    else 
	if (methode == 1) strcpy (rep, "8");
	else strcpy (rep, "5");

    lect = panel_create_item (panel_lect, PANEL_TEXT,
			      PANEL_SHOW_ITEM, TRUE,
			      PANEL_LABEL_X, ATTR_COL (1),
			      PANEL_LABEL_Y, ATTR_ROW (2),
			      PANEL_VALUE_DISPLAY_LENGTH, 20,
			      PANEL_LABEL_STRING, stitre,
			      PANEL_VALUE, rep,
			      PANEL_NOTIFY_STRING, "\r\n\03",
			      PANEL_NOTIFY_PROC, lect_in, 0);

    window_fit (panel_lect);
    window_fit (frame_lect);
    window_set (panel_lect, PANEL_CARET_ITEM, lect, 0);
    val = (int *)window_loop (frame_lect);
  /*  panel_destroy_item (lect); */
     return (*val);

} /* panel_int */

/********************************************************************/
/*								    */
/* Nom : masque_init						    */
/* Fonction : ecriture du masque initial sur toute l'image	    */
/* Entree : int mmin, mmax, taille : stat de l'image		    */
/* Global : -							    */
/* Routine : -							    */
/* Sortie : struct pile_im *l_pile : ptr sur le masque		    */
/*								    */
/* Made by Christian GIRARD 28.11.1989				    */
/********************************************************************/

struct pile_im * masque_init (mmin, mmax, taille)

int mmin, mmax, taille;

{		    /* declaration des variables */
unsigned char *bidon, *im0;
struct pile_im *l_pile;
int i;

		/* code de la routine masque_init */
			 /* masque initial sur toute l'image = image de "1" */
l_pile = (struct pile_im *) calloc (1,sizeof (*l_pile));    /* 1er ele pile */
l_pile->next_im = NULL;
bidon = (unsigned char *) calloc (taille, sizeof (*bidon));
l_pile->im = bidon ;			    
bidon = NULL;
l_pile->l = mmin;
l_pile->r = mmax;
l_pile->first_ls = NULL;
im0 = l_pile->im;
for (i = 0; i < taille; i ++)			     /* ecriture du masque */
{
    *im0 = 1;
    im0 ++;
} /* for */
im0 = NULL;

return (l_pile);

} /* masque_init */
/********************************************************************/
/*								    */
/* Nom : calc_hist						    */
/* Fonction : calcul de l'histogramme de l'image		    */
/* Entree : unsigned char *pict : ptr sur l'image		    */
/*	    int type : type de l'image				    */
/*	    int mmin : minimum de l'image (niv. gris)		    */
/* Global : -							    */
/* Fonction : -							    */
/* Sortie : int *histo : histogramme rempli			    */
/*								    */
/* Made by Christian GIRARD 28.11.1989				    */
/********************************************************************/

int * calc_hist (pict, type, mmin)

unsigned char *pict;
int type, mmin;

{		/* declaration des variables */
unsigned char *pict0;
short int *pict1;
int *pict2, *w_histo, *histo, i;
float *pict3;

		/* code de la routine calc_hist */
					    /* allocation de l'histogramme */
histo = (int *) calloc (mmax - mmin + 1, sizeof (*histo));

w_histo = histo;			/* initialisation de l'histogramme */
for (i = 0; i < (mmax - mmin + 1); i ++)
{
    *w_histo = 0;
    w_histo ++;
}

switch (type)					/* histogramme de l'image */
{
    case -1 :
    case 0 : pict0 = pict;				 /* ptr sur image */
	     for (i = 0; i < taille; i ++)
	     {
		w_histo = histo;
					   /* on incremente l'histogramme */
		w_histo + = (int) (*pict0) - mmin;
		(*w_histo) ++; 
		pict0 ++;
	     } /* for */
	     pict0 = NULL;
	     break; /* case 0 */

    case 1 : pict1 = (short int *) pict;		/* ptr sur image */
	     for (i = 0; i < taille; i ++)
	     {
		w_histo = histo;

	        w_histo + = (int) (*pict1) - mmin;   /* on incr l'histo */
		(*w_histo) ++; 
	        pict1 ++;
	     } /* for */
	     pict1 = NULL;
	     break; /* case 1 */

    case 2 : pict2 = (int *) pict;			/* ptr sur image */
	     for (i = 0; i < taille; i ++)
	     {
		w_histo = histo;
		w_histo + = *pict2 - mmin;	/* on incremente l'histo */
		(*w_histo) ++; 
	        pict2 ++;
	     } /* for */
	     pict2 = NULL;
	     break; /* case 2 */

    case 3 : pict3 = (float *) pict;			 /* ptr sur image */
	     for (i = 0; i < taille; i ++)
	     {
		w_histo = histo;
		w_histo + = (int) rint(*pict3) - mmin;   /* increm l'histo */ 
		(*w_histo) ++;
		pict3 ++;
	     } /* for */
	     pict3 = NULL;
	     break; /* case 3 */

} /* switch */

return (histo);

} /* calc_hist */

/********************************************************************/
/*								    */
/* Nom : rech_ratio_2						    */
/* Fonction : rechercher dans la liste de pics un pic autre que le  */
/* pic courant ayant un rapport max/min > 2			    */
/* Entree : struct list_pic *f_p, *lpic				    */
/* Global : -							    */
/* Routine : -							    */
/* Sortie : int ok (1 si trouve , 0 sinon)			    */
/*								    */
/* Made by Christian GIRARD 14.4.1989				    */
/********************************************************************/

int rech_ratio_2 (f_p, lpic)

struct list_pic *f_p, *lpic;

{
    struct list_pic *lpic1;
    int ok = 0;

    lpic1 = f_p;
    while ((lpic1 != NULL) && (ok != 1))
    {
	if (lpic1 != lpic)
	    if (lpic1->ratio > 2.0) ok = 1;
	lpic1 = lpic1->next_lpic;
    } /* while */
    return (ok);
} /* rech-ratio_2 */

/********************************************************************/
/*								    */
/* Nom : extrema						    */
/* Fonction : Finds extrema (and shoulders) of a serie of data	    */
/* Extremum : if left and right points are both <, both >, one< and */
/* one <=, one > and one >=. Added ad-hoc test : can have 2 extrema */
/* at consecutive locations.					    */
/* Entree : Data    vector of data				    */
/*	    NData   nr data					    */
/*	    ls	    positions of cuts				    */
/* Global : -							    */
/* Routine : -							    */
/* Sortie : NExtr   nr extrema found				    */
/*	    PosExtr contains position of extrema		    */
/*								    */
/* Made by Thierry PUN 13.12.1988				    */
/********************************************************************/

int * extrema (Data, NData, NExtr, ls)

int *Data;
int NData;
int *NExtr;
struct list_seg *ls;

{
    int ii, i;
    float left, midl, rite;
    int *PosExtr, *pos, *dat;
    struct list_seg *wls;

    *NExtr = 0;
    PosExtr = (int *) calloc (NData, sizeof (*PosExtr));
    pos = PosExtr;
    for (ii = 0; ii < NData; ii ++)
    {
	*pos = 0;
	pos ++;
    }
    dat = Data;
    ii = 0;
    while (ii < NData)
    {
	midl = (float) *dat;
	if (ii == 0) left = 0.0;
	else 
	{
	    dat --;
	    left = (float) *dat;
	    dat ++;
	}
	if (ii == (NData - 1)) rite = 0.0;
	else 
	{
	    dat ++;
	    rite = (float) *dat;
	    dat --;
	}
	if (((left > midl) && (rite > midl)) ||	
	    ((left < midl) && (rite < midl)) ||
	    (ii == 0) || (ii == NData - 1) ||/* && (left < midl) && (rite > midl)) ||*/	
	    ((fabs (left - midl) > SMALL) && (rite == midl)) ||	
	    ((left == midl) && (fabs (rite - midl) > SMALL)))
	{
	    if (*NExtr > 0)
	    {
		if ((*pos != (ii - 1)) || (fabs(left - midl) > SMALL))
		{
		    pos ++;
		    *pos = ii;
		    (*NExtr) ++;
		} /* then */
	    } /* then NExtr > 0 */
	    else 
	    {
		pos = PosExtr;
		*pos = ii;
		(*NExtr) ++;
	    }
	} /* if ..|..|..|.. */

	wls = ls;		/* saut si partie deja segmentee */
	while (wls != NULL)
	{
	    if (wls->l == ii + low)
	    {
		if (*pos != ii)
		{
		    pos ++;
		    *pos = ii;
		    (*NExtr) ++;
		}

		for (i = 0; i < wls->r - wls->l; i++)
		{
		    if (ii != NData - 1) dat ++;
		    ii ++;
		}

		pos ++;
		*pos = ii;
		(*NExtr) ++;
	    }
	    wls = wls->next_ls;
	}

	if (ii != (NData - 1)) dat ++;
	ii ++;
    } /* while boucle sur les donnees */
/*pos = PosExtr;
for (i = 0; i < *NExtr; i ++)
{
    printf ("extr : %d\n", *pos + mmin);
    pos ++;
}
printf("nb d'extremas : %d \n\n",*NExtr);*/
    return (PosExtr);
} /* extrema */

/********************************************************************/
/*								    */
/* Nom : mov_avg						    */
/* Fonction : 1D moving average operator			    */
/* Entree : Data    vector of data				    */
/*	    NData   nr data					    */
/*	    WSize   window size					    */
/* Global : -							    */
/* routine : -							    */
/* Sortie : AvgData filtered vector				    */
/*								    */
/* Made by Thierry PUN 13.12.1988				    */
/********************************************************************/

int * mov_avg (Data, NData, WSize)

int *Data;
int NData, WSize;

{
    int i, ii, kk, ind;
    int WSm, WSp;
    int *AvgData, *ad, *dat;
    float val;

    

    if (WSize > 1)
    {
	AvgData = (int *) calloc (NData, sizeof (*AvgData));

        WSm = (int) rint (floor((double)WSize / 2.0));
	WSp = (int) rint (floor(((double)WSize - 1.0) / 2.0));
	ad = AvgData;

	for (ii = 0; ii < NData; ii ++)
	{
	    val = 0.0;
	    for (kk = ii - WSm; kk <= ii + WSp; kk ++)
	    {
		if (kk < 0) ind = 0;
		else if (kk >= NData) ind = NData - 1;
		    else ind = kk;
		dat = Data;
		for (i = 0; i < ind; i ++)
		{
		    dat ++;
		}
		val = val + (float) *dat;
	    } /* for kk */
	    *ad = (int) rint(val / (float) WSize);
	    if (ii != (NData - 1)) ad ++;
	} /* for ii */
    } /* if WSize > 1 */
    else AvgData = Data;

    return (AvgData);
} /* mov_avg */

/********************************************************************/
/*								    */
/* Nom : hval							    */
/* Fonction : donne la valeur de l'histogramme en un point	    */
/* Entree : int *pos, *hist (position & histogramme)		    */
/* Global : -							    */
/* Routine : -							    */
/* Sortie : int hist						    */
/*								    */
/* Made by Christin GIRARD 21.4.1989				    */
/********************************************************************/

int hval (pos, hist)

int *pos, *hist;

{
    return (*(hist + (*pos)));
} /* hval */

/********************************************************************/
/*								    */
/* Nom : bat_lpic						    */
/* Fonction : construction de la liste des pics d'un masque sur la  */
/* base de la liste des extremas lors de la segmentation selon la   */
/* methode de Ohlander Price et Reddy.				    */
/* Entree : int *min_max : ptr sur la liste des pics de l'image tot */
/*	    int *s_histo : ptr sur l'histogramme		    */
/*	    int nb_extr : nombre d'extremas trouves par "extrema"   */
/*	    struct list_seg *f_ls : ptr sur les segmentations deja  */
/*	    effectuees.						    */
/* Global : int low						    */
/* Routine : hval						    */
/* Sortie : struct list_pic *first_pic : ptr sur liste de pics	    */
/*								    */
/* Made by Christian GIRARD 22.11.1989				    */
/********************************************************************/

struct list_pic * bat_lpic (min_max, s_histo, nb_extr, f_ls)

int *min_max, *s_histo, nb_extr;
struct list_seg *f_ls;

{		/* declaration des variables */
    int *w_min_max, i, 
	trouve, test,				/* variables booleennes */
	*prec, *suiv,			/* extrema precedent et suivant */
	peak, lmin, rmin,		/* position de l'extrema trouve */
	lval, rval, val;	  /* val de l'histogramme sur l'extrema */

    struct list_seg *ls;/* ptr de travail sur liste des segmentations */

    struct list_pic *first_pic, *lpic, *lpic1;

		/* code de la routine bat_lpic */
    i = 0;
    first_pic = NULL;
    w_min_max = min_max;
    while (i < nb_extr)		    /* construction de la liste des pics */
    {
	trouve = 0;
	test = 0;				   /* pour affecter prec */
				/* recherche d'un maxima dans le vecteur */
	while ((trouve != 1) && (i < nb_extr))
	{
	    if (test == 0)			      /* on affecte prec */
	    {
		if (i > 0)
		{
		    prec = (-- w_min_max);
		    w_min_max ++;
		} /* then i>0 */
		else
		{
		    prec = w_min_max;
		} /* else */

		test = 1;
		lmin = *prec;
	    } /* if not test */

	    if (i+1 < nb_extr)			     /* on affecte suiv */
	    {
		suiv = ++ w_min_max;
		w_min_max --;
	    }
	    else 
	    {
		suiv = w_min_max;
		trouve = 1;
	    }
								       /* / */
	    if ((trouve!=1) && (hval(prec,s_histo) <= hval(w_min_max,s_histo)))
		if (hval(suiv, s_histo) < hval(w_min_max, s_histo))    /* \ */
		    trouve = 1;
	    
	    if (trouve != 1)	     /* passage a l'extrema suivant (/-) */
	    {
		w_min_max ++;
		i ++;
	    } /* if not trouve */

	} /* while not trouve */
	peak = *w_min_max;

	trouve = 0;
	test = 0;					 /* pour cas ou \__ */
				/* recherche du minima droit associe au pic */
	while ((trouve != 1) && (i < nb_extr)) 	
	{				    /* passage a l'extrema suivant */
	    if (i+1 < nb_extr)
	    {
		w_min_max ++;
		i ++;
	    } /* if */

	    if (i + 1 < nb_extr)	/* recherche de l'extrema suivant */
	    {
		suiv = ++ w_min_max;
		w_min_max --;
	    }
	    else			    /* on est a la fin du vecteur */
	    {
		trouve = 1;
		suiv = w_min_max;
	    } /* else */

	    if (hval(w_min_max,s_histo) > hval(suiv,s_histo)) test = 0;
	    else if (hval(w_min_max,s_histo) == hval(suiv,s_histo))
		 {
		     test = 1;
		     rmin = *w_min_max;
		 }
								    
	    if ((trouve== 0) && (hval(suiv,s_histo) > hval(w_min_max,s_histo)))
		 trouve = 1;					     /* / */

	} /* while not trouve */
	if (test == 0) rmin = *w_min_max;

	i ++;
	if (i < nb_extr)
	    w_min_max ++;		    /* passage a l'extrema suivant */

/*printf ("l_pic av l : %d, p : %d, r : %d \n",lmin+low, peak+low, rmin+low);*/

	ls = f_ls;		  /* evite de segmenter 2x au meme endroit */
	trouve = 0;
	while ((ls != NULL) && (trouve == 0))
	{
	    if (((lmin + low) < ls->l) && ((rmin + low) > ls->l)) 
		rmin = ls->l - low;

	    if (((lmin + low) >= ls->l) && ((rmin + low) <= ls->r)) trouve = 1;

	    if (((lmin + low) < ls->r) && ((rmin + low) >= ls->r))
		if ((lmin + low) >= ls->l) lmin = ls->r - low;
		else trouve = 1;

	    if ((fabs((float)((lmin + low) - ls->l)) <= 2.0) && 
		(fabs((float)((rmin + low) - ls->r)) <= 2.0)) 
		trouve = 1;

	    ls = ls->next_ls;
	}

	if ((trouve == 0) && (rmin!= lmin))
	{			      /* construction de la liste des pics */

/*printf ("l_pic ap l : %d, p : %d, r : %d \n",lmin+low, peak+low, rmin+low);*/

	    lpic = (struct list_pic *) calloc (1,sizeof(*lpic));
	    lpic->pic = peak;
	    lpic->l = lmin;
	    lpic->r = rmin;

	    lval = hval(&lmin,s_histo);		/* hauteur du min gauche */
	    val = hval(&peak,s_histo);		       /* hauteur du pic */
	    rval = hval(&rmin,s_histo);		 /* hauteur du min droit */
	    if ((lval == 0) && (rval == 0)) lpic->ratio = val;
	    else
	    {
		if (lval<rval) if (lval!=0) lpic->ratio=(float)val/(float)lval;
			       else lpic->ratio = (float) val / (float) rval;
		else if (rval != 0) lpic->ratio = (float)val / (float) rval;
			       else lpic->ratio = (float)val / (float) lval;
		/*lpic->ratio = (float) val / ((float) (lval + rval) / 2.0);*/
	    }
	    lpic->next_lpic = NULL;
	    if (first_pic == NULL) first_pic = lpic;
	    else lpic1->next_lpic = lpic;
	    lpic1 = lpic;
	}

    } /* while i < nb_extr */

    prec = NULL;
    suiv = NULL;
    w_min_max = NULL;			    /* libere de la place-memoire */

    return (first_pic);
} /* bat_lpic */

/********************************************************************/
/*								    */
/* Nom : rech_best_pic						    */
/* Fonction : parcours de la liste des pics pour rechercher l'ordre */
/* de precedence des pics, puis extraction du meilleur pic en vue de*/
/* la segmentation						    */
/* Entree : struct list_pic *first_pic : premier ele de la liste pic*/
/*	    int taille_histo					    */
/*	    int *s_histo : histogramme du masque		    */
/*	    int high : plus haut pic de l'histo (hauteur)	    */
/* Global : int low : debut de l'histogramme du masque		    */
/*		tot : nb de points total de l'histo_lisse	    */
/* Routine : hval, rech_ratio_2					    */
/* Sortie : struct precede preced : le best pic & sa priorite	    */
/*								    */
/* Made by Christian GIRARD 23.11.1989				    */
/********************************************************************/

struct precede rech_best_pic (first_pic, taille_histo, s_histo, high)

struct list_pic *first_pic;
int taille_histo, *s_histo, high;

{		    /* declaration des variables */
    struct precede preced;    /* le meilleur pic avec sa precedence */
    int trouve,						 /* booleen */
	precedence,		     /* ordre de precedence courant */
	lval, val, rval,  /* hauteur de l'histo aux extremas du pic */
	nb_point,	     /* nombre de points sous l'histogramme */
	*w_histo, i;
    float l_ratio, r_ratio;		 /* rapports min/max du pic */
    struct list_pic *lpic;

		/* code de la routine rech_best_pic */
    lpic = first_pic;
    preced.priorite = 7;	    /* pour accepter toutes les priorites */
    trouve = 0;					      /* priorite trouvee */

    while (lpic != NULL)		/* parcours de la liste des pics */
    {
	precedence = 0;					    /* maxi male */
	trouve = 0;		   /* le pic examine sera_t_il valable ? */
	while ((trouve != 1) && (precedence <= 6))   /* priorite pic = ? */
	{
	    switch (precedence)
	    {
		case 0 : if ((((float) (lpic->pic + low) <= 
						    0.16 * (float)taille_histo)
			    || ((float) (lpic->pic + low) >= 
						    (float) (taille_histo -
					    (0.16 * (float) taille_histo)))) )
			     trouve = 1;
			 break; /* case 0 */

		case 1 : if (((float)hval(&(lpic->l),s_histo)< 0.1*(float)high)
			     && ((float) hval(&(lpic->r),s_histo) < 
							0.1* (float)high) &&
			     (lpic->ratio > 4.0))
			 {
			    trouve = rech_ratio_2 (first_pic, lpic);
			 } /* if ...&&...&&... */
			 break; /* case 1 */

		case 2 : if (((float) hval(&(lpic->l),s_histo) < 
							0.25*(float)high) &&
			     ((float) hval(&(lpic->r),s_histo) < 
							0.25*(float)high) &&
			     (lpic->ratio > 4.0))
			 {
			     trouve = rech_ratio_2 (first_pic, lpic);
			 } /* if ...&...&... */
			 break; /* case 2 */

		case 3 : if (lpic->ratio > 2.0)
			    trouve = rech_ratio_2 (first_pic, lpic);
			 break; /* case 3 */

		case 4 : if ((((float) (lpic->l+low) <= 
						0.2 * (float)taille_histo) ||
			      ((float) (lpic->r+low) >= 
						0.8 *(float)taille_histo)) &&
			      (lpic->ratio > 2.0))
			 {
			    lval = hval (&(lpic->l), s_histo);
			    val = hval (&(lpic->pic), s_histo);
			    rval = hval (&(lpic->r), s_histo);
			    if (lval > 0) l_ratio = (float) (val / lval);
			    else l_ratio = (float) val;
			    if (rval > 0) r_ratio = (float) (val / rval);
			    else r_ratio = (float) val;
			    if ((l_ratio > 1.2) && (r_ratio > 1.2))
				trouve = 1;
			 } /* if ...||...&&... */
			 break; /* case 4 */

		case 5 : if (((float) hval(&(lpic->l),s_histo) < 
							    0.1*(float)high) &&
			     ((float) hval(&(lpic->r),s_histo) < 
							    0.1* (float)high))
			 {
			    nb_point = 0;  /* comptage des points sous pic */
			    w_histo = s_histo;
			    w_histo + = lpic->l;
			    for (i = lpic->l; i < lpic->r; i ++)
			    {
				nb_point + = *w_histo;
				w_histo ++;
			    } /* for */
			    lpic->size = nb_point;
			    if ((float) nb_point >= 0.1 * (float)tot)
			    {		    /* + de 10 % des pts sous le pic */
				trouve = 1;
			    } /* if 10 % */
			 } /* if ...&&... */
			 break; /* case 5 */

		case 6 : if ((lpic->ratio > 1.7) &&
			     ((float) hval(&(lpic->l), s_histo) < 
							0.7 * (float)high) && 
			     ((float) hval(&(lpic->r), s_histo) < 
							0.7 * (float)high))
			 {
			    trouve = 1;
			 } /* if ...&...&... */
			 break; /* case 6 */

	    } /* switch precedence */

/*printf("\n l %d r %d preced %d ratio %2.2f priorite %d",lpic->l+low,
		lpic->r+low, precedence,lpic->ratio, preced.priorite);*/

	    if (trouve == 1)	    /* pic trouve : recherche du meilleur */
	    {

		if (precedence < preced.priorite)
		{		    /* nouveau pic meilleur que l'ancien */
		    preced.lpic = lpic;
		    preced.priorite = precedence;
		} /* < */

		else if (precedence = preced.priorite)
		     {		    /* nouveau pic meilleur que l'ancien ? */

			 switch (precedence)
			 {
			     case 0 : if (hval (&(lpic->pic), s_histo) >
					  hval (&(preced.lpic->pic), s_histo))
					preced.lpic = lpic;
				      break;
			     case 1 :
			     case 2 :
			     case 3 :
			     case 4 :
			     case 6 : if (lpic->ratio > preced.lpic->ratio)
					preced.lpic = lpic;
				      break;
			     case 5 : if (lpic->size > preced.lpic->size)
					preced.lpic = lpic;
				      break;
			 } /* switch */
		     } /* = */
/*printf (" \n priorite %d",preced.priorite);*/
	    } /* if trouve = 1 */

	    precedence ++;
	    
	} /* while not trouve && precedence <= 6 */

					     /* il existe un pic valable */
	lpic = lpic->next_lpic;			/* passage au pic suivant */
    } /* while lpic <> NULL */

    return (preced);
} /* rech_best_pic */

/********************************************************************/
/*								    */
/* Nom : ecrire_masque						    */
/* Fonction : creer un nouveau masque et y ecrire le resultat de la */
/*	      nouvelle segmentation				    */
/* Entree : unsigned char *im0 : ptr sur le masque a segmenter	    */
/*	    unsigned char *pict : ptr sur l'image de depart	    */
/*	    int type : type de l'image				    */
/*	    int lseg, rseg : bornes de la segmentation		    */
/* Global : int taille : taille de l'image			    */
/* Routine : -							    */
/* Sortie : struct pile_im *l_pile1 : ptr sur new masque	    */
/*								    */
/* Made by Christian GIRARD 28.11.1989				    */
/********************************************************************/

struct pile_im * ecrire_masque (im0, pict, type, lseg, rseg)

unsigned char *im0, *pict;
int type, lseg, rseg;

{		    /* declaration des variables */
    unsigned char *im1,			/* ptr sur le nouveau masque */
	      *pict0,		      /* ptr sur l'image a segmenter */
	      *bidon;
    short int *pict1;
    int *pict2, i;
    float *pict3;
    struct pile_im *l_pile1;

		 /* code de la routine ecrire_masque */
    					 /* creation d'un nouveau masque */
    l_pile1 = (struct pile_im *) calloc (1,sizeof(*l_pile1));
    bidon = (unsigned char *) calloc (taille, sizeof (*bidon));
    l_pile1->im = bidon;
    l_pile1->l = lseg;
    l_pile1->r = rseg;
    l_pile1->first_ls = NULL;
    bidon = NULL;
    l_pile1->next_im = NULL;
						 /* application du seuil */
    im1 = l_pile1->im;	 /* resultat de ce stade de segmentation */
    switch (type)
    {		    /* application du seuil sur les deux masques */
	case -1 :
	case 0 : pict0 = pict;			/* ptr sur l'image */
	         for (i = 0; i < taille; i ++)
		 {
		    if (*im0 == 1)
			if ((*pict0 >= lseg) && (*pict0 <= rseg)) 
			{
			    *im1 = 1;
			    *im0 = 0;
			}
			else *im1 = 0;
		    im0 ++;
		    im1 ++;
		    pict0 ++;
		  } /* for */
		  break;
	case 1 : pict1 = (short int *) pict;	/* ptr sur l'image */
		 for (i = 0; i < taille; i ++)
		 {
		    if (*im0 == 1)
			if ((*pict1 >= lseg) && (*pict1 <= rseg))
			{
			    *im1 = 1;
			    *im0 = 0;
			}
			else *im1 = 0;
		    im0 ++;
		    im1 ++;
		    pict1 ++;
		  } /* for */
		  break;
	case 2 : pict2 = (int *) pict;		/* ptr sur l'image */
		 for (i = 0; i < taille; i ++)
		 {
		    if (*im0 == 1)
			if ((*pict2 >= lseg) && (*pict2 <= rseg)) 
			{
			    *im1 = 1;
			    *im0 = 0;
			}
			else *im1 = 0;
		    im0 ++;
		    im1 ++;
		    pict2 ++;
		  } /* for */
		  break;
	case 3 : pict3 = (float *) pict;		/* ptr sur l'image */
	         for (i = 0; i < taille; i ++)
		 {
		    if (*im0 == 1)
			if (((int) rint(*pict3) >= lseg) &&	
				((int) rint(*pict3) <= rseg))
			{
			    *im1 = 1;
			    *im0 = 0;
			}
		        else *im1 = 0;
		    im0 ++;
		    im1 ++;
		    pict3 ++;
		  } /* for */
		  break;
    } /* switch */

return (l_pile1);

} /* ecrire_masque */

/********************************************************************/
/*								    */
/* Nom : ecrire_im						    */
/* Fonction : ecriture d'un masque dans l'image une fois que l'on ne*/
/* peut plus le segmenter plus					    */
/* Entree : int *pict : ptr sur l'image en sortie		    */
/*	    int type : type de l'image d'entree			    */
/*	    unsigned char *im0 : ptr sur l'image du masque	    */
/*	    int region : couleur d'ecriture dans l'image(=no de seg)*/
/* Global : int taille : taille de l'image			    */
/* Routine : -							    */
/* Sortie : -							    */
/*								    */
/* Made by Christian GIRARD 28.11.1989				    */
/********************************************************************/

ecrire_im (pict, type, im0, region)

int *pict, type;
unsigned char *im0;
int region;

{			/* declaration des variables */
    int *pict2, i;
    float *pict3;

			/* code de la routine ecrire_im */
    switch (type)			      /* on met l'image obtenue dans */
    {					     /* l'image segmentee (=picture) */
	case -1 :
	case 0 : 
	case 1 : 
	case 2 : pict2 = pict;
	         for (i = 0; i < taille; i ++)
		 {
		    if (*im0 == 1) *pict2 = region;
		    im0 ++;
		    pict2 ++;
		 } /* for */
		 pict2 = NULL;
		 break;
	case 3 : pict3 = (float *) pict;
	         for (i = 0; i < taille; i ++)
		 {
		    if (*im0 == 1) *pict3 = (float) region;
		    im0 ++;
		    pict3 ++;
		 } /* for */
		 break;
    } /* switch */

} /* ecrire_im */

/********************************************************************/
/*								    */
/* Nom : O_P_R							    */
/* Fonction : methode de Ohlander Price & Reddy de segmentation	    */
/* d'image (methode de seuillage recursive)			    */
/* Entree : unsigned char *pict (ptr sur image a segmenter), 	    */
/*	    int m_size (taille du masque sur l'histogramme)	    */
/* Global : int low : debut de l'histogramme considere		    */
/*		tot : nb de pts sous l'histo lisse		    */
/*		taille, n_line, n_col, mmin, mmax : stat de l'image */
/* Routines : extrema, mov_avg, rech_ratio_2, bat_lpic,		    */
/*	      rech_best_pic, calc_hist, ecrire_masque, ecrire_im    */
/*	      'masque_init					    */
/* Sortie : unsigned char *picture (ptr sur image segmentee)	    */
/*								    */
/* Made by Christian GIRARD 13.4.1989				    */
/********************************************************************/

unsigned char * O_P_R (pict, m_size)

unsigned char *pict;
int m_size;

{
		    /* declaration des variables */

int i, j,					    /* variables de boucle */
    type,						/* type de l'image */
    high, bas,	    /* altitude du plus haut et du plus bas pic de l'histo */
    nb_extr,		/* nombre d'extremas trouves par routine "extrema" */
    taille_histo, t_h,	  /* taille de l'histo & idem pour histo du masque */
    region, /* numero de la segmentation pour ecrire la region dans l'image*/
    size_liss,		   /* taille du masque de lissage de l'histogramme */
    lseg, rseg,		     /* bornes gauche et droite de la segmentation */
    *pict2, *picture2,				  /* pointeurs sur l'image */
    *histo, *s_histo, *w_histo,			 /* ptrs sur l'histogramme */
    *min_max;	    /* ptr sur la liste des extremas fournis par "extrema" */
float *picture3;
struct pile_im *l_pile, *l_pile1, *first_pile;
struct precede preced;
struct list_pic *lpic, *lpic1, *first_pic;
struct list_seg *ls, *f_ls;
struct histogr *ih; /* pour ecrire le vecteur de visualisation de l'histo */
struct description_vecteur *vector;

	    /* corps de la routine de Ohlander Price & Reddy */

pict2 = NULL;
picture2 = NULL;
picture3 = NULL;
f_ls = NULL;

type = dir_desc[index_image[0]].type;	      /* type de l'image a segmenter */
region = 1;		    /* nb de region, utile pour ecrire dans picture */
taille_histo = mmax - mmin + 1;


if ( type <= 2)				    /* creation de l'image d'arrivee */
    picture2 = (int *) calloc (taille, sizeof(*picture2));   
else
    picture3 = (float *) calloc (taille, sizeof(*picture3)); 


histo = calc_hist (pict, type, mmin);		  /* calcul de l'histogramme */

histo = mov_avg (histo, taille_histo, m_size);	/* lissage de l' histogramme */

			    /* recherche du plus haut pic de l'histogramme */
high = 0;				  /* "altitude" du pic <> position */
bas = *histo;				     /* pic le plus court (taille) */
tot = 0;			      /* nombre de points de l'histogramme */
w_histo = histo;
for (i = 0; i < taille_histo; i ++)
{
    if ((*w_histo) > high) high = (*w_histo);
    if ((*w_histo) < bas) bas = (*w_histo);
    tot + = (*w_histo);
    w_histo ++;
}

	/* affectation du vecteur afin de visualiser l'histogramme lisse */
vector = (struct description_vecteur *) calloc (1, sizeof (*vector));
vector->ncase = taille_histo;
vector->b_min = mmin;
vector->b_max = mmax;
vector->vmin = (float) bas;
vector->vmax = (float) high;
vector->total = (float) tot;
vector->type = 2;
vector->genre = 0;

ih = (struct histogr *) calloc (1, sizeof (*ih));
ih->tab_hist = histo;
ih->larg_barre = 1;
ih->haut_barre = 256;
vector->prive = (char *) ih;
if (dir_vecteur [index_vect [1]].image != NULL) free (dir_vecteur 
						    [index_vect [1]].image);
dir_vecteur [index_vect [1]].image = (unsigned char *) histo;
dir_desc_vect [index_vect [1]] = *vector;


			    /* creation du masque initial sur toute l'image */
l_pile = masque_init (mmin, mmax, taille);
first_pile = l_pile;

while (first_pile != NULL) /* exploitation de la pile des masques -> pile vide */
{
    first_pic = NULL;			  /* ptr sur le premier pic detecte */
    t_h = l_pile->r - l_pile->l + 1;

    low = l_pile->l;			  /* position du premier pic non-nul */

/* ATTENTION : les positions calculees a present sont relatives au debut */
	    /* de l'histogramme : pos reelle = pos + low */

    s_histo = histo;			/* debut de l'histogramme du masque */
    for (i = 0; i < low - mmin; i ++)
    {
	s_histo ++;
    }

						/* recherche des extremas */
    min_max = extrema (s_histo, t_h, &nb_extr, l_pile->first_ls); 

				     /* construction de la liste des pics */
    first_pic = bat_lpic (min_max, s_histo, nb_extr, f_ls);

    cfree (min_max);		   /* liberation de la liste des extremas */
    min_max = NULL;

	/* recherche de l'ordre de precedence des pics et du meilleur pic */
    preced = rech_best_pic (first_pic, taille_histo, s_histo, high);

    /* ATTENTION : a partir d'ici les positions sont de nouveau reelles !!! */

		     /* examen de precedence pour prendre le meilleur pic */
    if (preced.priorite != 7)	     /* il existe au moins un pic valable */
    {						   /* lseg = seuil gauche */
	sprintf (buf,mastertabs[179],preced.priorite);
	write_master (buf);

        lseg = preced.lpic->l + low;		   /* lseg = seuil gauche */
	rseg = preced.lpic->r + low;		    /* rseg = seuil droit */

	 /* on stocke toutes les segmentations sur l'image dans une liste */
	ls = (struct list_seg *) calloc (1, sizeof (*ls));
	ls->l = lseg;
	ls->r = rseg;
	ls->next_ls = f_ls;
	f_ls = ls;

	/* on ajoute les bornes de la derniere segmentation sur le masque */
/* utile lors de la recherche des extremas sur le masque = parties a sauter */
	ls = (struct list_seg *) calloc (1, sizeof (*ls));
	ls->l = lseg;
	ls->r = rseg;
	ls->next_ls = l_pile->first_ls;
	l_pile->first_ls = ls;

	/*printf ("segmente a pic l : %d, r : %d \n",lseg, rseg);*/
	sprintf (buf, "pic l : %d, r : %d \n",lseg, rseg);
	write_master (buf);

	 /* creation et ecriture de la nouvelle segmentation dans un masque */
	l_pile1 = ecrire_masque (l_pile->im, pict, type, lseg, rseg);

	l_pile->next_im = l_pile1; /* on ajoute le nouveau masque a la pile */
	l_pile = l_pile1;

    } /* if preced.priorite <> 7 */

    else					  /* pas de pic acceptable */
    {
	l_pile = first_pile;
	l_pile1 = l_pile;
	while (l_pile->next_im != NULL)/* cherche avant last element l_pile1 */
	{
	    l_pile1 = l_pile;
	    l_pile = l_pile->next_im;
	} /* while */
	if (l_pile == first_pile) 
	{
	    first_pile = NULL;
	    l_pile1 = NULL;
	}
	else l_pile1->next_im = NULL;

	if (type == 3) pict2 = (int *) picture3;
	else pict2 = picture2;

  /* ecriture du masque dont la segmentation est finie dans l'image resultat */
	ecrire_im (pict2, type, l_pile->im, region);

	region ++;

	cfree (l_pile->im);		/* destruction du masque de la pile */
	cfree (l_pile->first_ls);
	l_pile = l_pile1;

    } /* else pas de pic acceptable */
 
    lpic1 = NULL;
    lpic = first_pic;			    /* libere la liste des pics */
    while (lpic != NULL)
    {
	first_pic = first_pic->next_lpic;
	cfree (lpic);
	lpic = first_pic;
    } /* while */
 
    w_histo = NULL;

} /* while l_pile <> NULL */

histo = NULL;

if (type <= 2)
{
    first = (unsigned char *) picture2;
    type = 2;
}
else
{
    first = (unsigned char *) picture3;
    type = 3;
}

dir_desc[index_image[1]].nligne = n_line;
dir_desc[index_image[1]].ncolonne = n_col;
dir_desc[index_image[1]].type = type;
dir_image[index_image[1]].image = first;

statis (dir_image[index_image[1]].image,
	dir_desc[index_image[1]].type,
	dir_desc[index_image[1]].nligne,
	dir_desc[index_image[1]].ncolonne,
	&dir_desc[index_image[1]].mmin,
	&dir_desc[index_image[1]].mmax,	
	&dir_desc[index_image[1]].mu,
	&dir_desc[index_image[1]].ecart);

return (first);				/* ptr sur l'image segmentee */

} /* O_P_R */
