#include <stdio.h>
#include <math.h>
#include <values.h>



void wingauss(OutFilter, dimx, dimy, bumpfac, diamwin)
 float *OutFilter, bumpfac;
 int dimx, dimy, diamwin;
{
    float constfac, spread;
    int i,j, midx, midy, posfacxy, posfacy, iprime, ypos, xpos;

    midx = (int) dimx/2 ;
    midy = (int) dimy/2 ;
    constfac = ( -2*(bumpfac*bumpfac) / (diamwin*diamwin));
    spread = diamwin * diamwin / 4;

    for(i=0; (i < dimy); ++i){
	ypos = midy - i;
	posfacy = ypos * ypos;
	iprime = dimy*i;
	for(j=0; (j < dimx); ++j){
	    xpos = midx -j;
	    posfacxy = posfacy + xpos * xpos;
	    if (posfacxy > spread) *(OutFilter + iprime + j) = 0.0;
	    else *(OutFilter + iprime + j)  = exp(constfac * posfacxy);
	}
    }

}



void winhamming(OutFilter, dimx, dimy, diamwin)
 float *OutFilter;
 int dimx, dimy, diamwin;
{
    float constfac, spread;
    int i,j, midx, midy, posfacxy, posfacy, iprime, ypos, xpos;

    midx = (int) dimx/2 +1;
    midy = (int) dimy/2 +1;
    constfac = ( 2 * M_PI * diamwin);
    spread = diamwin * diamwin / 4;

    for(i=0; (i < dimy); ++i){
	ypos = midy - i;
	posfacy = ypos * ypos;
	iprime = dimy*i;
	for(j=0; (j < dimx); ++j){
	    xpos = midx -j;
	    posfacxy = posfacy + xpos * xpos;
	    if (posfacxy > spread) *(OutFilter + iprime + j) = 0.0;
	    else {
		posfacxy = constfac * sqrt(posfacxy);
		*(OutFilter + iprime + j) = cos(posfacxy)*0.46 + 0.54;
	    }
	}
    }

}



void winhanning(OutFilter, dimx, dimy, diamwin)
 float *OutFilter;
 int dimx, dimy, diamwin;
{
    float constfac, spread;
    int i,j, midx, midy, posfacxy, posfacy,  iprime, ypos, xpos;

    midx = (int) dimx/2 +1;
    midy = (int) dimy/2 +1;
    constfac = ( 2 * M_PI * diamwin);
    spread = diamwin * diamwin / 4;

    for(i=0; (i < dimy); ++i){
	ypos = midy - i;
	posfacy = ypos * ypos;
	iprime = dimy*i;
	for(j=0; (j < dimx); ++j){
	    xpos = midx -j;
	    posfacxy = posfacy + xpos * xpos;
	    if (posfacxy > spread) *(OutFilter + iprime + j) = 0.0;
	    else {
		posfacxy = constfac * sqrt(posfacxy);
		*(OutFilter + iprime + j) = cos(posfacxy)*0.5 + 0.5;
	    }
	}
    }

}


