/*****************************************************************************/
/* module contours.c							     */
/*									     */
/* Author: Alain Jacot-Descombes					     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1989							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <math.h>
#include "define.h"
#include "structure.h"
#include "global.h"

static short icon_laplace1[] = {
#include "icon/laplace1.icon"
};
mpr_static (l1_pr, 64, 64, 1, icon_laplace1);

static short icon_laplace2[] = {
#include "icon/laplace2.icon"
};
mpr_static (l2_pr, 64, 64, 1, icon_laplace2);

static short icon_laplace3[] = {
#include "icon/laplace3.icon"
};
mpr_static (l3_pr, 64, 64, 1, icon_laplace3);

static short icon_roberts1[] = {
#include "icon/roberts1.icon"
};
mpr_static (r1_pr, 64, 32, 1, icon_roberts1);

static short icon_roberts2[] = {
#include "icon/roberts2.icon"
};
mpr_static (r2_pr, 64, 32, 1, icon_roberts2);

static short icon_sobel1[] = {
#include "icon/sobel1.icon"
};
mpr_static (s1_pr, 64, 32, 1, icon_sobel1);

static short icon_sobel2[] = {
#include "icon/sobel2.icon"
};
mpr_static (s2_pr, 64, 32, 1, icon_sobel2);

#define	LAPLACE	0
#define	ROBERTS	1
#define	SOBEL	2


int	find_zero();
int	draw();
/* 
float   peaks();
*/
int	limit();
int	permut_buf();

int *edg_roberts();
int *edg_sobel();
int *edg_laplace();
float *edg_frei_chen();


Frame	    frame_question;
Panel	    panel_question;
Panel_item  question;
int	    no_select, flag_conv, flag_autoconvert;

Frame	       frame_sommetsv;	    /* used in ridge_riding	*/
Panel	       panel_sommetsv;
Panel_item     smt_min, smt_max, smt_long;

struct prcd { 
    int	    x;
    int	    y;
    float   val;
};

struct sommet {
    float   min_thr;
    float   max_thr;
    int	    length;
};
struct sommet *ridge_panel();

extern void hproc_sobel();
extern void hproc_laplace();
extern void hproc_roberts();
extern void hproc_frei_chen();
extern void hproc_mero_vassy();
extern void hproc_zero_cross();
extern void hproc_ridge_ride();

extern char *mastertabs[];

/*****************************************************************************/

static Panel_setting lire_choix (item, value, event)
    Panel_item	item;
    int		value;
    Event	*event;
{
    if (event_id(event) == MS_LEFT || event_id(event) == 13) {
	window_return (NULL);
	no_select = value + 1;
	window_destroy (frame_question);
    }
}

/*****************************************************************************/

int question_panel (mode)
    int mode;
{
    frame_question = window_create (frame, FRAME, WIN_X, 500, WIN_Y, 500,
                         FRAME_NO_CONFIRM, TRUE, 
			 WIN_CONSUME_PICK_EVENTS, 
			 WIN_MOUSE_BUTTONS, WIN_ASCII_EVENTS, 0,
			 0);
    panel_question = window_create (frame_question, PANEL, PANEL_LABEL_BOLD,
			 TRUE, 0);
    switch (mode){
	case LAPLACE:
	    question = panel_create_item (panel_question, PANEL_CHOICE,
		PANEL_SHOW_MENU, FALSE,
		PANEL_CHOICE_IMAGES, &l1_pr, &l2_pr, &l3_pr, 0,
		PANEL_NOTIFY_PROC, lire_choix,
		0);
		break;
	case ROBERTS:
	    question = panel_create_item (panel_question, PANEL_CHOICE,
		PANEL_SHOW_MENU, FALSE,
		PANEL_CHOICE_IMAGES, &r1_pr, &r2_pr, 0,
		PANEL_NOTIFY_PROC, lire_choix,
		0);
		break;
	case SOBEL:
	    question = panel_create_item (panel_question, PANEL_CHOICE,
		PANEL_SHOW_MENU, FALSE,
		PANEL_CHOICE_IMAGES, &s1_pr, &s2_pr, 0,
		PANEL_NOTIFY_PROC, lire_choix,
		0);
		break;
    }
    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	panel_set_value (question, (*(int *)macro_cour->param) - 1);
    window_fit(panel_question);
    window_fit(frame_question);
    window_loop (frame_question);
}

/*****************************************************************************/

caddr_t proc_sobel (m, mi)
    Menu m;
    Menu_item mi;

{
    int ligne, colonne, *image;
    unsigned char *temp;

    if (flag_bother){
	 hproc_sobel();
	 return;
    }
    if (flag_help) hproc_sobel();
    if (!flag_creer){
	sprintf (buf, "Sobel "); 
        write_master (buf);
    }
    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	question_panel(SOBEL);
    else if (flag_exec == AUTO || flag_exec == PARAM_AUTO)
	no_select = *(int *)macro_cour->param;
    else no_select = (int) menu_get (mi, MENU_VALUE);
    if (!flag_creer){
	sprintf (buf, mastertabs[18], no_select); 
        write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    }
    else fromto (FROMTO, DEFAUT);
    if (flag_break){ 
	interruption();
	return;
    }
    if (!flag_creer){
		sprintf (buf,"%d --> %d\n",
			index_image[0],index_image[1]);
		write_master (buf);
		switch (dir_desc[index_image[0]].type){
		    case -1:
		    case 0:
		    case 1:flag_conv = TRUE;
			   image = (int *) conv_int (index_image[0]);
			   break;
		    case 2: flag_conv = FALSE;
			    image = (int *)dir_image[index_image[0]].image;
			    break;
		    case 3:
		    case 4:
		    case 5:flag_autoconvert = TRUE;
			   autoconvert_integer(index_image[0]);
			   image = (int *) buffer_image[0].image;
			   break;
		}
		dir_desc[index_image[1]] = dir_desc[index_image[0]];
		dir_desc[index_image[1]].type = 2;
		ligne = dir_desc[index_image[1]].nligne;
		colonne = dir_desc[index_image[1]].ncolonne;
		temp = (unsigned char *) edg_sobel(image,colonne, ligne, no_select);
		if (dir_image[index_image[1]].image != NULL) 
		    free (dir_image[index_image[1]]);
		dir_image[index_image[1]].image = temp;
		if ((flag_conv == TRUE) || (flag_autoconvert == TRUE))
		    free (image);
		statis (dir_image[index_image[1]].image,
			dir_desc[index_image[1]].type, 
			dir_desc[index_image[1]].nligne,
			dir_desc[index_image[1]].ncolonne,
			&(dir_desc[index_image[1]].mmin),
			&(dir_desc[index_image[1]].mmax), 
			&(dir_desc[index_image[1]].mu),
			&(dir_desc[index_image[1]].ecart));
    }
    else {
	    struct commande *com;
	    int *p;
	    com = (struct commande *)new_commande (&macro_cour);
	    com->from[0] = index_image[0];
	    com->to[0] = index_image[1];
	    sprintf (com->nom, "PROEDGSOB");
	    com->code = 100;
	    write_macro (com->nom);
	    p = (int *)malloc(sizeof(*p));
	    *p = no_select;
	    com->param = (char *)p;
	    sprintf (buf, " FROM %d TO %d WITH %d\n",
			    index_image[0], index_image[1], no_select);
	    write_macro (buf);
    }
}
/*****************************************************************************/

caddr_t proc_laplace (m, mi)

    Menu m;
    Menu_item mi;

{
    int ligne, colonne, *image;
    unsigned char *temp;

    if (flag_bother){
	 hproc_laplace();
	 return;
    }
    if (flag_help) hproc_laplace();
    if (!flag_creer){
	sprintf (buf, mastertabs[19]); 
        write_master (buf);
    }
    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	question_panel(LAPLACE);
    else if (flag_exec == AUTO || flag_exec == PARAM_AUTO)
	no_select = *(int *)macro_cour->param;
    else no_select = (int) menu_get (mi, MENU_VALUE);
  /*   no_select -= 1; */
    if (!flag_creer){
	sprintf (buf, mastertabs[20], no_select); 
        write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    }
    else fromto (FROMTO, DEFAUT);
    if (flag_break){
	interruption();
	return;
    }
    if (!flag_creer){
	    sprintf (buf,"%d-->%d\n",
		    index_image[0],index_image[1]);
	    write_master (buf);
	    switch (dir_desc[index_image[0]].type){
		    case -1:
		    case 0:
		    case 1:flag_conv = TRUE;
			   image = (int *) conv_int (index_image[0]);
			   break;
		    case 2: flag_conv = FALSE;
			    image = (int *)dir_image[index_image[0]].image;
			    break;
		    case 3:
		    case 4:
		    case 5:flag_autoconvert = TRUE;
			   autoconvert_integer(index_image[0]);
			   image = (int *) buffer_image[0].image;
			   break;
	    }
	    dir_desc[index_image[1]] = dir_desc[index_image[0]];
	    dir_desc[index_image[1]].type = 2;
	    ligne = dir_desc[index_image[1]].nligne;
	    colonne = dir_desc[index_image[1]].ncolonne;
	    temp =(unsigned char *)edg_laplace(image,colonne,ligne,no_select);
	    if (dir_image[index_image[1]].image != NULL) 
		 free (dir_image[index_image[1]]);
	    dir_image[index_image[1]].image = temp;
	    if (flag_conv == TRUE) free (image);
	    statis (dir_image[index_image[1]].image,
		    dir_desc[index_image[1]].type, 
		    dir_desc[index_image[1]].nligne,
		    dir_desc[index_image[1]].ncolonne,
		    &(dir_desc[index_image[1]].mmin),
		    &(dir_desc[index_image[1]].mmax), 
		    &(dir_desc[index_image[1]].mu),
		    &(dir_desc[index_image[1]].ecart));
    }
    else {
	    struct commande *com;
	    int *p;
	    com = (struct commande *)new_commande (&macro_cour);
	    com->from[0] = index_image[0];
	    com->to[0] = index_image[1];
	    sprintf (com->nom, "PROEDGLAP");
	    com->code = 101;
	    write_macro (com->nom);
	    p = (int *)malloc(sizeof(*p));
	    *p = no_select;
	    com->param = (char *)p;
	    sprintf (buf, " FROM %d TO %d WITH %d\n",
		    index_image[0], index_image[1], no_select);
	    write_macro (buf);
    }
}

/*****************************************************************************/

caddr_t proc_roberts (m, mi)

    Menu m;
    Menu_item mi;

{
    int ligne, colonne, *image;
    unsigned char *temp;

    if (flag_bother){
	 hproc_roberts();
	 return;
    }
    if (flag_help) hproc_roberts();
    if (!flag_creer){
	sprintf (buf, "Roberts"); 
        write_master (buf);
    }
    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	question_panel(ROBERTS);
    else if (flag_exec == AUTO || flag_exec == PARAM_AUTO)
	no_select = *(int *)macro_cour->param;
    else no_select = (int) menu_get (mi, MENU_VALUE);
    if (!flag_creer){
	sprintf (buf, mastertabs[18], no_select); 
        write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    }
    else fromto (FROMTO, DEFAUT);
    if (flag_break){
	interruption();
	return;
    }
    if (!flag_creer){
	    sprintf (buf,"%d --> %d\n",
		    index_image[0],index_image[1]);
	    write_master (buf);
	    switch (dir_desc[index_image[0]].type){
		    case -1:
		    case 0:
		    case 1:flag_conv = TRUE;
			   image = (int *) conv_int (index_image[0]);
			   break;
		    case 2: flag_conv = FALSE;
			    image = (int *)dir_image[index_image[0]].image;
			    break;
		    case 3:
		    case 4:
		    case 5:flag_autoconvert = TRUE;
			   autoconvert_integer(index_image[0]);
			   image = (int *) buffer_image[0].image;
			   break;
	    }
	    dir_desc[index_image[1]] = dir_desc[index_image[0]];
	    dir_desc[index_image[1]].type = 2;
	    ligne = dir_desc[index_image[1]].nligne;
	    colonne = dir_desc[index_image[1]].ncolonne;
	    temp=(unsigned char * )edg_roberts(image,colonne,ligne,no_select);
	    if (dir_image[index_image[1]].image != NULL) 
		    free (dir_image[index_image[1]]);
	    dir_image[index_image[1]].image = temp;
	    if (flag_conv == TRUE) free (image);
	    statis (dir_image[index_image[1]].image,
		    dir_desc[index_image[1]].type, 
		    dir_desc[index_image[1]].nligne,
		    dir_desc[index_image[1]].ncolonne,
		    &(dir_desc[index_image[1]].mmin),
		    &(dir_desc[index_image[1]].mmax), 
		    &(dir_desc[index_image[1]].mu),
		    &(dir_desc[index_image[1]].ecart));
    }
    else {
	    struct commande *com;
	    int *p;
	    com = (struct commande *)new_commande (&macro_cour);
	    com->from[0] = index_image[0];
	    com->to[0] = index_image[1];
	    sprintf (com->nom, "PROEDGROB");
	    com->code = 102;
	    write_macro (com->nom);
	    p = (int *)malloc(sizeof(*p));
	    *p = no_select;
	    com->param = (char *)p;
	    sprintf (buf, " FROM %d TO %d WITH %d\n",
		    index_image[0], index_image[1], no_select);
	    write_macro (buf);
    }
}

/*****************************************************************************/

caddr_t proc_frei_chen(m, mi)

    Menu m;
    Menu_item mi;

{
    int ligne, colonne;
    float *image;
    unsigned char *temp;

    if (flag_bother){
	 hproc_frei_chen();
	 return;
    }
    if (flag_help) hproc_frei_chen();
    if (!flag_creer){
	sprintf (buf, "Frei & Chen"); 
        write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    }
    else fromto (FROMTO, DEFAUT);
    if (flag_break){
	interruption();
	return;
    }
    if (!flag_creer){
	    sprintf (buf,"%d --> %d\n",
		    index_image[0],index_image[1]);
	    write_master (buf);
	    switch (dir_desc[index_image[0]].type){
		    case -1:
		    case 0:
		    case 1:
		    case 2:flag_conv = TRUE;
			   image = (float *) conv_float (index_image[0]);
			   printf("back to proc_fc\n");
			   break;
		    case 3: 
		    case 4:
		    case 5:flag_conv = FALSE;
			    image = (float *)dir_image[index_image[0]].image;
			    break;
			   /* flag_autoconvert = TRUE;
			      autoconvert_float(index_image[0]);
			      image = (float *) buffer_image[0].image;
			      break;
			   */
	    }
	    dir_desc[index_image[1]] = dir_desc[index_image[0]];
	    dir_desc[index_image[1]].type = 3;
	    ligne = dir_desc[index_image[1]].nligne;
	    colonne = dir_desc[index_image[1]].ncolonne;
	    temp=(unsigned char*) edg_frei_chen(image,colonne,ligne);
	    if (dir_image[index_image[1]].image != NULL) 
		    free (dir_image[index_image[1]]);
	    dir_image[index_image[1]].image = temp;
	    if (flag_conv == TRUE) free (image);
	    statis (dir_image[index_image[1]].image,
		    dir_desc[index_image[1]].type, 
		    dir_desc[index_image[1]].nligne,
		    dir_desc[index_image[1]].ncolonne,
		    &(dir_desc[index_image[1]].mmin),
		    &(dir_desc[index_image[1]].mmax), 
		    &(dir_desc[index_image[1]].mu),
		    &(dir_desc[index_image[1]].ecart));
    }
    else {
	struct commande *com;
	com = (struct commande *)new_commande (&macro_cour);
	com->from[0] = index_image[0];
	com->to[0] = index_image[1];
	sprintf (com->nom, "PROEDGFCH");
	com->code = 103;
	write_macro (com->nom);
	com->param = NULL;
	sprintf (buf, " FROM %d TO %d \n", 
		    index_image[0], index_image[1]);
	write_macro (buf);
    }
}


/*****************************************************************************/
/*  Mero_Vassy								     */
/*****************************************************************************/

caddr_t proc_mero_vassy (m, mi)

    Menu m;
    Menu_item mi;

{
    int *bf, *bp1, *bp1_save, *bp2;
    int lin, col, i, j;

    if (flag_bother){
	 hproc_mero_vassy();
	 return;
    }
    if (flag_help) hproc_mero_vassy();
    if (!flag_creer){
	sprintf (buf, "Mero Vassy:");
	write_master(buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    }
    else fromto (FROMTO, DEFAUT);
    if (flag_break){
	interruption();
	return;
    }
    if (flag_creer){
	struct commande *com;
	com = (struct commande *)new_commande (&macro_cour);
	com->from[0] = index_image[0];
	com->to[0] = index_image[1];
	sprintf (com->nom, "PROEDGMVA");
	com->code = 104;
	write_macro (com->nom);
	com->param = NULL;
	sprintf (buf, " FROM %d TO %d \n", 
		    index_image[0], index_image[1]);
	write_macro (buf);
    }
    else{ /* !flag_creer */
	sprintf (buf, " %d-->%d\n",index_image[0],index_image[1]);
	write_master (buf);
	    switch (dir_desc[index_image[0]].type){
		    case -1:
		    case 0:
		    case 1:flag_conv = TRUE;
			   bp1_save = bp1 = (int *) conv_int (index_image[0]);
			   break;
		    case 2:flag_conv = FALSE;
			   bp1_save = bp1 = (int *)dir_image[index_image[0]].image;
			    break;
		    case 3:
		    case 4:
		    case 5:flag_autoconvert = TRUE;
			   autoconvert_integer(index_image[0]);
			   bp1_save = bp1 = (int *) buffer_image[0].image;
			   break;
	    }
	    dir_desc[index_image[1]] = dir_desc[index_image[0]];
	    dir_desc[index_image[1]].type = 2;
	    lin = dir_desc[index_image[1]].nligne;
	    col = dir_desc[index_image[1]].ncolonne;
	    bf = (int *)calloc(lin*col, sizeof(int));
	    bp2 = bf;
	    for (i = 0; i < lin - 1; i++) {
		for (j = 0; j < col - 1; j++) {
		    *bp2 = abs(*(bp1+1) + *(bp1+col+1) - *bp1 - *(bp1+col)) +
			abs(*bp1 + *(bp1+1) - *(bp1 + col) - *(bp1 + col + 1));
		    bp2++; bp1++;
		}
		*bp2 = *bp1;
		bp2++; bp1++;
	    }
	    for (j = 0; j < col; j++) {
	    	*bp2 = *bp1;
		bp2++; bp1++;
	    }
	    if (dir_image[index_image[1]].image != NULL) 
		free (dir_image[index_image[1]]);
	    dir_image[index_image[1]].image = (unsigned char *)bf;
	    statis (dir_image[index_image[1]].image,
		    dir_desc[index_image[1]].type, 
		    dir_desc[index_image[1]].nligne,
		    dir_desc[index_image[1]].ncolonne,
		    &(dir_desc[index_image[1]].mmin),
		    &(dir_desc[index_image[1]].mmax), 
		    &(dir_desc[index_image[1]].mu),
		    &(dir_desc[index_image[1]].ecart));
	    if (flag_conv) free(bp1_save);
    }
    
}

/*****************************************************************************/
/*  Passage par zero							     */
/*****************************************************************************/

caddr_t proc_zero_cross (m, mi)

    Menu m;
    Menu_item mi;

{
    int *bnf, *bp1, *bp1_save, *bp2, *datum;
    int lin, col, i, j, valzero;


    if (flag_bother){
	 hproc_zero_cross();
	 return;
    }
    if (flag_help) hproc_zero_cross();
    if (!flag_creer){
	sprintf (buf, mastertabs[21]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    }
    else fromto (FROMTO, DEFAUT);
    if (flag_break){
	interruption();
	return;
    }
    if (flag_creer){
	struct commande *com;
	com = (struct commande *)new_commande (&macro_cour);
	com->from[0] = index_image[0];
	com->to[0] = index_image[1];
	sprintf (com->nom, "PROEDGZCR");
	com->code = 105;
	write_macro (com->nom);
	com->param = NULL;
	sprintf (buf, " FROM %d TO %d \n", 
		    index_image[0], index_image[1]);
	write_macro (buf);
    }
    else{
	    sprintf (buf, "%d --> %d\n",index_image[0],index_image[1]);
	    write_master (buf);
	    switch (dir_desc[index_image[0]].type){
		    case -1:
		    case 0:
		    case 1:flag_conv = TRUE;
			   bp1_save = bp1 = (int *) conv_int (index_image[0]);
			   break;
		    case 2:flag_conv = FALSE;
			   bp1_save = bp1 = (int *)dir_image[index_image[0]].image;
			    break;
		    case 3:
		    case 4:
		    case 5:flag_autoconvert = TRUE;
			   autoconvert_integer(index_image[0]);
			   bp1_save = bp1 = (int *) buffer_image[0].image;
			   break;
	    }
	    dir_desc[index_image[1]] = dir_desc[index_image[0]];
	    dir_desc[index_image[1]].type = 2;
	    lin = dir_desc[index_image[1]].nligne;
	    col = dir_desc[index_image[1]].ncolonne;
	    datum = (int *)calloc(1, sizeof(int));
	    bnf = (int *)calloc(lin*col, sizeof(int));
	    bp2 = bnf;
	    valzero = (int) dir_desc[index_image[0]].mu;
	    for (i = 0; i < lin - 1; i++) {
		for (j = 0; j < col - 1; j++) {
		    *datum = 0;
		    find_zero(*bp1, *(bp1+1), datum, valzero);	    /*east*/
		    find_zero(*bp1, *(bp1+col), datum, valzero);	    /*south*/
		    find_zero(*bp1, *(bp1+col+1), datum, valzero);    /*south_east*/
		    *bp2 = *datum;
		    bp2++; bp1++;
		}
		*bp2 = 0;
		bp2++; bp1++;
	    }
	    for (j = 0; j < col; j++) {
		*bp2 = 0;
		bp2++; bp1++;
	    }
	    if (dir_image[index_image[1]].image != NULL) 
		free (dir_image[index_image[1]]);
	    dir_image[index_image[1]].image = (unsigned char *)bnf;
	    statis (dir_image[index_image[1]].image,
		    dir_desc[index_image[1]].type, 
		    dir_desc[index_image[1]].nligne,
		    dir_desc[index_image[1]].ncolonne,
		    &(dir_desc[index_image[1]].mmin),
		    &(dir_desc[index_image[1]].mmax), 
		    &(dir_desc[index_image[1]].mu),
		    &(dir_desc[index_image[1]].ecart));
	    if (flag_conv) free(bp1_save);
    }
}

/*****************************************************************************/

int find_zero (fa, fb, fc, s)

    int fa, fb, *fc, s;

{
    int t;

    if (((fa > s) && (fb < s)) || ((fa < s) && (fb > s))) {
	t = (int)(abs(fa) + abs(fb));
	*fc = (t > *fc) ? t : *fc;
    }
}

/*****************************************************************************/
/*  poursuite des sommets						     */
/*****************************************************************************/

#define BS(x, y) bs[x * col + y]

caddr_t proc_ridge_ride(m, mi)

    Menu m;
    Menu_item mi;
{
    float *bs, *brub, *p0, *p0_save, *pb;/* *bres ; */
    float aval, bval,cval;
    int first, l, spi, spj, lin, col, i;
    int segment;
    unsigned char *bres;
    struct prcd *bfpxl;
    struct sommet *psmt;
    char valdefmin[20], valdefmax[20], valdeflen[20];

    if (flag_bother){
	 hproc_ridge_ride();
	 return;
    }
    if (flag_help) hproc_ridge_ride();
    if (!flag_creer){
	sprintf (buf, mastertabs[22]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    }
    else fromto(FROMTO, DEFAUT);
    if (flag_break){
	interruption();
	return;
    }
    if (flag_creer){
		struct commande *com;
	com = (struct commande *)new_commande (&macro_cour);
	com->from[0] = index_image[0];
	com->to[0] = index_image[1];
	sprintf (com->nom, "PROEDGRRI");
	com->code = 106;
	write_macro (com->nom);
	com->param = NULL;
	sprintf (buf, " FROM %d TO %d \n", 
		    index_image[0], index_image[1]);
	write_macro (buf);
    }
    else{
	sprintf (buf, "%d --> %d ",index_image[0],index_image[1]);
	write_master (buf);
	    switch (dir_desc[index_image[0]].type){
		    case -1:
		    case 0:
		    case 1:
		    case 2:flag_conv = TRUE;
			   p0_save = p0 = (float *) conv_float (index_image[0]);
			   break;
		    case 3:flag_conv = FALSE;
			   p0_save = p0 = (float *)dir_image[index_image[0]].image;
			    break;
		    case 4:
		    case 5:flag_autoconvert = TRUE;
			   autoconvert_float(index_image[0]);
			   p0_save = p0 = (float *) buffer_image[0].image;
			   break;
	    }
	    aval = dir_desc[index_image[0]].mmin ;
	    bval = dir_desc[index_image[0]].mmax ;
	    cval = dir_desc[index_image[0]].mu ;
	    sprintf(valdefmin,"%f", aval + (cval - aval)/2);
	    sprintf(valdefmax,"%f", bval - (bval - cval)/2);
	    sprintf(valdeflen,"%d", (int)(dir_desc[index_image[0]].nligne/10));
	    psmt = (struct sommet *)ridge_panel(valdefmin, 
			    valdefmax, valdeflen);
	    if (flag_break) interruption();
	    else {
		sprintf (buf, "(%.4f %.4f %d)\n", 
			psmt->min_thr, psmt->max_thr, psmt->length);
		write_master (buf);
		segment = 0;
		dir_desc[index_image[1]] = dir_desc[index_image[0]];
		dir_desc[index_image[1]].type = -1;
		lin = dir_desc[index_image[1]].nligne;
		col = dir_desc[index_image[1]].ncolonne;
		bfpxl = (struct prcd *)
			calloc(psmt->length + 1, sizeof(struct prcd));
		bs = (float *)calloc(lin * col, sizeof(float));
		brub = (float *)calloc(lin * col, sizeof(float));
/*		bres = (float *)calloc(lin * col, sizeof(float)); */
		bres = (unsigned char *)calloc(lin * col, sizeof(unsigned char));
		pb = bs;
		for (i = 0; i < lin * col; i++) {
		    *pb = *p0; pb++; p0++;
		}				    /*copy image[0] to bs */

		for (spi = 0; spi < lin; spi++) {
		for (spj = 0; spj < col; spj++) {
		    if (BS(spi, spj) >= psmt->max_thr) {
			l = 0;		    /* l passed frm 1st to 2nd half */
			first = 1;	    /* 1st half contour */
			draw(spi,spj, &l, psmt->length, bfpxl,
			    bs, bres, brub, psmt->min_thr, first, lin, col);
	
			permut_buf(bfpxl, l, psmt->length); 
					    /*permutates buf btw. halves*/

			first = 0;	    /* 2nd half contour */
			draw(spi,spj, &l, psmt->length, bfpxl,
			    bs, bres, brub, psmt->min_thr, first, lin, col);

		/* stores only contours >= length; others are destroyed */
			if (l>=psmt->length) {	    /* incr counter */
			    segment++;
			}		    /* if (length >=lt)  */
		    }			    /* if (BS(spi,spj) > ...) */
		}
		}
		free(bfpxl);
		free(bs);
		free(brub);
		if (dir_image[index_image[1]].image != NULL) 
		    free (dir_image[index_image[1]]);
		dir_image[index_image[1]].image = (unsigned char *)bres;
		statis (dir_image[index_image[1]].image,
			dir_desc[index_image[1]].type, 
			dir_desc[index_image[1]].nligne,
			dir_desc[index_image[1]].ncolonne,
			&(dir_desc[index_image[1]].mmin),
			&(dir_desc[index_image[1]].mmax), 
			&(dir_desc[index_image[1]].mu),
			&(dir_desc[index_image[1]].ecart));
	    }
	    if (flag_conv) free (p0_save);
	}
}

/*****************************************************************************/

#define S(x, y) s[x * col + y]
#define RES(x, y) res[x * col + y]
#define RUB(x, y) rub[x * col + y]

draw(i, j, l, lt, bfpxl, s, res, rub, min_thr, first, lin, col)

    int i, j, *l, lt, first, lin, col;
    struct prcd *bfpxl;
    float min_thr;
    float *s, *rub; /*, *res; */
    unsigned char *res;
{
    int bpi, bpj, k, n;
    int F1;
    int FAIL;
    int iinf, isup, jinf, jsup;		    /* coordinates */
    int Pt1Hlf2;			    /* flags 1st pnt of 2nd half */
    float locmax;			    /* value of local maximum */
    int repl;				    /* replace *l */

    repl = *l;
    F1 = TRUE;
    FAIL = FALSE;
    bpi = i; bpj = j;			    /* bpi/bpj savd bef while loop!!*/
    locmax = S(bpi, bpj);		    /* value for first point   */
    if (first == 1) S(bpi, bpj) = 0;	    /* 1st pnt taken only once */

    /* Pt1Hlf2: prevents beg pnt taken twice */
    Pt1Hlf2 = 0;			    /* normally FALSE, but */
    if (first == 0) Pt1Hlf2 = 1;	    /* TRUE when entering 2nd half */

    while (!FAIL) {
	if (repl < lt) {	
	    if (Pt1Hlf2 != 1)	{
		bfpxl[repl].x = i;	
		bfpxl[repl].y = j;
		bfpxl[repl].val = locmax;	 
		repl++;
	    }
	    else Pt1Hlf2 = 0;		    /* only once at 1 */
	    if (repl == lt) {		    /* writes buf     */
		for (k=0; k<repl; k++)
		    RES(bfpxl[k].x, bfpxl[k].y) = 255 ; /* 1.0; */
	    }
	}
	else {				    /*repl>lt: writes all pnts fnd  */
	    if (first==1) {		    /* 1st half contour		    */
		RES(i, j) = 255 ; /* 1.0; */
		repl++;
	    }
	    else {			    /* 2nd half contour, needs test */
		if (Pt1Hlf2 != 1) {	    /* dont write 1st pnt, 2nd half */
		    RES(i, j)= 255 ; /* 1.0; */
		    repl++;
		} else Pt1Hlf2 = 0;
	    }				    
	 }
	locmax = peaks(s, rub, &i, &j, lin, col); /* next extremum along chain*/
	if (locmax < min_thr)		     /*restores into 'source' neighb */
	    if (F1) {			     /*of beg point (w/o 1st and 2nd)*/
		F1 = FALSE;
		limit (i, j, lin, col, &iinf, &isup, &jinf, &jsup);
		for (k=iinf; k<=isup; k++)
		    for (n=jinf; n<=jsup; n++)
			if (RUB(k, n) != 0)  S(k, n) = RUB(k, n);
		limit (bpi, bpj, lin, col, &iinf, &isup, &jinf, &jsup);
		for (k=iinf; k<=isup; k++)
		    for (n=jinf; n<=jsup; n++)
			if (RUB(k, n) != 0)  S(k, n) = RUB(k, n);
		if((locmax==0) || (locmax < min_thr))
		    FAIL = TRUE;
	    }
	    else FAIL = TRUE;
	else F1 = TRUE;			    /* then locmax >= minthr */
    }					    /* while (!FAIL)	     */
    *l = repl;
}

/************************************************************************/

#define IS(x, y) I1[x * column + y]
#define RUBISH(x, y) rubish[x * column + y]

peaks(I1, rubish, i, j, line, column)
    float *I1, *rubish;
    int *i, *j, line, column;

{
    int k, l;
    float m;			/* will contains max in neighborhood*/
    float vt;
    int x,y;
    int icnt;
    static int k_inc[8] = {-1, -1,  1, 1, -1,  0, 1, 0};
    static int l_inc[8] = { 1, -1, -1, 1,  0, -1, 0, 1};

    m = 0.0;
    for (icnt=0; icnt<8; icnt++) {	/* loop over 8-neighborhood     */
	k = *i + k_inc[icnt];
	l = *j + l_inc[icnt];
	if (k < 0) k = 0;
	if (l < 0) l = 0;
	if (k >= line) k = line - 1;
	if (l >= column) l = column - 1;
	vt = IS(k, l);
	if (vt > m) {
	    m = vt;			/*contains largest of 3x3 nghb, not*/
	    x = k; y = l;		/*center point since was put to 0  */
	}
					/* writes into rubish only data != 0*/
	if (vt != 0) RUBISH(k, l) = vt;
	IS(k, l) = 0.0;			/* zeroes I1 progressively	    */
    }

    if (m!=0) {				/*then zeroes rubish at max position*/
	*i = x; *j = y;			/* (thus each max only once)	    */
	RUBISH(x, y) = 0.0;
    }
    return m;
}

/****************************************************************************/

limit(l, c, line, column, linf, lsup,  cinf, csup)
    int l, c, line, column, *linf, *lsup, *cinf, *csup;
{

    *linf = (l <= 0) ? 0 : l-1;
    *cinf = (c <= 0) ? 0 : c-1;
    *lsup = (l < line-1) ? l+1 : line-1;
    *csup = (c < column-1) ? c+1 : column-1;
}

/**************************************************************************/

permut_buf(bfpxl, l, lt)
    struct prcd *bfpxl;
    int l, lt;

{
    struct prcd bufdum;		    /* for permutation		*/
    int ndatperm;			    /* nr data to permutate	*/
    int llt, kk, lkk1;

    if (l <= 0) return;			    /*permutation even if l > lt*/

    if (l > lt) {
	ndatperm = lt/2;
	llt = lt;
    } else {
	ndatperm = l/2;
	llt = l;
    }
    for (kk=0; kk < ndatperm; kk++) {
	lkk1 = llt - kk - 1;
	bufdum.x = bfpxl[kk].x;
	bufdum.y = bfpxl[kk].y;
	bufdum.val = bfpxl[kk].val;
	bfpxl[kk].x = bfpxl[lkk1].x;
	bfpxl[kk].y = bfpxl[lkk1].y;
	bfpxl[kk].val = bfpxl[lkk1].val;
	bfpxl[lkk1].x = bufdum.x;
	bfpxl[lkk1].y = bufdum.y;
	bfpxl[lkk1].val = bufdum.val;
    }
}

/*****************************************************************************/

static Panel_setting lire_sommet (item, event)
    Panel_item item;
    Event *event;

{
    float f;
    static struct sommet smt = {0.0, 0.0, 1};

    if (event_id(event) == CTRLC) {
        /* demande d'interruption de l'interaction par l'utilisateur */
	flag_break = TRUE;
        window_return (NULL);
        window_destroy (frame_sommetsv);
        return;
    }
    else if (event_id(event) == '\t') return(PANEL_NEXT);
    else { 
	   f = atof ((char *) panel_get (smt_min, PANEL_VALUE));
	   smt.min_thr = f;
	   if (smt.min_thr < dir_desc[index_image[0]].mmin) {
	       panel_set_value (item, "\0");
	       return;
	   }
	   f = atof ((char *) panel_get (smt_max, PANEL_VALUE));
	   smt.max_thr = f;
	   if (smt.max_thr < smt.min_thr){
	       panel_set_value (item, "\0");
	       return;
	   }
	   f = atof ((char *) panel_get (smt_long, PANEL_VALUE));
	   smt.length = (int)f;
	   if (smt.length <= 0) {
	       panel_set_value (item, "\0");
	       return;
	   }
           window_return(&smt);
	   window_destroy (frame_sommetsv);
	   return;
    }
}

/*****************************************************************************/

struct sommet *ridge_panel(defval_min, defval_max, defval_len)
char defval_min[20], defval_max[20], defval_len[20];
{
    char *repfloat;
    char stitre[30];
    struct sommet *smt;
    Panel_item	ridge_titre;

    repfloat = (char *)malloc(20);
    frame_sommetsv = window_create (frame, FRAME, WIN_X, 500, WIN_Y, 500,
                         FRAME_NO_CONFIRM, TRUE, 0);
    panel_sommetsv = window_create (frame_sommetsv, PANEL, PANEL_LABEL_BOLD,
			 TRUE, 0);

    strcpy(repfloat,"\0");
    ridge_titre = panel_create_item (panel_sommetsv, PANEL_MESSAGE,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(0),
		       PANEL_LABEL_Y, ATTR_ROW(0),
                       PANEL_LABEL_STRING, paneltabs[296],
                       0);
    smt_min = panel_create_item (panel_sommetsv, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(1),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, "minimum threshd (float):",
                       PANEL_VALUE, defval_min,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_sommet,
                       0);
    smt_max = panel_create_item (panel_sommetsv, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(2),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, "maximum threshd (float):",
                       PANEL_VALUE, defval_max,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_sommet,
                       0);
    smt_long = panel_create_item (panel_sommetsv, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(3),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, "minimum length (int):",
                       PANEL_VALUE, defval_len,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_sommet,
                       0);
    window_fit (panel_sommetsv);
    window_fit (frame_sommetsv);
    window_set (panel_sommetsv, PANEL_CARET_ITEM, smt_min, 0);
    smt = (struct sommet*)window_loop(frame_sommetsv);
    return (smt);
}

/*****************************************************************************/

/*  Date   :
    Subject:Edge detecting subroutines for image analysis.
    Ref    :SubRoutines edg_frei_chen, edg_laplace, edg_sobel1, edg_roberts of the Spider Manual   */
/* ****************************************************************** */


/* Subroutine edg_frei_chen : uses the Frei-Chen Masks,returns a 1-D array.
   ---------------------------------------------------------------------
   performs edge detection using the Frei-Chen Masks and returns a 1-D
   array containing the edge detected image .

   **Parameters**  
   InArray: 1-D Array containing the image.
   DimX, DimY : Dimensions of the image.( DimY is the no. of rows    )
                                        ( DimX is the no. of columns )

   **Returns**
   - NULL if there was not enough memory space for the output array.
   - a 1-D array of reals containing the resultant image
     if there was enough space for the array.
*/

  float *edg_frei_chen (InArray, DimX, DimY)
   int DimX, DimY;
   float *InArray;
  {
     float *OutArray;            /* will contain edge detected image */
     int i,j,il,jl,ik,jk,buf1,buf2;
     int ValIm;
     float SSValIm,Res1Mas,Res2Mas;
     float MaskW1[3][3],MaskW2[3][3]; /* The Frei-Chen Masks  */
	
/* Initialisation of the Frei-Chen Masks */
   MaskW1[0][0]= 1;
   MaskW1[0][1]= 1.41421356;
   MaskW1[0][2]= 1;
   MaskW1[1][0]= 0;
   MaskW1[1][1]= 0;
   MaskW1[1][2]= 0;
   MaskW1[2][0]= -1;
   MaskW1[2][1]= -1.41421356;
   MaskW1[2][2]= -1;


   MaskW2[0][0]= 1;
   MaskW2[0][1]= 0;
   MaskW2[0][2]= -1;
   MaskW2[1][0]= 1.41421356;
   MaskW2[1][1]= 0;
   MaskW2[1][2]= -1.41421356;
   MaskW2[2][0]= 1;
   MaskW2[2][1]= 0;
   MaskW2[2][2]= -1;
 
/* Allocation of memory space for the resultant image */
     OutArray=(float*) malloc(DimX*DimY*sizeof(float));
     if (OutArray == NULL){      /* not enough memory space */
/*           printf("\n sorry no space \n");
	   fprintf(stderr,"Pas azzez de memoire!"); */
           return(OutArray);
     }

/* A point on the 2-D image Image[x,y] is OutArray[DimX*y+ x].  
   Outermost pixels of the resultant image are at zero.
*/
     buf1=DimX*(DimY-1);
     buf2=DimX;       
     for (i=0; i < buf2; ++i){
	  *(OutArray+i)=0;
          *(OutArray+i+buf1)=0;
     }
     buf1=DimX-1;
     buf2=DimY-1;
     for (j=1; j < buf2; ++j){
	   *(OutArray+DimX*j)=0;
           *(OutArray+(DimX*j+buf1))=0;
     }

/* The application of Frei-Chen masks given by:
              sum over i,k of ( Image[x-i,y-k]* W[i,k] )        
              i=1,N-1;j=1,N-1                                         
*/
     for (j=1; j < buf2; ++j)
      for (i=1; i < buf1; ++i){
	    SSValIm=0;
            Res1Mas=0;
            Res2Mas=0;
            for (jl=0; jl < 3; ++jl){
		  jk = j-1+jl;
                  for (il=0; il < 3; ++il){
		/*	ik = i-1+il;*/
                        ValIm = InArray[DimX*jk+(i-1+il)];
                        SSValIm = SSValIm + ValIm * ValIm ;
                        Res1Mas = Res1Mas + ValIm * MaskW1[il][jl];
                        Res2Mas = Res2Mas + ValIm * MaskW2[il][jl];
		  }
	    }
/* Attribution of the resultant value to the array containing the output
   image.
*/
	      *(OutArray+DimX*j+i)=(Res1Mas*Res1Mas+Res2Mas*Res2Mas)/
							    SSValIm;
      }
     return(OutArray);

  }                      






/*  Subroutine edg_roberts : uses the  Roberts Operator, returns a 1-D array.
    --------------------------------------------------------------------
    performs edge detection using the Roberts Operator and returns a 1-D
    array containing the edge detected image .

    **Parameters**  
    InArray    : 1-D Array containing the image.
    DimX, DimY : Dimensions of the image.( DimY is the no. of rows    )
                                        ( DimX is the no. of columns )
    TypEdgMag  : To determine the type of edge magnitude computation,
                 if < 0 then add the absolute difference of diagonally
                        opposite pixel values.
                 if not ,take the sqrt of sum of squares of the
                         difference of diagonally opposite pixel values.

    **Returns**
    - NULL if there was not enough memory space for the output array.
    - A 1-D array of integers containing the resultant image 
      if there was enough space.
*/

  int *edg_roberts (InArray, DimX, DimY, TypEdgMag)
   int DimX, DimY, TypEdgMag;
   int *InArray;
  
  {/*   */
      int i,j,buf1,buf2;
      int DiffDiag, DiagDiff, ValRes, ValBuf;
      int *OutArray;                /* to contain edge detected image */
  

      OutArray=(int*) malloc(DimX*DimY*sizeof(int));
      if (OutArray == NULL)         /* not enough memory space */
      {
/*	  fprintf(stderr,"Pas assez de memoire!"); */
          return(NULL);  
      }
/* A point on the 2-D image Image[x,y] is InArray[Dim*y+x].
   The outermost pixels of the resultant image are at zero.
*/
      buf1=DimX*(DimY-1);
      buf2=DimX;   
     for (i=0; i < buf2; ++i)
       {
	  *(OutArray+i)=0;
          *(OutArray+i+buf1)=0;
       }
     buf1=DimX-1;
     buf2=DimY-1;
     for (j=1; j < buf2; ++j)
       {
	   *(OutArray+DimX*j)=0;
           *(OutArray+(DimX*j+buf1))=0;
       }

/* The application of the Roberts operator is given by:
*/
      for (j=1; j < buf2; ++j)
       for (i=1; i < buf1; ++i)
         {
             DiffDiag=InArray[DimX*j+i] - InArray[DimX*(j+1)+(i+1)];
             DiagDiff=InArray[DimX*j+i+1] - InArray[DimX*(j+1)+i]; 
             ValRes = (TypEdgMag < 0) ? (abs(DiffDiag) + abs(DiagDiff)) : ((int)(sqrt((double)DiffDiag*DiffDiag + DiagDiff*DiagDiff))); 
             *(OutArray+DimX*j+i)=ValRes;
         }      
/* Attribution of the resultant value to the array containing the output
   image.
*/
    return(OutArray);
         
  }
   






/* Subroutine edg_sobel1 : by  Sobel Operator
   ------------------------------------------------------------------
   performs edge detection using the Roberts Operator and returns a 1-D
    array containing the edge detected image .

    **Parameters**  
    InArray    : 1-D Array containing the image.
    DimX, DimY : Dimensions of the image.( DimY is the no. of rows    )
                                        ( DimX is the no. of columns )
    TypEdgMag  : To determine the type of edge magnitude computation,
                 if < 0 then add the absolute difference of diagonally
                        opposite pixel values.
                 if not ,take the sqrt of sum of squares of the
                         difference of diagonally opposite pixel values.

    **Returns**
    - NULL if there was not enough memory space for the output array.
    - a 1-D Array of integers,containing the resultant image
      if there was enough space.
*/

  int *edg_sobel (InArray, DimX, DimY, TypEdgMag)
   int DimX, DimY, TypEdgMag;
   int *InArray;
   
  {/*   */
      int i,j,buf1,buf2;
      int XDiff, YDiff, ValRes, ValBuf;
      int *OutArray;           /* to contain the edge detected image */ 
  
/* Allocation of memory space for the resultant image
*/
      OutArray=(int*) malloc(DimX*DimY*sizeof(int));
      if (OutArray == NULL)
      {
/*	  fprintf(stderr,"Pas assez de place memoire"); */
          return(NULL);
      }
/* A point on the 2-D image Image[x,y] is OutArray[DimX*y+x].
   Outermost pixels of the resultant image are at zero
*/
     buf1=DimX*(DimY-1);
     buf2=DimX;         
     for (i=0; i < buf2; ++i)
       {
	  *(OutArray+i)=0;
          *(OutArray+i+buf1)=0;
       }
     buf1=DimX-1;
     buf2=DimY-1;
     for (j=1; j < buf2; ++j)
       {
	   *(OutArray+DimX*j)=0;
           *(OutArray+(DimX*j+buf1))=0;
       }
/* The application of the Sobel's operator is given by:
*/
      for (j=1; j < buf2; ++j)
       for (i=1; i < buf1; ++i)
         {
             XDiff=(InArray[DimX*(j-1)+i+1] + (2 * InArray[DimX*j+i+1]) + InArray[DimX*(j+1)+(i+1)]) - (InArray[DimX*(j-1)+i-1] + (2 * InArray[DimX*j+i-1]) + InArray[DimX*(j+1)+i-1]);
             YDiff=(InArray[DimX*(j+1)+i-1] + (2 * InArray[DimX*(j+1)+i]) + InArray[DimX*(j+1)+(i+1)]) - (InArray[DimX*(j-1)+i-1] + (2 * InArray[DimX*(j-1)+i]) + InArray[DimX*(j-1)+(i+1)]);
             ValRes = (TypEdgMag < 0) ? (abs(XDiff) + abs(YDiff)) : ( (int)(sqrt((double)(XDiff*XDiff + YDiff*YDiff))));    
/* Attribution of the resultant value to the array containing the output
   image.
*/
             *(OutArray+(DimX*j+i))=ValRes;/*i*10+j;*/
         }
    return(OutArray);      
         
  }
   








/* Subroutine edg_laplace : Edge extraction by  Laplacian Operator
   --------------------------------------------------------------------
   performs edge detection using the Roberts Operator and returns a 1-D
    array containing the edge detected image .

    **Parameters**  
    InArray    : 1-D Array containing the image.
    DimX, DimY : Dimensions of the image.( DimY is the no. of rows    )
                                        ( DimX is the no. of columns )
    TypEdgMag  : To determine the type of edge magnitude computation,
                 the third dimension of the Mask determines which 3X3
                 mask is to be used.

    **Returns**
    - NULL if there was not enough memory space for the output array.
    - a 1-D Array of integers,containing the resultant image
      if there was enough space.
*/

  int *edg_laplace (InArray, DimX, DimY, TypEdgMag)
   int DimX, DimY, TypEdgMag;
   int *InArray;
   
  {
      void PrintImage();
      int i,j,mi,mj,ii,jj,buf1,buf2;
      int DiffDiag, DiagDiff, ValSum;
      int Mask[3][3][3];
      int *OutArray;
  

/* Initialisation of the Laplacian Masks                             */
   Mask[0][0][0]= 0;
   Mask[0][1][0]= -1;
   Mask[0][2][0]= 0;
   Mask[1][0][0]= -1;
   Mask[1][1][0]= 4;
   Mask[1][2][0]= -1;
   Mask[2][0][0]= 0;
   Mask[2][1][0]= -1;
   Mask[2][2][0]= -0;
   Mask[0][0][1]= -1;
   Mask[0][1][1]= -1;
   Mask[0][2][1]= -1;
   Mask[1][0][1]= -1;
   Mask[1][1][1]= 8;
   Mask[1][2][1]= -1;
   Mask[2][0][1]= -1;
   Mask[2][1][1]= -1;
   Mask[2][2][1]= -1;
   Mask[0][0][2]= 1;
   Mask[1][0][2]= -2;
   Mask[2][0][2]= 1;
   Mask[0][1][2]= -2;
   Mask[1][1][2]= 4;
   Mask[2][1][2]= -2;
   Mask[0][2][2]= 1;
   Mask[1][2][2]= -2;
   Mask[2][2][2]= -1;
 
/* Allocation of memory space for the resultant image
*/
      OutArray=(int*) malloc(DimX*DimY*sizeof(int));
      if (OutArray == NULL)
      {
/*	  fprintf(stderr,"Pas assez de memoire!");  */
          return(NULL);
      }
  
/* A point on the 2-D image Image[x,y] is OutArray[DimX*y+x].
   Outermost pixels of the resultant image are at zero
*/
     buf1=DimX*(DimY-1);
     buf2=DimX;         
     for (i=0; i < buf2; ++i)
       {
	  *(OutArray+i)=0;
          *(OutArray+i+buf1)=0;
       }
     buf1=DimX-1;
     buf2=DimY-1;
/* The application of the Laplacian operator is given by:
*/
     for (j=1; j < buf2; ++j)
       {
	   *(OutArray+DimX*j)=0;
           *(OutArray+(DimX*j+buf1))=0;
       }

      for (j=1; j < buf2; ++j)
       for (i=1; i < buf1; ++i) 
         {
	     ValSum=0;
             for (mj= 0; mj < 3; ++mj)
               {
		   jj=j-1+mj;
                   for (mi= 0; mi < 3; ++mi)
                     {
		       /*  ii=i-1+mi; */
                         ValSum=ValSum + InArray[DimX*jj+(i-1+mi)] *  Mask[mi][mj][TypEdgMag];
		     }
	       }  
/* Attribution of the resultant value to the array containing the output
   image.
*/
             *(OutArray+DimX*j+i)=ValSum;
             /* printf("%f",ValSum); */
	  }
       return(OutArray);
  }


