/*
  File: wf2wff.c
  Authors: James Painter,
           K.R. Sloan
  Last Modified: 29 March 1989
  Purpose: Convert a Wiebe format file (.wf) to .WFF format
*/
#include <assert.h>
#include <stdio.h>
#include "wff.h"

static char *RoutineName;
static Usage()
 {
  fprintf( stderr, "Usage: %s < input > output\n", RoutineName );
  exit(1);
 }


/*
  convert a Wiebe scanline to a WFF scanline
 */ 
static void UnPackScanLine(xsize, ScanLineIn, ScanLineOut)
 int xsize;
 unsigned char *ScanLineIn;
 unsigned short *ScanLineOut;
 {
  register unsigned char *pin;
  register unsigned short *pout, *pend;

  pin  = ScanLineIn; 
  pout = ScanLineOut;
  pend = pout + xsize;
  while (pout < pend)
   { /* Unpack the bits, reverse sense, expand to 8 bits */
    *pout++ = (*pin & 0x80) ? 0 : 255 ;  *pin <<= 1;
    *pout++ = (*pin & 0x80) ? 0 : 255 ;  *pin <<= 1;
    *pout++ = (*pin & 0x80) ? 0 : 255 ;  *pin <<= 1;
    *pout++ = (*pin & 0x80) ? 0 : 255 ;  *pin <<= 1;
    *pout++ = (*pin & 0x80) ? 0 : 255 ;  *pin <<= 1;
    *pout++ = (*pin & 0x80) ? 0 : 255 ;  *pin <<= 1;
    *pout++ = (*pin & 0x80) ? 0 : 255 ;  *pin <<= 1;
    *pout++ = (*pin & 0x80) ? 0 : 255 ;
    pin++;
   }
 }


/*  These functions deal with Wiebe files */

static void ReadWiebeHeader(stream, xsize, ysize)
 FILE *stream;
 int *xsize, *ysize;
 {
  int low, high;

  high = getc(stream);
  low  = getc(stream);
  *xsize = high*256 + low;

  high = getc(stream);
  low  = getc(stream);
  *ysize = high*256 + low;
  assert((*xsize > 0) && (*ysize > 0));
 }

static void ReadWiebeScanLine(stream, xsize, ScanLine)
 FILE *stream;
 int xsize;
 unsigned char *ScanLine;
 {
  int nread, toread = (xsize+15)/16;

  nread = fread(ScanLine, 2, toread, stream);
  assert(nread == toread);
 }


/* These function deal with WFF files */

static FrameBufferType *SetUpWFFFile(stream, xsize, ysize)
 FILE *stream;
 int xsize, ysize;
 {
  FrameBufferType *FrameBuffer;
  int Bottom, Left, Top, Right;
  int BitsPerBand;
  char WhatBands[10], Name[NameLength], Value[ValueLength];

  FrameBuffer = (FrameBufferType *)0;
  OpenFB(&FrameBuffer);

  assert(FrameBuffer);
  Bottom = 0; Left = 0; Top = ysize-1; Right = xsize-1;
  SetBounds(FrameBuffer, Bottom, Left, Top, Right);
  strcpy(WhatBands,"I"); BitsPerBand = 8;
  SetColorSystem(FrameBuffer, WhatBands,  BitsPerBand);

  strcpy(Name,"X-CreatedBy");
  strcpy(Value,RoutineName);
  SetDescriptor(FrameBuffer, Name, Value);

  strcpy(Name,"Encoding");
  strcpy(Value,"AIS");
  SetDescriptor(FrameBuffer, Name, Value);

  /* Header operations over, now we can start the output stream */
  PassImageOut(stream, FrameBuffer);
  return FrameBuffer;
 }  

static void WriteWFFScanLine(wffdesc, xsize, ScanLine)
 FrameBufferType *wffdesc;
 int xsize;
 unsigned short *ScanLine;
 {
  assert (SUCCESS == NextNPixelsOut(wffdesc, xsize, ScanLine));
 }


static void CloseWFFFile(wffdesc)
 FrameBufferType *wffdesc;
 {
  CloseFB(&wffdesc);
 }

/*
  The Main Line (are we in Philadelphia, yet?)
 */
int
main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
  int xsize, ysize;
  FrameBufferType *wffdesc;
  unsigned char *ScanLineIn[1024];
  unsigned short *ScanLineOut;
  int i;

  RoutineName = argv[ArgsParsed++];
  if (argc != ArgsParsed)  Usage();

  ReadWiebeHeader(stdin, &xsize, &ysize);

  wffdesc = SetUpWFFFile(stdout, xsize, ysize);
  assert(wffdesc);

  for(i=0; i<ysize; i++) 
   {
    ScanLineIn[i]  = (unsigned char  *) calloc((xsize+15) / 16,
                                               2*sizeof(unsigned char));
    assert(ScanLineIn[i]);
   }

  ScanLineOut = (unsigned short *) calloc(xsize, sizeof(unsigned short));
  assert( ScanLineOut );

  for(i=0; i<ysize; i++)  ReadWiebeScanLine(stdin, xsize, ScanLineIn[i]);

  for(i=ysize-1; i >=0; i--) 
   {
    UnPackScanLine(xsize, ScanLineIn[i], ScanLineOut);
    WriteWFFScanLine(wffdesc, xsize, ScanLineOut);
   }
  CloseWFFFile(wffdesc);
  exit(0);
 }
