/*
  File: Adage2WFF.c
  Authors: K.R. Sloan,
           James Painter
  Last Modified: 2 December 1988
  Purpose: Convert an Adage .iv or .im file to WFF format.
 */
#include <stdio.h>
#include <strings.h>
#include <wff.h>
#include <pic.h>

extern void exit();  /* Makes lint happy */

static char *RoutineName;
static void 
usage()
 {
  (void)fprintf(stderr,"Usage is:\n\t%s\n",RoutineName);
 }

int
main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
  FrameBufferType *FrameBuffer;
  int Left, Bottom, Top, Right, BitsPerBand;
  char WhatBands[ValueLength], Name[NameLength], Value[ValueLength];
  int x,y;
  short Pixel[3];
  pic *image;
  int xsize, ysize;
  FILE *Infile;
  char *filename;
  pic_pixel *ScanLine;

  RoutineName = argv[ArgsParsed++];
  if (ArgsParsed < argc) 
    {
      filename = argv[ArgsParsed++];
      Infile = fopen( filename, "r" );
      if ((FILE *) 0 == Infile)
	{
	  (void) fprintf( stderr,
		  "Unable to open input file: %s\n", filename );
	  exit(1);
	}
    } else {
      filename = "*STDIN*";
      Infile = stdin;
    }

  if (ArgsParsed < argc)  { usage(); exit(1); }

  image = pic_open ( Infile );
  if ((pic *)0 == image)
    {
      (void) fprintf( stderr, 
	      "Input file does not appear to be an adage format file.\n" );
      exit(1);
    }
  pic_read_size( image, &xsize, &ysize );
  ScanLine = (pic_pixel *) malloc( (unsigned int) xsize * sizeof(pic_pixel) );
  if (xsize > 512) xsize=512;
  if (ysize > 512) ysize=512;

  FrameBuffer = (FrameBufferType *)0;
  OpenFB(&FrameBuffer);
  Bottom = 0; Left = 0; Top = ysize-1; Right = xsize-1;
  SetBounds(FrameBuffer, Bottom, Left, Top, Right);
  (void) strcpy(WhatBands,"RGB"); BitsPerBand = 8;
  SetColorSystem(FrameBuffer, WhatBands,  BitsPerBand);

  (void) strcpy(Name,"Title");
  (void) strcpy(Value,filename);
  SetDescriptor(FrameBuffer, Name, Value);

  (void) strcpy(Name,"X-CreatedBy");
  (void) strcpy(Value,RoutineName);
  SetDescriptor(FrameBuffer, Name, Value);

  PassImageOut( stdout, FrameBuffer );
  for(y=Bottom; y<=Top;y++)
   {
     pic_read_line( image, y, ScanLine );
     for(x=Left; x<=Right; x++) 
       {
	 Pixel[0] = ScanLine[x].r;
	 Pixel[1] = ScanLine[x].g;
	 Pixel[2] = ScanLine[x].b;
	 NextPixelOut( FrameBuffer, Pixel );
       }
   }
  CloseFB(&FrameBuffer);
  pic_close(image);
  free((char *) ScanLine);
  exit(0);
 }
