/*
   File: wff2pro.c
   Author: K.R. Sloan
   Last Modified: 12 February 1991
   Purpose: Output an WFF image for printing on an IBM Proprinter
 */

#include <stdio.h>
#include <wff.h>
#include <assert.h>

static int VERBOSE = 0;
static char *RoutineName;
Usage()
 {
  fprintf(stderr,"Usage:\n\t%s [-h][-v][-invert][-o dx dy]\n",RoutineName);
 }

static int Invert = 0;
static double dx = -1;   /* in inches, negative -> center */    
static double dy = -1;   /* in inches, negative -> center */
static void ParseCommandLine (argc, argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;

  RoutineName = argv[ArgsParsed++];
  
  for ( ; ArgsParsed < argc; ArgsParsed++ ) 
   {
    if ('-' != argv[ArgsParsed][0] == '-') {Usage(); exit(-1);}
    switch ( argv[ArgsParsed][1] ) 
     {
      case 'i': if (0 == strcmp(argv[ArgsParsed],"-invert")) Invert = -1;
                else { Usage(); exit(1); }
                break;
      case 'o': if (ArgsParsed < argc) dx = atof(argv[++ArgsParsed]);
                else { Usage(); exit(1); }
                if (ArgsParsed < argc)  dy = atof(argv[++ArgsParsed]);
                else { Usage(); exit(1); }
                break;
      case 'v': VERBOSE = -1; break;  
      default:
      case 'h':  Usage(); exit(1);
     }
   }
 }

static void Pass(fdIn, fdOut)
 FILE *fdIn;
 FILE *fdOut;
 {
  FrameBufferType *FB;
  int width, height;
  unsigned short Pixel[99];
  char WhatBands[ValueLength];
  int Left, Right, Top, Bottom, BitsPerBand, BandsPerPixel;
  int shift;
  int MARGIN;
  int x,y,z,i;
  int n1, n2;
  char BEL=0x07;
  char LF =0x0a;
  char FF =0x0c;
  char CR =0x0d;
  char DC1=0x11;
  char DC2=0x12;
  char ESC=0x1b; 
  double WidthInInches, HeightInInches;
  double TopMargin, LeftMargin;
  int Advance, Clicks;

  FB = (FrameBufferType *)0;
  OpenFB (&FB);
  ReadImage (fdIn, FB);
  GetBounds (FB, &Bottom, &Left, &Top, &Right);
  GetColorSystem (FB, WhatBands, &BitsPerBand);
  if (0 != strcmp(WhatBands, "I"))
   {
    fprintf(stderr, 
           "Warning:  ColorSystem: %s.  Treating first band as Intensity\n",
	    WhatBands );
   }

  width   = Right - Left + 1;
  height  = Top - Bottom + 1;
  shift =  BitsPerBand - 1;

  WidthInInches = (double)width/60.0;
  HeightInInches = (double)height/72.0;
  
  if (0 > dx) LeftMargin = (8.0-WidthInInches)/2.0;
  else        LeftMargin = dx;
  if (0 > dy) TopMargin  = (10.0-HeightInInches)/2.0;
  else        TopMargin  = dy;

  if (VERBOSE) 
   {
    fprintf(stderr,"%s: LeftMargin = %f inches; TopMargin = %f inches\n",
              RoutineName,LeftMargin,TopMargin); 
    fprintf(stderr,"%s: width = %f inches; height = %f inches\n",
              RoutineName,WidthInInches,HeightInInches); 
   }

  /*
     NO Form Feed - assume we start at top of form
   */
  /* fputc(FF,fdOut); */

  /* 
    Instead, move down by TopMargin.
   */

  Clicks = (int)(TopMargin*216.0); /* one inch == 216 Clicks */
  Advance = 216;                   /* maximum convenient step */
  for(; 0 < Clicks;)
   {
    if (Clicks < 216) Advance = Clicks;
    fputc(ESC,fdOut);
    fputc('J',fdOut);
    fputc(Advance,fdOut);
    Clicks -= Advance;
   }

  /*
    position to left margin
   */
  fputc(CR,fdOut);

  /*
     for horizontal positioning, use spaces at 12 characters per inch
   */

  fputc(ESC,fdOut);
  fputc(':',fdOut);
  MARGIN = (int)(LeftMargin/12.0);

  /*
     Write out the image
   */
  n1 = width & 0x000000ff;
  n2 = width >> 8;
  for(y=Top;y>=Bottom;y -= 8)
   {
    for(i=0;i<MARGIN; i++) fputc(' ',fdOut);
    fputc(ESC,fdOut);
    fputc('K',fdOut);
    fputc(n1,fdOut);
    fputc(n2,fdOut);
    for(x=Left;x<=Right;x++)
     {
      register int column;

      for (column=0,z=0;z<8;z++)
       {
        int sample;

        if ((y-z)>=Bottom)
         {
          GetPixel(FB, x, y-z, Pixel);
          sample = (int)Pixel[0];          
         }
        else sample = (1 << BitsPerBand) - 1;
        column = (column << 1) + (sample >> shift);
       }
      /*
         Our convention is that 1 == white, 0 == black
         The printer's is the other way.

         But, if the Invert flag is set,
         then we want 1 == black, 0 == white,
         which matches the printer convention.

         So, if the user says "Invert" - don't invert
         and,if the user says "don't Invert" = invert

         All perfectly clear?    
       */
      if (Invert) fputc(    column,fdOut);
      else        fputc(255-column,fdOut);
     }
    /* carriage return */
    fputc(CR,fdOut);
    /* advance paper by 24/216 inch */
    fputc(ESC,fdOut);
    fputc('J',fdOut);
    fputc(24,fdOut);
   }  

  /*
     return to the default 10 characters per inch
   */
  fputc(DC2,fdOut);

  /*
    leave some space below
   */
  fputc(LF, fdOut);
  fputc(LF, fdOut);

  /*
     NO Form Feed & beep
   */
  /* fputc(FF,fdOut);  */
  /* fputc(BEL,fdOut); */

  fflush(fdOut);
 } 

int main(argc,argv)
 int argc;
 char *argv[];
 {

  ParseCommandLine(argc, argv);
  Pass(stdin, stdout);
  exit(0);
}

