/*
  File  : rgb2wff.c
  Authors: Yun Wang,
           K.R. Sloan
  Last Modified: 21 March 1991
  Purpose: Convert Img rgb into wff file
           Four Inupts: rgbfile.a rgbfile.r rgbfile.g rgbfile.b
           One  Output: wfffile
 */
#include <stdio.h>
#include <strings.h>
#include <assert.h>
#include "wff.h"

int VERBOSE = 0;
static char *RoutineName;

static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s [-h][-v][ImgFileBaseName]\n",
           RoutineName);
 }

static void FatalError(s)
 char *s;
 {
  fprintf(stderr,"%s:FatalError(%s)\n",RoutineName,s); exit(1);
 }

int width,height,length;
unsigned char *Red, *Green, *Blue;

static void
ReadFiles(fdIn)
 FILE *fdIn[];
 {
  fscanf(fdIn[0],"%4d",&width);
  fscanf(fdIn[0],"%4d",&height);
  if (VERBOSE)
   {
    fprintf(stderr,"width  %d\n",width);
    fprintf(stderr,"height  %d\n",height);
   }
  if(ferror(fdIn[0])) FatalError("Error reading attributes");
  length=width*height;

  Red = ( unsigned char *)calloc(sizeof(unsigned char),length);
  if (!Red) FatalError("no memory for Red data");
  fread(Red,sizeof(unsigned char),length,fdIn[1]);
  
  Green = ( unsigned char *)calloc(sizeof(unsigned char),length);
  if (!Green) FatalError("no memory for Green data");
  fread(Green,sizeof(unsigned char),length,fdIn[2]);

  Blue = ( unsigned char *)calloc(sizeof(unsigned char),length);
  if (!Blue) FatalError("no memory for Blue data");
  fread(Blue,sizeof(unsigned char),length,fdIn[3]);
 }

static FrameBufferType *SetUpWFFFile(stream, xsize, ysize)
 FILE *stream;
 int xsize, ysize;
 {
  FrameBufferType *FrameBuffer;
  int Bottom, Left, Top, Right;
  int BitsPerBand;
  char WhatBands[10], Name[NameLength], Value[ValueLength];

  FrameBuffer = (FrameBufferType *)0;

  OpenFB(&FrameBuffer);
  assert(FrameBuffer);

  Bottom = 0; Left = 0; Top = ysize-1; Right = xsize-1;
  SetBounds(FrameBuffer, Bottom, Left, Top, Right);

  /* we only handle the simple case---24bit_RGB ...*/
   BitsPerBand = 8; strcpy(WhatBands,"RGB");
  SetColorSystem(FrameBuffer, WhatBands,  BitsPerBand);


  strcpy(Name,"X-CreatedBy");
  strcpy(Value,RoutineName);
  SetDescriptor(FrameBuffer, Name, Value);

  strcpy(Name,"Encoding");
  strcpy(Value,"AIS");
  SetDescriptor(FrameBuffer, Name, Value);

  /* Header operations over, now we can start the output stream */
  PassImageOut(stream, FrameBuffer);
  return (FrameBuffer);
 }  

static void WriteMappedImage(FB)
 FrameBufferType *FB;
 { 
  unsigned char *R, *G, *B;
  int x,y;

  for(y=0;y<height;y++)
   {
    unsigned short Pixel[3];

    R = &Red[(height-1-y)*width];
    G = &Green[(height-1-y)*width];
    B = &Blue[(height-1-y)*width];
    
    /* this is slow, but you'll find it easier to extend...*/  
    for(x=0;x<width;x++)
     {
        Pixel[0] = (unsigned short) *(R++);
        Pixel[1] = (unsigned short) *(G++);
        Pixel[2] = (unsigned short) *(B++); 
        NextPixelOut(FB, (unsigned short *)Pixel);
      }
    wffFlush(FB);
   }
 }


int
main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
  FrameBufferType *FB;
  int b;
  char *FileName[4],*BaseName;
  FILE *fdIn[4];

  RoutineName = argv[ArgsParsed++];
  BaseName = (char *)0;
  while (ArgsParsed < argc)
   {
    if ('-' == argv[ArgsParsed][0]) 
    switch (argv[ArgsParsed++][1])
     {
      default:
      case 'h':  usage(); exit (-1); 
     }
    else BaseName = argv[ArgsParsed++];
   }  
  if ((char *)0 == BaseName) { usage(); exit (-1); }

  for (b=0;b<4;b++)
   {
    FileName[b]=(char *)malloc(sizeof(char)*(2+strlen(BaseName)));
    strcpy(FileName[b],BaseName);
   }
  strcat(FileName[0],".a");
  strcat(FileName[1],".r"); 
  strcat(FileName[2],".g");
  strcat(FileName[3],".b");

  if (VERBOSE)
   {
    fprintf(stderr,"FileName[0] %s\n",FileName[0]);
    fprintf(stderr,"FileName[1] %s\n",FileName[1]);
    fprintf(stderr,"FileName[2] %s\n",FileName[2]);
    fprintf(stderr,"FileName[3] %s\n",FileName[3]);
   }

  for (b=0;b<4;b++)
    if (!(fdIn[b] = fopen(FileName[b],"r"))) FatalError("fopen failed");

  ReadFiles(fdIn);

  FB = SetUpWFFFile(stdout,width,height);
  assert(FB);

  WriteMappedImage(FB);

  CloseFB(&FB);
  exit(0);

}

