/*
   File: rgb2i.c
   Author: K.R. Sloan, James Painter
   Last Modified: January 12, 1989
   Purpose: Convert an rgb wff file to an intensity image.
 */
#include <stdio.h>
#include <strings.h>
#include <math.h>
#include <wff.h>

static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s\n",
           RoutineName);
 }

static void
Pass(fdIn,fdOut)
 FILE *fdIn, *fdOut;
 {
  FrameBufferType *FBin = NULL, *FBout = NULL;
  int Bottom, Left, Top, Right;
  char Name[NameLength], Value[ValueLength];
  char WhatBands[ValueLength];
  int  BitsPerBand;
  int i, j, x,y,n, width;
  unsigned short *Pixel;
  extern char *malloc( /* unsigned */ );
  int passed = 0, AlphaBand = 0;

  static double cr = .30, cg = .59, cb = .11;  /* Luminance coeffs */  
  if (FAILURE == OpenFB(&FBin))           {                        return; }
  if (FAILURE == PassImageIn(fdIn, FBin)) { (void)CloseFB(&FBin);  return; }
  if (FAILURE == OpenFB(&FBout))          { (void)CloseFB(&FBin);  return; }
 

  /*  Copy over existing NV pairs - watch for "X-PassedBy" */
  for (n=0;;n++)
   {
    GetDescriptorN(FBin, n, Name, Value);
    if (Name[0] == '\0') break;
    if (0 == strcmp(Name,"X-PassedBy"))
     {
      if ( (strlen(Value)+strlen(RoutineName)+3) > ValueLength)
       strcpy(Value,"...");
      strcat(Value,", "); strcat(Value,RoutineName);
      passed = 1;
     }
    SetDescriptor(FBout, Name, Value);
   }

  /*  if necessary, add "X-PassedBy" */
  if (0 == passed)
   {
    strcpy(Name,"X-PassedBy");
    strcpy(Value,RoutineName);
    SetDescriptor(FBout, Name, Value);
   }

   /* Make sure the input image is a RGB image */
  GetColorSystem( FBin, WhatBands, &BitsPerBand );
  if (strcmp(WhatBands,"RGB") != 0 && strcmp(WhatBands,"RGBA") != 0) {
    fprintf( stderr, 
	    "Sorry. This program only knows how to deal with RGB images.\n" );
    exit (1 );
  }
  if (FBin->BandsPerPixel == 3)
    {
      strcpy( WhatBands, "I"); AlphaBand = 0;
    }
  else 
    {
      strcpy( WhatBands, "IA" ); AlphaBand = 1;
    }
      

  /* Set the output color system */
  SetColorSystem( FBout, WhatBands, BitsPerBand );
  
  /* Header operations over, now we can start the output stream */
  if (FAILURE == PassImageOut(fdOut, FBout))
   { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }

  /* Finally, pass the pixels */
  if (FAILURE == GetBounds(FBin, &Bottom, &Left, &Top, &Right))
    { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }

  width = Right-Left+1;
  Pixel = (unsigned short *) 
    malloc ( (unsigned) (width * FBin->BandsPerPixel * sizeof(*Pixel) ) );
  if (Pixel == NULL) 
    {
      fprintf( stderr, "No memory!\n" );
      (void)CloseFB(&FBin); (void)CloseFB(&FBout); return;
    }

  for (y=Bottom;y<=Top;y++)
   {
     if (FAILURE == NextNPixelsIn(FBin,width,Pixel))
       { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }
    
    i=0; j=0;
    for (x=Left;x<=Right;x++)
     {
      Pixel[i++] = (short) (Pixel[j]*cr + Pixel[j+1]*cg + Pixel[j+2]*cb + .5);
      j += FBin->BandsPerPixel - AlphaBand;
      if (AlphaBand) {
	/* We assume the alpha band is the last one in the input image */
	Pixel[i++] = Pixel[j++];
      }
     }
     if (FAILURE == NextNPixelsOut(FBout,width,Pixel))
       { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }
   }
  (void)CloseFB(&FBin);
  (void)CloseFB(&FBout);

 }

main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
 
  RoutineName = argv[ArgsParsed++];
  if (ArgsParsed < argc)  { usage(); exit (-1); }	

  Pass(stdin,stdout);
  exit (0);
}

