/*
   File: mA2RGB.c 
   Authors: Mike Schmidt,
            K.R. Sloan
   Last Modified: 12 April 1988
   Purpose: Convert a complex WFF image file to a RGB WFF image file. 
 */
#include <stdio.h>
#include <strings.h>
#include <math.h>
#include <wff.h>
 

static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s\n",
           RoutineName);
 }

static void
Pass(fdIn,fdOut)
 FILE *fdIn, *fdOut;
 {
  FrameBufferType *FBin = NULL, *FBout = NULL;
  int Bottom, Left, Top, Right;
  char Name[NameLength], Value[ValueLength], WhatBands[NameLength];
  int x,y,n,BitsPerBand,MaxValue;
  double MaxMag,LogMax;
  unsigned short Pixel[3];
  int passed = 0;
  
  if (FAILURE == OpenFB(&FBin))           {                        return; }
  if (FAILURE == PassImageIn(fdIn, FBin)) { (void)CloseFB(&FBin);  return; }
  if (FAILURE == OpenFB(&FBout))          { (void)CloseFB(&FBin);  return; }
 

  GetColorSystem(FBin,WhatBands,&BitsPerBand);
  if (0 != strcmp(WhatBands,"mA"))
   {
    fprintf(stderr,"Input file type is not mA!\n");
    (void)CloseFB(&FBin);
    (void)CloseFB(&FBout);
    return;
   }

 
  /*  Copy over existing NV pairs - watch for "X-PassedBy" */
  for (n=0;;n++)
   {
    GetDescriptorN(FBin, n, Name, Value);
    if (Name[0] == '\0') break;
    if (0 == strcmp(Name,"X-PassedBy"))
     {
      if ( (strlen(Value)+strlen(RoutineName)+3) > ValueLength)
       strcpy(Value,"...");
      strcat(Value,", "); strcat(Value,RoutineName);
      passed = 1;
     }
    SetDescriptor(FBout, Name, Value);
   }


  /*  if necessary, add "X-PassedBy" */
  if (0 == passed)
   {
    strcpy(Name,"X-PassedBy");
    strcpy(Value,RoutineName);
    SetDescriptor(FBout, Name, Value);
   }

  /* Set output file for RGB image and set up local variables. */ 
  SetColorSystem(FBout,"RGB",BitsPerBand);
  GetDescriptor (FBin,"X-MaxMag",Value);
  MaxMag = atof(Value);
  MaxValue = (1 << BitsPerBand) - 1;
  LogMax = log (MaxMag + 1.0);

  /* Header operations over, now we can start the output stream */
  if (FAILURE == PassImageOut(fdOut, FBout))
   { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }

  /* Finally, pass the pixels */
  if (FAILURE == GetBounds(FBin, &Bottom, &Left, &Top, &Right)) 
   { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }
  for (y=Bottom;y<=Top;y++)
   {
    for (x=Left;x<=Right;x++)
     {
      double h,f,s;
      int i,v,p,q,t;

      if (FAILURE == NextPixelIn(FBin,Pixel))
       { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }
      h = (double) Pixel[1] / (double) ((1 << BitsPerBand) / 6 + 1);
      i = (int) h;
      f = h - (double) i;
      s = 0.5;
/*
      v = (exp (Pixel[0]*LogMax/MaxValue) - 1.0)/MaxMag*MaxValue;
 */      
      v = (double)Pixel[0];
      p = v * (1.0 - s);
      q = v * (1.0 - (s * f));
      t = v * (1.0 - (s * (1.0 - f)));

      switch (i) 
       {
        case 0 : Pixel[0] = v; Pixel[1] = t; Pixel[2] = p; break;
        case 1 : Pixel[0] = q; Pixel[1] = v; Pixel[2] = p; break;
        case 2 : Pixel[0] = p; Pixel[1] = v; Pixel[2] = t; break;
        case 3 : Pixel[0] = p; Pixel[1] = q; Pixel[2] = v; break;
        case 4 : Pixel[0] = t; Pixel[1] = p; Pixel[2] = v; break;
        case 5 : Pixel[0] = v; Pixel[1] = p; Pixel[2] = q; break;
       }

      if (FAILURE == NextPixelOut(FBout,Pixel))
       { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }
     }
    wffFlush(FBout);
   }

  (void)CloseFB(&FBin);
  (void)CloseFB(&FBout);

 }

main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
 
  RoutineName = argv[ArgsParsed++];
  if (ArgsParsed < argc)  { usage(); exit (-1); }	

  Pass(stdin,stdout);

  exit (0);
}

