/*
  File: Waves2.c
  Author: K.R. Sloan
  Last Modified: 25 August 1987
  Purpose: generate a WFF image
 */
#include <stdio.h>
#include <strings.h>
#include <math.h>
#include <wff.h>

#define PI  3.14159259


static char *RoutineName;
static void 
usage()
 {
  fprintf(stderr,"Usage is:\n\t%s\n",RoutineName);
 }

int
main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
  FrameBufferType *FrameBuffer = NULL;
  int Left, Bottom, Top, Right, BitsPerBand;
  char WhatBands[10], Name[NameLength], Value[ValueLength];
  unsigned short Pixel[1];

  int x,y;
  int xvalue, yvalue;
  double yPhase, xPhase, yWaves = 8.0, xWaves = 6.0, xAmp = 64.0, yAmp = 64.0;

  RoutineName = argv[ArgsParsed++];
  if (ArgsParsed < argc) { usage(); exit(-1); }


  OpenFB(&FrameBuffer);
  Bottom = 0; Left = 0; Top = 127; Right = 127;

  SetBounds(FrameBuffer, Bottom, Left, Top, Right);
  strcpy(WhatBands,"I"); BitsPerBand = 8;
  SetColorSystem(FrameBuffer, WhatBands,  BitsPerBand);

  strcpy(Name,"Title");
  strcpy(Value,"Waves");
  SetDescriptor(FrameBuffer, Name, Value);

  strcpy(Name,"X-CreatedBy");
  strcpy(Value,RoutineName);
  SetDescriptor(FrameBuffer, Name, Value);

  for (y=Bottom; y<=Top; y++)
   {
    fprintf(stderr,"\n %2d",y);
    yPhase = (double) (y-Left) * yWaves * PI / (double) (Top-Bottom+1);
    while (yPhase > PI) yPhase = yPhase - PI - PI;
    yvalue = (unsigned short) (yAmp * (1.0 + sin(yPhase)));
    for (x=Left; x<=Right; x++)
     {
      fprintf(stderr,".");
      xPhase = (double) (x-Right) * xWaves * PI / (double) (Left-Right+1);
      while (xPhase > PI) xPhase = xPhase - PI - PI;
      xvalue = (unsigned short) (xAmp * (1.0 + sin(xPhase)));
      Pixel[0] = xvalue + yvalue;
      PutPixel(FrameBuffer, x, y, Pixel);
     }
   }
  WriteImage(stdout, FrameBuffer);
  CloseFB(&FrameBuffer);

  fprintf(stderr,"\n             -30-\n");  
  exit(0);
 }
