/*
  File: Separate.c
  Author: K.R. Sloan
  Last Modified: 26 October 1990
  Purpose: Separate one multiband image into n single band images
 */
#include <stdio.h>
#include <strings.h>
#include "wff.h"

static char *RoutineName;

static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s [-b bands band0.wff band1.wff ...][-h]\n",
           RoutineName);
 }

static void FatalError(s)
 char *s;
 {
  fprintf(stderr,"%s\n",s); exit(1);
 }

static void
Pass(WhatBands,BandsPerPixel,fdIn,fdOut)
 char *WhatBands;
 int BandsPerPixel;
 FILE *fdIn;
 FILE *fdOut[];
 {
  FrameBufferType *FBin;
  FrameBufferType *FBout[10]; /* that should be enough */
  int Bottom, Left, Top, Right;
  char Name[NameLength], Value[ValueLength];
  int x,y,n;
  unsigned short *Pixel;
  int passed = 0;
  int b;

  FBin =  (FrameBufferType *)0;
  if (FAILURE == OpenFB(&FBin)) FatalError("OpenFB fails on input");
  if (FAILURE == PassImageIn(fdIn, FBin)) FatalError("PassImageIn fails");

  for(b=0;b<BandsPerPixel;b++)
   {     
    FBout[b] = (FrameBufferType *)0;
    if (FAILURE == OpenFB(&FBout[b])) FatalError("OpenFB fails on output"); 
   }


  /*  Copy over existing NV pairs - watch for "X-PassedBy" */

  for (n=0;;n++)
   {
    GetDescriptorN(FBin, n, Name, Value);
    if (Name[0] == '\0') break;

    if (0 == strcmp(Name,"X-PassedBy"))
     {
      if ( (strlen(Value)+strlen(RoutineName)+3) > ValueLength)
       strcpy(Value,"...");
      strcat(Value,", "); strcat(Value,RoutineName);
      passed = 1;
     }

    /* consistency check */
    if (0 == strcmp(Name,"ColorSystem"))
     {
      if (0 != strcmp(Value, WhatBands)) FatalError("ColorSystem is wrong");
      strcpy(Value,"I"); /* reasonable guess */
     }

    for(b=0;b<BandsPerPixel;b++)
     SetDescriptor(FBout[b], Name, Value);
   }

  /*  if necessary, add "X-PassedBy" */
  if (0 == passed)
   {
    strcpy(Name,"X-PassedBy");
    strcpy(Value,RoutineName);
    for(b=0;b<BandsPerPixel;b++)
     SetDescriptor(FBout[b], Name, Value);
   }

  /* Header operations over, now we can start the output stream */
  
  for(b=0;b<BandsPerPixel;b++)
   if (FAILURE == PassImageOut(fdOut[b], FBout[b]))
    FatalError("PassImageOut failed");

  /* Finally, pass the pixels */
  if (FAILURE == GetBounds(FBin, &Bottom, &Left, &Top, &Right)) 
   FatalError("GetBounds failed");

  Pixel = (unsigned short *) 
    malloc( sizeof(unsigned short) * (unsigned)(BandsPerPixel) );
  if ((unsigned short *)0 == Pixel)
   FatalError("No memory for Pixel buffer");
      
  for (y=Bottom;y<=Top;y++)
   {
    for(x=Left; x <=Right; x++) 
     {
      if (FAILURE == NextPixelIn(FBin, Pixel))
       FatalError("NextPixelIn failed");
      for(b=0; b<BandsPerPixel; b++)
       if (FAILURE == NextPixelOut(FBout[b], Pixel+b))
        FatalError("NextPixelOut failed");
     }
   }       

  (void)CloseFB(&FBin);
  for (b=0;b<BandsPerPixel;b++)(void)CloseFB(&FBout[b]);
 }

int
main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
  char *WhatBands;
  int BandsPerPixel,b;
  char *FileName[10];
  FILE *fdOut[10];

  RoutineName = argv[ArgsParsed++];
  while (ArgsParsed < argc)
   {
    if ('-' != argv[ArgsParsed][0])   { usage(); exit (-1); }
    switch (argv[ArgsParsed++][1])
     {
      case 'b': 
                if (argc <= ArgsParsed)  { usage(); exit (-1); }
                WhatBands = argv[ArgsParsed++];
                BandsPerPixel = strlen(WhatBands);
                if ((argc-ArgsParsed) < BandsPerPixel) { usage(); exit (-1); }
                if (10 < BandsPerPixel) FatalError("too many bands");   
                for (b=0;b<BandsPerPixel;b++)
                 FileName[b] = argv[ArgsParsed++];
                break; 

      default:
      case 'h': { usage(); exit (-1); }
     }
   }  


  for (b=0;b<BandsPerPixel;b++)
   if (!(fdOut[b] = fopen(FileName[b],"w"))) FatalError("fopen failed");

  Pass(WhatBands,BandsPerPixel,stdin,fdOut);

  exit (0);
}

