/*
  File: Conv3x3.c 
  Authors: K.R. Sloan
  Last Modified: 1 October 1990
  Purpose: Convolve with an arbitrary 3x3 kernel (plus DC)
 */

#include <stdio.h>

extern int wff3x3();

static int VERBOSE = 0;
static char *RoutineName;
static void usage()
 {
  fprintf(stderr, "Usage is\n\t%s [-h][-v] -k KernelFile\n",
              RoutineName);
 }

int main(argc, argv)
 int argc;
 char *argv[]; 
 {
  int ArgsParsed = 0;
  char *KernelFileName;
  FILE *KF;
  int newstyle;
  int i,j;
  double t,t0,t1;
  int Template[3][3];
  int DC;
  int c;

  RoutineName = argv[ArgsParsed++];

  for (; ArgsParsed < argc; )
   {
    if ('-' != argv[ArgsParsed][0])
     { 
      fprintf(stderr,"%s: WARNING - old style invocation\n", RoutineName);
      usage(); 
      KernelFileName = argv[ArgsParsed++];
      continue;
     }
    switch (argv[ArgsParsed++][1])
     {
      case 'v': VERBOSE = -1; break;
      case 'k': if (ArgsParsed >= argc) { usage(); exit (-1); }	
                KernelFileName = argv[ArgsParsed++];
                break;
      case 'h':
      default: { usage(); exit (-1); }	
     }
   }

  if ((FILE *)0 == (KF = fopen(KernelFileName,"r")))
   {
    fprintf(stderr,"%s: Can't open %s\n",RoutineName, KernelFileName);
    exit(1);
   }

  newstyle = -1;
  fscanf(KF," %lf %lf", &t0, &t1);
  if ((3.0 != t0) || (3.0 != t1))
   {
    fprintf(stderr,"%s: WARNING - old style kernel file!\n",RoutineName);
    newstyle = 0;
    Template[0][0] = (int)(t0 * 2048.0);
    Template[1][0] = (int)(t1 * 2048.0);
   }
  
  for(j=0;j<3;j++)
   for (i=0;i<3;i++)
    {
     if (newstyle || (j > 0) || (i > 1))
      {
       fscanf(KF," %lf",&t);
       Template[i][j] = (int)(t * 2048.0);
      }
    }
           
  fscanf(KF," %lf",&t);
  DC = (int)(t * 2048.0);
  

  if (VERBOSE)
   {
    for (j=0;j<3;j++)
     {
      for (i = 0;i<3;i++)
       fprintf(stderr," %8d",Template[i][j]);
      fprintf(stderr,"\n");
     } 
    fprintf(stderr," %8d\n",DC);
   }

  if (0 != (c = ferror(KF)))
   {
    fprintf(stderr,"%s: Error reading %s\n",RoutineName, KernelFileName);
    exit(c);
   }

  if (0 != (c = wff3x3(stdin, stdout, Template, DC)))
   fprintf(stderr,"%s: wff3x3 returns %d\n",RoutineName, c);

  exit (c);
 }
