/*
  File: Constant
  Author: K.R. Sloan,
          James Painter
  Last Modified: 12 March, 1988
  Purpose: create a constant image
 */
#include <stdio.h>
#include <strings.h>
#include "wff.h"

static char *RoutineName;
static void 
usage()
 {
  fprintf(stderr,"Usage is:\n\t%s r g b a xsize ysize\n",RoutineName);
 }

int
main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
  FILE *FileDescriptor;
  FrameBufferType *FrameBuffer = NULL;
  int Left, Bottom, Top, Right, BitsPerBand;
  char WhatBands[10], Name[NameLength], Value[ValueLength];
  int xsize = 512, ysize=512, r=0, g=0, b=0, a=255;
  int x,y;
  short Pixel[4];
  int i, count;

  RoutineName = argv[ArgsParsed++];
  if (ArgsParsed < argc) r = atoi(argv[ArgsParsed++]);
  if (ArgsParsed < argc) g = atoi(argv[ArgsParsed++]);
  if (ArgsParsed < argc) b = atoi(argv[ArgsParsed++]);
  if (ArgsParsed < argc) a = atoi(argv[ArgsParsed++]);
  if (ArgsParsed < argc) xsize = atoi(argv[ArgsParsed++]);
  if (ArgsParsed < argc) ysize = atoi(argv[ArgsParsed++]);
  if (ArgsParsed < argc) { usage(); exit(-1); }

  OpenFB(&FrameBuffer);
  Bottom = 0; Left = 0; Top = ysize-1; Right = xsize-1;
  SetBounds(FrameBuffer, Bottom, Left, Top, Right);
  strcpy(WhatBands,"RGBA"); BitsPerBand = 8;
  SetColorSystem(FrameBuffer, WhatBands,  BitsPerBand);

  strcpy(Name,"X-CreatedBy");
  strcpy(Value,RoutineName);
  SetDescriptor(FrameBuffer, Name, Value);

    /* Breaks if RLE encoding is used.  Why?  */
  strcpy(Name,"Encoding");
  strcpy(Value,"RLE");
  SetDescriptor(FrameBuffer, Name, Value);

  /* Header operations over, now we can start the output stream */
  PassImageOut(stdout, FrameBuffer);
  
  Pixel[0] = r;
  Pixel[1] = g;
  Pixel[2] = b;
  Pixel[3] = a;
  count=xsize*ysize;
  for(i=0; i<count; i++)
    NextPixelOut( FrameBuffer, Pixel );
  wffFlush(FrameBuffer);
  CloseFB(&FrameBuffer);

  exit(0);
 }
