/*
   File: Bits.c
   Author: K.R. Sloan
   Last Modified: 29 January 1991
   Purpose: Pass a WFF format image file from stdin to stdout.
            Set the output BitsPerSample to n
 */
#include <stdio.h>
#include <strings.h>
#include <math.h>
#include <wff.h>

int VERBOSE = 0;
static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s [newBits] \n", RoutineName);
 }

extern char *malloc();

static void
Pass(fdIn,fdOut,NewBitsPerBand)
 FILE *fdIn, *fdOut;
 int NewBitsPerBand;
 {
  FrameBufferType *FBin, *FBout;
  int Bottom, Left, Top, Right;
  char Name[NameLength], Value[ValueLength];
  char WhatBands[NameLength];
  int b, bands, BitsPerBand;
  int x,y, n;
  unsigned short *Pixels, *p, *pend; 
  int passed = 0;
  int ScanWidth;
  unsigned short *Lookup;
  int LookupSize;
  int i;

  FBin  = (FrameBufferType *)0;
  FBout = (FrameBufferType *)0;
  if (FAILURE == OpenFB(&FBin))           {                        return; }
  if (FAILURE == PassImageIn(fdIn, FBin)) { (void)CloseFB(&FBin);  return; }
  if (FAILURE == OpenFB(&FBout))          { (void)CloseFB(&FBin);  return; }
 

  /*  Copy over existing NV pairs - watch for "X-PassedBy" */
  for (n=0;;n++)
   {
    GetDescriptorN(FBin, n, Name, Value);
    if (Name[0] == '\0') break;
    if (0 == strcmp(Name,"X-PassedBy"))
     {
      if ( (strlen(Value)+strlen(RoutineName)+3) > ValueLength)
       strcpy(Value,"...");
      strcat(Value,", "); strcat(Value,RoutineName);
      passed = 1;
     }
    SetDescriptor(FBout, Name, Value);
   }

  /*  if necessary, add "X-PassedBy" */
  if (0 == passed)
   {
    strcpy(Name,"X-PassedBy");
    strcpy(Value,RoutineName);
    SetDescriptor(FBout, Name, Value);
   }

  GetColorSystem(FBin, WhatBands, &BitsPerBand);
  bands = strlen(WhatBands);
  SetColorSystem(FBout, WhatBands, NewBitsPerBand);

  /* Header operations over, now we can start the output stream */
  if (FAILURE == PassImageOut(fdOut, FBout))
   { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }

  if (FAILURE == GetBounds(FBin, &Bottom, &Left, &Top, &Right)) 
   { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }

  /* Allocate memory for the scan line and lookup buffer */
  ScanWidth = Right - Left + 1;
  Pixels = (unsigned short *) malloc( ScanWidth*bands*sizeof(unsigned short) );
  pend = Pixels + ScanWidth*bands;
  LookupSize = (1 << BitsPerBand);
  Lookup = (unsigned short *) 
    malloc( LookupSize * sizeof(unsigned short) );
  if ( (Pixels == (unsigned short *) 0L) ||
       (Lookup == (unsigned short *) 0L) )
    {
      fprintf( stderr, "%s: no memory for scanline buffer!\n" );
      exit(1);
    }
      
  /* Fill the lookup table */
  for(i=0; i < LookupSize; i++) 
   {
    register int in, out;
   
    in = i << (16-BitsPerBand); out = 0;
    for(b=0; b < 16; b += BitsPerBand) { out >>= BitsPerBand; out |= in; }
    Lookup[i] = out >> (16-NewBitsPerBand);
    if (VERBOSE) fprintf(stderr,"%s: LUT[%d] = %d\n",RoutineName,i,Lookup[i]);
   }

  /* Finally, pass the pixels */
  for (y=Bottom;y<=Top;y++)
   {
     if (FAILURE == NextNPixelsIn(FBin, ScanWidth,Pixels))
       { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }

     for(p=Pixels; p < pend; p++) *p = Lookup[ *p ];

     if (FAILURE == NextNPixelsOut(FBout,ScanWidth,Pixels))
       { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }
    wffFlush(FBout);
   }

  (void)CloseFB(&FBin);
  (void)CloseFB(&FBout);

 }

int
main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
  int NewBitsPerBand = -1;
  int low = 0, round = 0;

  RoutineName = argv[ArgsParsed++];

  for( ;ArgsParsed < argc; ) 
   {
    if (-1 == NewBitsPerBand) NewBitsPerBand = atoi(argv[ArgsParsed++]);
    else { usage(); exit(1); }
   }

  if ( (NewBitsPerBand <= 0) || (16 < NewBitsPerBand) ) { usage(); exit(1); }

  Pass(stdin,stdout,NewBitsPerBand);

  exit (0);
}
