/*
  File: PaintSpectrum.c
  Author: K.R. Sloan
  Last Modified: 11 June 1991
  Purpose: paint the spectrum computed by xy2rgb
 */

#include <stdio.h>

int VERBOSE = 0;
static char *RoutineName;

static void usage()
 {
  fprintf(stderr,"usage is:\n\t%s [-h][-v]\n",RoutineName); 
 }

static void FatalError(s)
 char *s;
 {
  fprintf(stderr,"%s: FatalError(%s)\n",RoutineName,s);
  exit(-1);
 }

static int l0 = 400;
static int l1 = 700;
static double R[301];
static double G[301];
static double B[301];
static double r[301];
static double g[301];
static double b[301];

static void Read(s,R,G,B,r,g,b)
 FILE *s;
 double R[],G[],B[];
 double r[],g[],b[]; 
 {
  int l,k;
  for(k=0;k<=(l1-l0);k++)
   {
    if (1 != fscanf(s," %d", &l)) break;
    if (k != (l-l0)) FatalError("wrong l");
    if (6 != fscanf(s," %lf %lf %lf %lf %lf %lf",
                        &R[k],&G[k],&B[k],
                        &r[k],&g[k],&b[k])) FatalError("fscanf fails");
   }  
 }

static void Paint(s,r,g,b)
 FILE* s; 
 double r[],g[],b[];
 {
  int l,k;

  fprintf(s,"sgpColorDisplay sgpInit\n");
  fprintf(s,"[450.0 -1.0 650.0 2.0] sgpSetWindow\n");
  fprintf(s,"[  0.0  0.0  1.0 1.0] sgpSetViewport\n");
  fprintf(s,"0.5 sgpGrayLevel sgpClearScreen\n");

  for(l=l0; l<=l1; l++)
   {
    k = l-l0;
    fprintf(s,"[%10.4f %10.4f %10.4f] sgpColor\n",r[k],g[k],b[k]);
    fprintf(s,"[%5d 0] [%5d 1] sgpRectangle\n", l,l+1);
   }

  fprintf(s,"sgpQuit\n");
 }

int main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;

  RoutineName = argv[ArgsParsed++];

  while(ArgsParsed < argc)
   {
    if ('-' != argv[ArgsParsed][0]) {usage(); exit(-1);}
    switch (argv[ArgsParsed++][1])
     {
      case 'v': VERBOSE = -1; break;
      default:
      case 'h': usage(); exit(-1);
     }
   }  

  if (VERBOSE) fprintf(stderr,"%s: Reading ...\n",RoutineName);
  Read(stdin,R,G,B,r,g,b);

  if (VERBOSE) fprintf(stderr,"%s: Painting ...\n",RoutineName);
  Paint(stdout,r,g,b);

  exit(0);
 }

