/*
  File: TestPat.c
  Author: K.R. Sloan, Jr.
  Last Modified: 19 July 1985
  Purpose: test pattern
 */
#include <stdio.h>
#include <math.h>
#include "SGP.h"

static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s [d]\n", RoutineName);
 }
 
static sgpColorType Red   = {1.0, 0.0, 0.0};
static sgpColorType Green = {0.0, 1.0, 0.0};
static sgpColorType Blue  = {0.0, 0.0, 1.0};
static sgpColorType White = {1.0, 1.0, 1.0};
static sgpColorType Gray18= {0.5, 0.5, 0.5};
static sgpColorType Black = {0.0, 0.0, 0.0};
static sgpColorType Pink  = {1.0, 0.5, 0.5};
static sgpColorType Purple= {0.8, 0.1, 0.8};
static sgpColorType Yellow= {0.8, 0.8, 0.1};
static sgpColorType Orange= {1.0, 0.6, 0.1};
static sgpColorType Brown = {0.5, 0.3, 0.1}; 

main(argc, argv)
 int argc;
 char **argv;
 {
  int ArgsParsed = 0;
  sgpDisplayType Display = ColorDisplay;
  sgpRectangleType Window, Viewport;
  sgpPointType Origin, Point1, Point2;
  sgpPointType Points[3];
  sgpColorType Colors[3];
  int line, lines=8;

  RoutineName = argv[ArgsParsed++];

  while (ArgsParsed < argc) 
   {
    if (*argv[ArgsParsed] = 'd') 
     {
      Display = DebugDisplay; 
      ArgsParsed++;
     }
    else
     {
      usage();
      exit (-1);
     }
   }

  fprintf(stderr,"TestPat      19 July 1985     K.R. Sloan, Jr.\n");

  sgpInit(Display);

                        Window.Top    = 1.0;
  Window.Left   = 0.0;                        Window.Right = 1.0;
                        Window.Bottom = 0.0;
  sgpSetWindow(Window);

                        Viewport.Top   = 1.0;
  Viewport.Left   = 0.0;                       Viewport.Right = 1.0;
                        Viewport.Bottom = 0.0;
  sgpSetViewport(Viewport);

  sgpColor(Gray18);
  sgpClearScreen();

  sgpColor(White);
  for (line = 0; line <= lines; line++)
   {
    Point1.x = (double) line / (double) lines;    Point1.y = 0.0;
    Point2.x = Point1.x;                          Point2.y = 1.0;
    sgpLine(Point1, Point2);

    Point1.y = Point1.x; Point1.x = 0.0;
    Point2.y = Point1.y; Point2.x = 1.0;
    sgpLine(Point1, Point2);
   }

  Points[0].x = 0.1; Points[0].y = 0.134; Colors[0] = Black;
  Points[1].x = 0.9; Points[1].y = 0.154; Colors[1] = White;
  Points[2].x = Points[1].x; 
  Points[2].y = Points[0].y; 
  Colors[2] = Colors[1];
  sgpShadeTriangle(Points, Colors);

  Points[2].x = Points[0].x; 
  Points[2].y = Points[1].y; 
  Colors[2] = Colors[0];
  sgpShadeTriangle(Points, Colors);

  Points[0].x = 0.1; Points[0].y = 0.164; Colors[0] = Black;
  Points[1].x = 0.9; Points[1].y = 0.184; Colors[1] = Red;
  Points[2].x = Points[1].x; 
  Points[2].y = Points[0].y; 
  Colors[2] = Colors[1];
  sgpShadeTriangle(Points, Colors);

  Points[2].x = Points[0].x; 
  Points[2].y = Points[1].y; 
  Colors[2] = Colors[0];
  sgpShadeTriangle(Points, Colors);

  Points[0].x = 0.1; Points[0].y = 0.194; Colors[0] = Black;
  Points[1].x = 0.9; Points[1].y = 0.214; Colors[1] = Green;
  Points[2].x = Points[1].x; 
  Points[2].y = Points[0].y; 
  Colors[2] = Colors[1];
  sgpShadeTriangle(Points, Colors);

  Points[2].x = Points[0].x; 
  Points[2].y = Points[1].y; 
  Colors[2] = Colors[0];
  sgpShadeTriangle(Points, Colors);

  Points[0].x = 0.1; Points[0].y = 0.224; Colors[0] = Black;
  Points[1].x = 0.9; Points[1].y = 0.244; Colors[1] = Blue;
  Points[2].x = Points[1].x; 
  Points[2].y = Points[0].y; 
  Colors[2] = Colors[1];
  sgpShadeTriangle(Points, Colors);

  Points[2].x = Points[0].x; 
  Points[2].y = Points[1].y; 
  Colors[2] = Colors[0];
  sgpShadeTriangle(Points, Colors);

  Points[0].x = 0.4; Points[0].y = 0.5; Colors[0] = Blue;
  Points[1].x = 0.6; Points[1].y = 0.55; Colors[1] = Red;
  Points[2].x = 0.5; Points[2].y = 0.75;Colors[2] = Green;
  sgpShadeTriangle(Points, Colors);

  sgpQuit();

  fprintf(stderr,"                   -30-\n");
  exit(0);
 }
