/*
  File: ParsingFunctions.c
  Author: David Meyers
  Last Modified: 8 November 1989
  Purpose: Useful input parsing functions for the Contours package
 */

#include <stdio.h>
#include <string.h>
#include <TypeDefinitions.h>
#include <Contours.h>

extern void exit();

#ifndef TRUE
#define TRUE (1)
#endif TRUE
#ifndef FALSE
#define FALSE (0)
#endif FALSE

/**************************************************************************/

extern int GetLeftBracket(FilePtr)
 FILE *FilePtr;
{
 int CharacterRead;

 for(;;)
  {
   CharacterRead = fgetc(FilePtr);
   if(EOF == CharacterRead)
    {
     return(FALSE);
    }
   else if (' ' == CharacterRead) ;
   else if ('\n' == CharacterRead) ;
   else if('{' == (char) CharacterRead) return(TRUE);
   else
    {
     (void) ungetc(CharacterRead, FilePtr);
     return(FALSE);
    }
  }
}

/**************************************************************************/

extern int GetRightBracket(FilePtr)
 FILE *FilePtr;
{
 int CharacterRead;

 for(;;)
  {
   CharacterRead = fgetc(FilePtr);
   if(EOF == CharacterRead)
    {
     return(FALSE);
    }
   else if (' ' == CharacterRead) ;
   else if ('\n' == CharacterRead) ;
   else if('}' == (char) CharacterRead) return(TRUE);
   else
    {
     (void) ungetc(CharacterRead, FilePtr);
     return(FALSE);
    }
  }
}

/**************************************************************************/

extern void GetIdentifier(FilePtr, ID)
 FILE *FilePtr;
 char *ID;
{
 int NumberMatched;

 NumberMatched = fscanf(FilePtr,"%s", ID);

 if (1 != NumberMatched)
  {
   (void)fprintf(stderr, "Error reading identifier");
   exit(1);
  }
}

/**************************************************************************/

extern void ReadPoint(FilePtr, x, y, z)
 FILE *FilePtr;
 REAL *x, *y, *z;
{
 int Debug = FALSE;

 if (GetLeftBracket(FilePtr))
  {
   if (3 != fscanf(FilePtr, "%f %f %f", x, y, z))
    {
     (void)fprintf(stderr,"improper format, ReadPointValues\n");
     exit(1);
    }
   else if(Debug)
    (void) fprintf(stderr,"x=%f, y=%f, z=%f\n", *x, *y, *z);

   if(Debug)
    {
     (void)fprintf(stderr, "x=%f, y=%f, z=%f\n", *x, *y, *z);
    }
   if (!GetRightBracket(FilePtr))
    {
     (void)fprintf(stderr, "failed to find right bracket, ReadPoint\n");
     exit(1);
    }
  }
 else
  {
   (void)fprintf(stderr,"improper format, ReadPoint\n");
   exit(1);
  }
}

