/*
  File: InputStuff.h
  Author: David Meyers
  Last Modified: 15 November 1989
  Purpose: Functions used in reading the input file format for the Contours
           package.

  The format to be read looks like the following

  { COMMENT comments go here }
  { SECTION SectionName NContours
    { CONTOUR ContourName Npts
      { x1 y1 z1 } ... { xn yn zn }
      { ADJPREV { AdjContourName ThisContourIndex AdjacentContourIndex }
                   ...
		{ AdjContourName ThisContourIndex AdjacentContourIndex }
      }
      { ADJNEXT { AdjContourName ThisContourIndex AdjacentContourIndex }
                   ...
		{ AdjContourName ThisContourIndex AdjacentContourIndex }
      }
      { ALIAS NAliases
        { Name0 }
	{ Name1 }
	...
	{ NameN }
      }
    }
    ...
    { CONTOUR ContourName Npts
      { x1 y1 z1 } ... { xn yn zn } }
  }
  { SECTION SectionName NContours
    { CONTOUR ContourName Npts
      { x1 y1 z1 } ... { xn yn zn } }
    ...
    { CONTOUR ContourName Npts
      { x1 y1 z1 } ... { xn yn zn } }
  }

  The ADJACENT information is optional, and used in cases where several
  contours in one section are connected to one contour in a neighboring
  section.

  The ALIAS information contains the names by which contours in adjacent
  sections which derive from or merge to form this contour are known.

  SectionName and ContourName are arbitrary strings < 80 characters long.
 */

extern void ReadSection(/* FilePtr, TheSection */);
 /*
   FILE *FilePtr;
   Section *TheSection;
  */

extern void ClearSection(/* TheSection */);
/*
  Section *TheSection;
 */
