/*
  File: WETraversal.c
  Author: David Meyers
  Last Modified: 21 August 1990
  Purpose: A set of traversal operators for the Winged Edge data structure.
 */

#include <stdio.h>
#include <WingEdge.h>

/*************************************************************************/

extern WingEdgeNode *NextEdgeCCWFace(TheFace, CurrentEdge)
 WEFaceNode *TheFace;
 WingEdgeNode *CurrentEdge;
{
 WingEdgeNode *NextEdge;

 if(TheFace == CurrentEdge->Left)
  {
   NextEdge = CurrentEdge->DCW;
  }
 else if(TheFace == CurrentEdge->Right)
  {
   NextEdge = CurrentEdge->OCW;
  }
 else /* Error condition here */
  {
   NextEdge = NULL;
  }
 return(NextEdge);
}

/*************************************************************************/

extern WingEdgeNode *NextEdgeCWFace(TheFace, CurrentEdge)
 WEFaceNode *TheFace;
 WingEdgeNode *CurrentEdge;
{
 WingEdgeNode *NextEdge;

 if(TheFace == CurrentEdge->Left)
  {
   NextEdge = CurrentEdge->OCCW;
  }
 else if(TheFace == CurrentEdge->Right)
  {
   NextEdge = CurrentEdge->DCCW;
  }
 else /* Error condition here */
  {
   NextEdge = NULL;
  }
 return(NextEdge);
}

/*************************************************************************/

extern WingEdgeNode *NextEdgeCCWVertex(TheVertex, CurrentEdge)
 WEVertexNode *TheVertex;
 WingEdgeNode *CurrentEdge;
{
 WingEdgeNode *NextEdge;

 if(TheVertex == CurrentEdge->Org)
  {
   NextEdge = CurrentEdge->OCCW;
  }
 else if(TheVertex == CurrentEdge->Dest)
  {
   NextEdge = CurrentEdge->DCCW;
  }
 else /* Error condition here */
  {
   NextEdge = NULL;
  }
 return(NextEdge);
}

/*************************************************************************/

extern WingEdgeNode *NextEdgeCWVertex(TheVertex, CurrentEdge)
 WEVertexNode *TheVertex;
 WingEdgeNode *CurrentEdge;
{
 WingEdgeNode *NextEdge;

 if(TheVertex == CurrentEdge->Org)
  {
   NextEdge = CurrentEdge->OCW;
  }
 else if(TheVertex == CurrentEdge->Dest)
  {
   NextEdge = CurrentEdge->DCW;
  }
 else /* Error condition here */
  {
   NextEdge = NULL;
  }
 return(NextEdge);
}

/*************************************************************************/

extern WEFaceNode *NextFaceCCW(TheVertex, CurrentFace)
 WEVertexNode *TheVertex;
 WEFaceNode *CurrentFace;
{
 WingEdgeNode *CurrentEdge;
 WEFaceNode *NewFace;
 

 CurrentEdge = TheVertex->Edges;
 while( (CurrentFace != CurrentEdge->Left) && 
        (CurrentFace != CurrentEdge->Right)   )
  CurrentEdge = NextEdgeCCWVertex(TheVertex, CurrentEdge);

 if(TheVertex == CurrentEdge->Org)
  {
   if(CurrentFace == CurrentEdge->Left)
    CurrentEdge = NextEdgeCCWVertex(TheVertex, CurrentEdge);
   if(TheVertex == CurrentEdge->Org)
    NewFace = CurrentEdge->Left;
   else
    NewFace = CurrentEdge->Right;
  }
 else if(TheVertex == CurrentEdge->Dest)
  {
   if(CurrentFace == CurrentEdge->Right)
    CurrentEdge = NextEdgeCCWVertex(TheVertex, CurrentEdge);
   if(TheVertex == CurrentEdge->Org)
    NewFace = CurrentEdge->Left;
   else
    NewFace = CurrentEdge->Right;
  }
 else /* Error condition here */
  {
   NewFace = NULL;
  }
 return(NewFace);
}

/*************************************************************************/

extern WEFaceNode *NextFaceCW(TheVertex, CurrentFace)
 WEVertexNode *TheVertex;
 WEFaceNode *CurrentFace;
{
 WingEdgeNode *CurrentEdge;
 WEFaceNode *NewFace;
 

 CurrentEdge = TheVertex->Edges;
 while( (CurrentFace != CurrentEdge->Left) && 
        (CurrentFace != CurrentEdge->Right)   )
  CurrentEdge = NextEdgeCWVertex(TheVertex, CurrentEdge);

 if(TheVertex == CurrentEdge->Org)
  {
   if(CurrentFace == CurrentEdge->Right)
    CurrentEdge = NextEdgeCWVertex(TheVertex, CurrentEdge);
   if(TheVertex == CurrentEdge->Org)
    NewFace = CurrentEdge->Right;
   else
    NewFace = CurrentEdge->Left;
  }
 else if(TheVertex == CurrentEdge->Dest)
  {
   if(CurrentFace == CurrentEdge->Left)
    CurrentEdge = NextEdgeCWVertex(TheVertex, CurrentEdge);
   if(TheVertex == CurrentEdge->Org)
    NewFace = CurrentEdge->Right;
   else
    NewFace = CurrentEdge->Left;
  }
 else /* Error condition here */
  {
   NewFace = NULL;
  }
 return(NewFace);
}

/*************************************************************************/

extern WEVertexNode *NextVertexCCW(TheFace, CurrentVertex)
 WEFaceNode *TheFace;
 WEVertexNode *CurrentVertex;
{
 WEVertexNode *NextVertex;
 WingEdgeNode *CurrentEdge;

 CurrentEdge = TheFace->Edges;
 while( (CurrentVertex != CurrentEdge->Org) && 
        (CurrentVertex != CurrentEdge->Dest)  )
  {
   CurrentEdge = NextEdgeCCWFace(TheFace, CurrentEdge);
  }

 if(TheFace == CurrentEdge->Left)
  {
   if(CurrentVertex == CurrentEdge->Dest)
    CurrentEdge = CurrentEdge->DCW;

   if(CurrentVertex == CurrentEdge->Dest)
    NextVertex = CurrentEdge->Org;
   else
    NextVertex = CurrentEdge->Dest;
  }
 else if(TheFace == CurrentEdge->Right)
  {
   if(CurrentVertex == CurrentEdge->Org)
    CurrentEdge = CurrentEdge->OCW;

   if(CurrentVertex == CurrentEdge->Dest)
    NextVertex = CurrentEdge->Org;
   else
    NextVertex = CurrentEdge->Dest;
  }
 else /* Error condition here */
  {
   NextVertex = NULL;
  }
 return(NextVertex);
}

/*************************************************************************/

extern WEVertexNode *NextVertexCW(TheFace, CurrentVertex)
 WEFaceNode *TheFace;
 WEVertexNode *CurrentVertex;
{
 WEVertexNode *NextVertex;
 WingEdgeNode *CurrentEdge;

 CurrentEdge = TheFace->Edges;
 while( (CurrentVertex != CurrentEdge->Org) && 
        (CurrentVertex != CurrentEdge->Dest)  )
  {
   CurrentEdge = NextEdgeCWFace(TheFace, CurrentEdge);
  }

 if(TheFace == CurrentEdge->Right)
  {
   if(CurrentVertex == CurrentEdge->Dest)
    CurrentEdge = CurrentEdge->DCCW;

   if(CurrentVertex == CurrentEdge->Dest)
    NextVertex = CurrentEdge->Org;
   else
    NextVertex = CurrentEdge->Dest;
  }
 else if(TheFace == CurrentEdge->Left)
  {
   if(CurrentVertex == CurrentEdge->Org)
    CurrentEdge = CurrentEdge->OCCW;

   if(CurrentVertex == CurrentEdge->Dest)
    NextVertex = CurrentEdge->Org;
   else
    NextVertex = CurrentEdge->Dest;
  }
 else /* Error condition here */
  {
   NextVertex = NULL;
  }
 return(NextVertex);
}

/*************************************************************************/
