/****************************************************************************
*
*                         The Universal VESA VBE
*
*                   Copyright (C) 1993 Kendall Bennett.
*                           All rights reserved.
*
* Filename:     $RCSfile: _video7.c $
* Version:      $Revision: 1.2 $
*
* Language:     ANSI C
* Environment:  IBM PC (MS DOS)
*
* Description:  C language support routines for Video 7 SuperVGA's. Contains
*               detection code, mode translation tables and chipset
*               names.
*
* $Id: _video7.c 1.2 1993/09/24 05:22:51 kjb release $
*
* Revision History:
* -----------------
*
* $Log: _video7.c $
* Revision 1.2  1993/09/24  05:22:51  kjb
* Fixed a number of bugs.
*
* Revision 1.1  1993/09/19  01:26:40  kjb
* Initial revision
*
****************************************************************************/

/* Mode translation table to determine the values to place into
 * AX and BX in order to initialise a particular video mode
 * via int 10h.
 */

short VIDEO7Modes[] = { 0x6F05, 0x62,   /* 800x600 16 color     */
                        0x6F05, 0x65,   /* 1024x768 16 color    */
						0x6F05, 0x70,   /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0x6F05, 0x66,   /* 640x400 256 color    */
                        0x6F05, 0x67,   /* 640x480 256 color    */
                        0x6F05, 0x69,   /* 800x600 256 color    */
                        0x6F05, 0x6A,   /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0, 0,           /* 640x480 32k color    */
                        0, 0,           /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0, 0,           /* 640x480 64k color    */
                        0, 0,           /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

typedef enum {
    grVIDEO7_V1,            /* Video7 versions 1-4 chipsets         */
    grVIDEO7_V5,            /* Video7 version 5 chipsets            */
    } VIDEO7_chipsets;

/* Names of chip revision id's. */

char *Video7Names[] = {
    "Versions 1-4",
    "Version 5",
    };

bool findVideo7(int *superVGA,int *chipID,int *memory,int *dac,int *pageFlip)
/****************************************************************************
*
* Function:     findVideo7
* Parameters:   superVGA    - ID of the SuperVGA card
*               chipID      - Internal chip ID number
*               memory      - Amount of memory of card
*               dac         - Type of DAC installed
*               pageFlip    - True if page flipping supported
* Returns:      True if card was detected
*
* Description:  Detects the presence of Video7 based SuperVGA's.
*
****************************************************************************/
{
    union REGS  regs;

    regs.x.ax = 0x6F00;
    regs.x.bx = 0x0000;
    int86(0x10,&regs,&regs);
    if (regs.x.bx != 0x5637)
        goto NoVideo7;

    /* We have a Video7 based SuperVGA */

    *superVGA = grSVGA_VIDEO7;
    *pageFlip = true;

    regs.x.ax = 0x6F07;
    int86(0x10,&regs,&regs);
    *chipID = grVIDEO7_V1;
    if (regs.h.bl <= 0x5F)
        *chipID = grVIDEO7_V5;

    regs.h.ah &= 0x7f;
    if (regs.h.ah == 0)
        *memory = 256;
    else if (regs.h.ah == 2)
        *memory = 512;
    else *memory = 1024;
    return true;

NoVideo7:
    return false;
}
