/****************************************************************************
*
*                         The Universal VESA VBE
*
*                   Copyright (C) 1993 Kendall Bennett.
*                           All rights reserved.
*
* Filename:     $RCSfile: _tables.c $
* Version:      $Revision: 1.1 $
*
* Language:     ANSI C
* Environment:  IBM PC (MS DOS)
*
* Description:  Module containing the lookup tables to collect the
*               together the various modules specific to each chipset
*               into some semblence of order. The order of things in these
*               tables is defined by the numerical ordering of the
*               id's for each individual chipsets. If you add a new one
*               it will have to go at the end.
*
* $Id: _tables.c 1.1 1993/09/19 01:26:26 kjb release $
*
* Revision History:
* -----------------
*
* $Log: _tables.c $
* Revision 1.1  1993/09/19  01:26:26  kjb
* Initial revision
*
****************************************************************************/

/* Lookup table to find the correct mode table for a specific video
 * adapter board. These tables should have been defined in the
 * source modules included above.
 */

short *ModeTables[] = {
    ATIModes,
    AHEADModes,
    CHIPSModes,
    EVEREXModes,
    GENOAModes,
    OAKModes,
    PARADModes,
    TRIDENTModes,
    VIDEO7Modes,
    TSENGModes,
    NCRModes,
    S3Modes,
    ACUMOSModes,
    AVANCEModes,
    MXICModes,
    PRIMUSModes,
    REALTEKModes,
    CIRRUSModes,
    };

/* Table of SuperVGA names */

char *SuperVGANames[] = {
    "ATI SuperVGA",
    "AHEAD SuperVGA",
    "Chips & Tech SuperVGA",
    "Everex SuperVGA",
    "Genoa SuperVGA",
    "OAK SuperVGA",
    "Paradise SuperVGA",
    "Trident SuperVGA",
    "Video7 SuperVGA",
    "Tseng Labs SuperVGA",
    "NCR SuperVGA",
    "S3 SuperVGA",
    "AcuMos SuperVGA",
    "Avance Logic SuperVGA",
    "MXIC SuperVGA",
    "Primus SuperVGA",
    "RealTek SuperVGA",
    "Cirrus Logic SuperVGA",
    };

/* Index table into individual chipset revision names.  */

char **chipsetNames[] = {
    ATINames,
    AheadNames,
    ChipsNames,
    EverexNames,
    GenoaNames,
    OakNames,
    ParadiseNames,
    TridentNames,
    Video7Names,
    TsengNames,
    NCRNames,
    S3Names,
    AcuMosNames,
    AvanceNames,
    MXICNames,
    PrimusNames,
    RealTekNames,
    CirrusNames,
    };
