/****************************************************************************
*
*                         The Universal VESA VBE
*
*                   Copyright (C) 1993 Kendall Bennett.
*                           All rights reserved.
*
* Filename:     $RCSfile: _ncr.c $
* Version:      $Revision: 1.1 $
*
* Language:     ANSI C
* Environment:  IBM PC (MS DOS)
*
* Description:  C language support routines for NCR SuperVGA's. Contains
*               detection code, mode translation tables and chipset
*               names.
*
* $Id: _ncr.c 1.1 1993/09/19 01:26:26 kjb release $
*
* Revision History:
* -----------------
*
* $Log: _ncr.c $
* Revision 1.1  1993/09/19  01:26:26  kjb
* Initial revision
*
****************************************************************************/

/* Mode translation table to determine the values to place into
 * AX and BX in order to initialise a particular video mode
 * via int 10h.
 */

short NCRModes[] = {    0x58, 0,        /* 800x600 16 color     */
                        0x5D, 0,        /* 1024x768 16 color    */
                        0x67, 0,        /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0x5E, 0,        /* 640x400 256 color    */
                        0x5F, 0,        /* 640x480 256 color    */
                        0x5C, 0,        /* 800x600 256 color    */
                        0x61, 0,        /* 1024x768 256 color   */
                        0x6A, 0,        /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0x71, 0,        /* 640x480 32k color    */
                        0x72, 0,        /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0x78, 0,        /* 640x480 64k color    */
                        0x79, 0,        /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

typedef enum {
    grNCR_77C21,            /* NCR 77C21 chipset                        */
    grNCR_77C22,            /* NCR 77C22 chipset                        */
    grNCR_77C22E,           /* NCR 77C22E chipset                       */
    grNCR_77C22E_PLUS,      /* NCR 77C22E+ chipset                      */
    } NCR_chipsets;

/* Names of chip revision id's. */

char *NCRNames[] = {
    "77C21",
    "77C22",
    "77C22E",
    "77C22E+",
    };

bool findNCR(int *superVGA,int *chipID,int *memory,int *dac,int *pageFlip)
/****************************************************************************
*
* Function:     findNCR
* Parameters:   superVGA    - ID of the SuperVGA card
*               chipID      - Internal chip ID number
*               memory      - Amount of memory of card
*               dac         - Type of DAC installed
*               pageFlip    - True if page flipping supported
* Returns:      True if card was detected
*
* Description:  Detects the presence of NCR based SuperVGA's.
*
****************************************************************************/
{
    int old,chip;

    old = rdinx(SEQ,5);
    if (!tstinx(SEQ,5,5))       /* Test for extended register enable    */
        goto NoNCR;
    wrinx(SEQ,5,0);             /* Disable extended registers           */
    if (tstinx(SEQ,0x10,0xFF))
        goto NoNCR;
    wrinx(SEQ,5,1);             /* Enable extended registers            */
    if (!tstinx(SEQ,0x10,0xFF))
        goto NoNCR;

    /* We have an NCR based SuperVGA */

    *superVGA = grSVGA_NCR;
    *pageFlip = true;
    *memory = 0;                /* Don't know how to detect memory size */

    chip = rdinx(SEQ,8) >> 4;
    if (chip < 2) {
        if (chip == 0)
            *chipID = grNCR_77C22;
        else *chipID = grNCR_77C21;
        unsupportedMode(vbe_1280x1024x16,NCRModes);
        unsupportedMode(vbe_1024x768x256,NCRModes);
        unsupportedMode(vbe_1280x1024x256,NCRModes);
        }
    else {
        if (chip == 2)
            *chipID = grNCR_77C22E;
        else *chipID = grNCR_77C22E_PLUS;
        }
    return true;

NoNCR:
    wrinx(SEQ,5,old);
    return false;
}
