/****************************************************************************
*
*                         The Universal VESA VBE
*
*                   Copyright (C) 1993 Kendall Bennett.
*                           All rights reserved.
*
* Filename:     $RCSfile: _everex.c $
* Version:      $Revision: 1.1 $
*
* Language:     ANSI C
* Environment:  IBM PC (MS DOS)
*
* Description:  C language support routines for Everex SuperVGA's. Contains
*               detection code, mode translation tables and chipset
*               names.
*
* $Id: _everex.c 1.1 1993/09/19 01:26:26 kjb release $
*
* Revision History:
* -----------------
*
* $Log: _everex.c $
* Revision 1.1  1993/09/19  01:26:26  kjb
* Initial revision
*
****************************************************************************/

/* Mode translation table to determine the values to place into
 * AX and BX in order to initialise a particular video mode
 * via int 10h.
 */

short EVEREXModes[] = { 0x70, 0x02,     /* 800x600 16 color     */
                        0x70, 0x20,     /* 1024x768 16 color    */
                        0x70, 0x21,     /* 1280x1024 16 color   */
                        0x70, 0x13,     /* 640x350 256 color    */
                        0x70, 0x14,     /* 640x400 256 color    */
                        0x70, 0x30,     /* 640x480 256 color    */
                        0x70, 0x31,     /* 800x600 256 color    */
                        0x70, 0x32,     /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0x70, 0x62,     /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0x70, 0x71,     /* 640x480 32k color    */
                        0, 0,           /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0, 0,           /* 640x480 64k color    */
                        0, 0,           /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0x70, 0x77,     /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

typedef enum {
    grEVEREX_EvNR,          /* Everex normal chipset                    */
    grEVEREX_Ev236,         /* Everex Ev236 chipset (Trident)           */
    grEVEREX_Ev620,         /* Everex Ev620 chipset (Trident)           */
    grEVEREX_Ev629,         /* Everex Ev629 chipset (ET4000)            */
    grEVEREX_Ev673,         /* Everex Ev673 chipset (Trident)           */
    grEVEREX_Ev678,         /* Everex Ev678 chipset (Trident)           */
    } EVEREX_chipsets;

/* Names of chip revision id's. */

char *EverexNames[] = {
    "EvNR",
    "Ev236 (Trident)",
    "Ev620 (Trident)",
    "Ev629 (ET4000)",
    "Ev673 (Trident)",
    "Ev678 (Trident)",
    };

bool findEverex(int *superVGA,int *chipID,int *memory,int *dac,int *pageFlip)
/****************************************************************************
*
* Function:     findEverex
* Parameters:   superVGA    - ID of the SuperVGA card
*               chipID      - Internal chip ID number
*               memory      - Amount of memory of card
*               dac         - Type of DAC installed
*               pageFlip    - True if page flipping supported
* Returns:      True if card was detected
*
* Description:  Detects the presence of Everex based SuperVGA's.
*
****************************************************************************/
{
    union REGS  regs;

    regs.x.ax = 0x7000;
    regs.x.bx = 0x0000;
    int86(0x10,&regs,&regs);
    if (regs.h.al != 0x70)
        goto NoEverex;

    /* We have an Everex SuperVGA */

    *superVGA = grSVGA_EVEREX;
    *pageFlip = true;

    switch (regs.x.dx >> 4) {
        case 0x236:
            *chipID = grEVEREX_Ev236;
            break;
        case 0x620:
            *chipID = grEVEREX_Ev620;
            break;
        case 0x629:
            *chipID = grEVEREX_Ev629;
            break;
        case 0x673:
            *chipID = grEVEREX_Ev673;
            break;
        case 0x678:
            *chipID = grEVEREX_Ev678;
            break;
        default:
            *chipID = grEVEREX_EvNR;
            *pageFlip = false;
        }

    regs.h.ch >>= 6;
    if (regs.h.ch == 0)
        *memory = 256;
    else if (regs.h.ch == 1)
        *memory = 512;
    else *memory = 1024;

    return true;

NoEverex:
    return false;
}
