/****************************************************************************
*
*                         The Universal VESA VBE
*
*                   Copyright (C) 1993 Kendall Bennett.
*                           All rights reserved.
*
* Filename:     $RCSfile: _avance.c $
* Version:      $Revision: 1.2 $
*
* Language:     ANSI C
* Environment:  IBM PC (MS DOS)
*
* Description:  C language support routines for Avance Logic SuperVGA's.
*               Contains detection code, mode translation tables and
*               chipset names.
*
* $Id: _avance.c 1.2 1993/09/24 05:22:02 kjb release $
*
* Revision History:
* -----------------
*
* $Log: _avance.c $
* Revision 1.2  1993/09/24  05:22:02  kjb
* Fixed a number of bugs.
*
* Revision 1.1  1993/09/19  01:26:00  kjb
* Initial revision
*
****************************************************************************/

/* Mode translation table to determine the values to place into
 * AX and BX in order to initialise a particular video mode
 * via int 10h.
 */

short AVANCEModes[] = { 0x2B, 0,        /* 800x600 16 color     */
                        0x30, 0,        /* 1024x768 16 color    */
                        0x36, 0,        /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0x29, 0,        /* 640x400 256 color    */
                        0x2A, 0,        /* 640x480 256 color    */
                        0x2C, 0,        /* 800x600 256 color    */
                        0x31, 0,        /* 1024x768 256 color   */
                        0x37, 0,        /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0, 0,           /* 640x480 32k color    */
                        0, 0,           /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0x40, 0,        /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0x42, 0,        /* 640x400 64k color    */
                        0x43, 0,        /* 640x480 64k color    */
                        0x44, 0,        /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

typedef enum {
    grAVANCE_AL2101,        /* Avance Logic AL2101 chipset              */
    } Avance_chipsets;

/* Names of chip revision id's. */

char *AvanceNames[] = {
    "AL2101",
    };

bool findAvance(int *superVGA,int *chipID,int *memory,int *dac,int *pageFlip)
/****************************************************************************
*
* Function:     findAvance
* Parameters:   superVGA    - ID of the SuperVGA card
*               chipID      - Internal chip ID number
*               memory      - Amount of memory of card
*               dac         - Type of DAC installed
*               pageFlip    - True if page flipping supported
* Returns:      True if card was detected
*
* Description:  Detects the presence of Avance Logic based SuperVGA's.
*
****************************************************************************/
{
    if (!tstreg(0x8286,0xFF))       /* Test for pixel start low reg     */
        goto NoAvance;
    if (!tstinx(CRTC,0x1F,0x3B))    /* Check for emulation register     */
        goto NoAvance;
    if (!tstinx(GRC,0xD,0xF))       /* Check for fill color register    */
        goto NoAvance;

    /* We have an Avance Logic SuperVGA */

    *superVGA = grSVGA_AVANCE;
	*pageFlip = true;
    *dac = grHC2DAC;
    *chipID = grAVANCE_AL2101;

    switch (rdinx(CRTC,0x1E) & 3) {
        case 0: *memory = 256;  break;
        case 1: *memory = 512;  break;
        case 2: *memory = 1024; break;
        case 3: *memory = 2048; break;
        }

    return true;

NoAvance:
    return false;
}
