/****************************************************************************
*
*                         The Universal VESA VBE
*
*                   Copyright (C) 1993 Kendall Bennett.
*                           All rights reserved.
*
* Filename:     $RCSfile: univbe.h $
* Version:      $Revision: 1.1 $
*
* Language:     ANSI C
* Environment:  IBM PC (MS DOS)
*
* Description:  Header file for the entire program. This defines the
*               structures used by the VESA VBE specs, and the function
*               prototypes for the routines used in the program.
*
* $Id: univbe.h 1.1 1993/09/19 01:26:00 kjb release $
*
* Revision History:
* -----------------
*
* $Log: univbe.h $
* Revision 1.1  1993/09/19  01:26:00  kjb
* Initial revision
*
****************************************************************************/

#ifndef __UNIVBE_H
#define __UNIVBE_H

#ifndef __DEBUG_H
#include "debug.h"
#endif

#ifndef __CHIPSETS_H
#include "chipsets.h"
#endif

#ifndef __VESAVBE_H
#include "vesavbe.h"
#endif

/*-------------------------- Function Prototypes --------------------------*/

#define INIFILE_NAME    "univbe.ini"
#define REMOVE          "[remove]"

extern short removedModes[];

/* Routines for obtaining symbolic names */

char *getSuperVGAName(int SuperVGA);
char *getDACName(int dac);
char *getChipsetName(int SuperVGA,int chipset);

/* Routine to auto detect the installed video board */

void detect(int *SuperVGA,int *chipID,int *memory,int *dac,int *pageFlip,
    int *VESAcompliant);

/* Routines for doing simplified I/O port maniuplation */

int rdinx(int port,int index);
void wrinx(int port,int index,int value);
void modinx(int port,int index,int mask,int value);
bool tstreg(int port,int mask);
bool tstinx(int port,int index,int mask);

/* Routines to manage the TSR side of things */

bool isLoaded(void);
bool unload(void);
bool install(int superVGA,int chipID,int memory,int dac,bool pageFlip,
    bool VESACompliant);
bool goTSR(void);
void copyModeInfo(void *IndexTable,int size);
void copyValidModes(void *validModes,int size);

#endif  /* __UNIVBE_H */
