%{

 (* Lexical analyzer for the NFF scene description format. 
    Adapted from tokens.l as included in the MTV-raytracer by M. VandeWettering
 *)

  
 function yywrap : boolean;
 begin
   yywrap := true; (* main program closes files *)
 end;


%}

D                   [0-9]

%%
  var
    result : integer;

  (* white space and stuff *)

[ \t\n]			;
\#.*$			;

  (* keywords with aliases *)

v			|
viewpoint		return(VIEWPOINT);

from			return(FROM) ;

at			return(AT);

up			return(UP);

angle			return(ANGLE);

aspect			return(ASPECT);

resolution		return(RESOLUTION);

l			|
light                   return(LIGHT);

b			|
background		return(BACKGROUND);

f			|
surface			return(SURFACE);

s			|
sphere			return(SPHERE);

p                       |
plane                   return(PLANE);

q                       |
quadric                 return(QUADRIC);

{                       return(BEGIN_BLOCK);
}                       return(END_BLOCK);

 (* numbers *)
\-?{D}+(\.{D}+)?([Ee][+-]?{D}+)?    begin
                                    val(yytext,yylval.yyflt,result);
                                    if result=0 then
                                       return(NUM)
				    else
 				       return(NUM);
	                          end;
  
 (* tokens *)
[A-Za-z0-9_]+		return(TOKEN);

.                       returnc(yytext[0]);

%%

