#declare Green_Phong = texture {
	pigment { color rgb <0.0,0.5,0.5> }
	normal { ripples 0.5 scale 0.1 }
	finish { phong 1.0 phong_size 5.0 }
}

#declare xmin  = 0
#declare xmax  = 2*pi
#declare ymin  = 0  
#declare ymax  = 2*pi
#declare xiter = 9
#declare yiter = 51
#declare ix    = (xmax-xmin)/(xiter-1.0)
#declare iy    = (ymax-ymin)/(yiter-1.0)
#declare deltax = (xmax-xmin)/((xiter-1.0)*4.0) 
#declare deltay = (ymax-ymin)/((yiter-1.0)*4.0) 
#declare bretzel = mesh {
  #declare xx = xmin    
  #while (xx<xmax)                        //outer loop
    #declare yy = ymin
    #while (yy<ymax)                      //inner loop
//POINTS
    #declare zn=-(4+1.5*cos(xx)+4*cos(yy*0.5)*cos(yy*0.5))*cos(2*yy)
    #declare xn=(4+1.5*cos(xx)+4*cos(yy*0.5)*cos(yy*0.5))*sin(2*yy)
    #declare yn=1.5*sin(xx)+4*sin(yy)
    #declare xx=xx+deltax
    #declare zp=-(4+1.5*cos(xx)+4*cos(yy*0.5)*cos(yy*0.5))*cos(2*yy)
    #declare xp=(4+1.5*cos(xx)+4*cos(yy*0.5)*cos(yy*0.5))*sin(2*yy)
    #declare yp=1.5*sin(xx)+4*sin(yy)
    #declare xx=xx-deltax
    #declare yy=yy+deltay
    #declare zq=-(4+1.5*cos(xx)+4*cos(yy*0.5)*cos(yy*0.5))*cos(2*yy)
    #declare xq=(4+1.5*cos(xx)+4*cos(yy*0.5)*cos(yy*0.5))*sin(2*yy)
    #declare yq=1.5*sin(xx)+4*sin(yy)
    #declare yy=yy-deltay
    #declare vn=vcross(<xp-xn,yp-yn,zp-zn>,<xq-xn,yq-yn,zq-zn>)
    #declare n1=vnormalize(vn)
    #declare p1=<xn,yn,zn>


    #declare yy=yy+iy
    #declare zn=-(4+1.5*cos(xx)+4*cos(yy*0.5)*cos(yy*0.5))*cos(2*yy)
    #declare xn=(4+1.5*cos(xx)+4*cos(yy*0.5)*cos(yy*0.5))*sin(2*yy)
    #declare yn=1.5*sin(xx)+4*sin(yy)
    #declare xx=xx+deltax
    #declare zp=-(4+1.5*cos(xx)+4*cos(yy*0.5)*cos(yy*0.5))*cos(2*yy)
    #declare xp=(4+1.5*cos(xx)+4*cos(yy*0.5)*cos(yy*0.5))*sin(2*yy)
    #declare yp=1.5*sin(xx)+4*sin(yy)
    #declare xx=xx-deltax
    #declare yy=yy+deltay
    #declare zq=-(4+1.5*cos(xx)+4*cos(yy*0.5)*cos(yy*0.5))*cos(2*yy)
    #declare xq=(4+1.5*cos(xx)+4*cos(yy*0.5)*cos(yy*0.5))*sin(2*yy)
    #declare yq=1.5*sin(xx)+4*sin(yy)
    #declare yy=yy-deltay
    #declare vn=vcross(<xp-xn,yp-yn,zp-zn>,<xq-xn,yq-yn,zq-zn>)
    #declare n2=vnormalize(vn)
    #declare p2=<xn,yn,zn>
    
    #declare xx=xx+ix
    #declare zn=-(4+1.5*cos(xx)+4*cos(yy*0.5)*cos(yy*0.5))*cos(2*yy)
    #declare xn=(4+1.5*cos(xx)+4*cos(yy*0.5)*cos(yy*0.5))*sin(2*yy)
    #declare yn=1.5*sin(xx)+4*sin(yy)
    #declare xx=xx+deltax
    #declare zp=-(4+1.5*cos(xx)+4*cos(yy*0.5)*cos(yy*0.5))*cos(2*yy)
    #declare xp=(4+1.5*cos(xx)+4*cos(yy*0.5)*cos(yy*0.5))*sin(2*yy)
    #declare yp=1.5*sin(xx)+4*sin(yy)
    #declare xx=xx-deltax
    #declare yy=yy+deltay
    #declare zq=-(4+1.5*cos(xx)+4*cos(yy*0.5)*cos(yy*0.5))*cos(2*yy)
    #declare xq=(4+1.5*cos(xx)+4*cos(yy*0.5)*cos(yy*0.5))*sin(2*yy)
    #declare yq=1.5*sin(xx)+4*sin(yy)
    #declare yy=yy-deltay
    #declare vn=vcross(<xp-xn,yp-yn,zp-zn>,<xq-xn,yq-yn,zq-zn>)
    #declare n3=vnormalize(vn)
    #declare p3=<xn,yn,zn>
    
    #declare yy=yy-iy
    #declare zn=-(4+1.5*cos(xx)+4*cos(yy*0.5)*cos(yy*0.5))*cos(2*yy)
    #declare xn=(4+1.5*cos(xx)+4*cos(yy*0.5)*cos(yy*0.5))*sin(2*yy)
    #declare yn=1.5*sin(xx)+4*sin(yy)
    #declare xx=xx+deltax
    #declare zp=-(4+1.5*cos(xx)+4*cos(yy*0.5)*cos(yy*0.5))*cos(2*yy)
    #declare xp=(4+1.5*cos(xx)+4*cos(yy*0.5)*cos(yy*0.5))*sin(2*yy)
    #declare yp=1.5*sin(xx)+4*sin(yy)
    #declare xx=xx-deltax
    #declare yy=yy+deltay
    #declare zq=-(4+1.5*cos(xx)+4*cos(yy*0.5)*cos(yy*0.5))*cos(2*yy)
    #declare xq=(4+1.5*cos(xx)+4*cos(yy*0.5)*cos(yy*0.5))*sin(2*yy)
    #declare yq=1.5*sin(xx)+4*sin(yy)
    #declare yy=yy-deltay
    #declare vn=vcross(<xp-xn,yp-yn,zp-zn>,<xq-xn,yq-yn,zq-zn>)
    #declare n4=vnormalize(vn)
    #declare p4=<xn,yn,zn>
    
    #declare xx=xx-ix
#if(!(p1.x=p2.x&p1.y=p2.y&p1.z=p2.z)|(p2.x=p3.x&p2.y=p3.y&p2.z=p3.z)|(p1.x=p3.x&p1.y=p3.y&p1.z=p3.z))
        smooth_triangle {
          p1,n1,
          p2,n2,
          p3,n3
         }
          
#end
#if(!(p1.x=p3.x&p1.y=p3.y&p1.z=p3.z)|(p3.x=p4.x&p3.y=p4.y&p3.z=p4.z)|(p1.x=p4.x&p1.y=p4.y&p1.z=p4.z))
        smooth_triangle{
          p1,n1,  
          p3,n3,   
          p4,n4 
         }
#end

      #declare yy = yy+iy
   #end                 //inner loop
   #declare xx = xx+ix
 #end                   //outer loop
 scale 1/10
}

object {
 bretzel
 no_shadow
 texture { Green_Phong }
 }

//Lights, camera, action
camera
{ location  < 1, 1.25, -1>
  direction  1*z
  look_at   < 0, 0, 0>
} 

light_source { < 0, 1.25, -1> color rgb 1 }
light_source { < 1, 1.25, -1> color rgb 1 }

object { box{-2,2 inverse} pigment{color rgb 0.8} }
