.*==============================================================*\
.*                                                              *
.* HELP.IPF - Information Tag Language file for the Help menu   *
.*              help panels.                                    *
.*                                                              *
.*==============================================================*/
:userdoc.

.*--------------------------------------------------------------*\
.*  Main window extended help panel                             *
.*      res = PANEL_MAIN                                        *
.*--------------------------------------------------------------*/
:h1 res=2100 name=PANEL_MAIN.About UChess
:i1 id=aboutMain.About UChess
:p.  UChess is a Pentium optimized OS/2 32 bit Chess Program by Roger Uzun 
(uzun@crash.cts.com).  UChess is based on gnuchess 4PL73 with several enhancements 
designed to strengthen its play.  Both UChess and its source are freely distributable,
in accordance to the gnu license.
:p. To move your pieces simply use the mouse or type in your moves in
either shortened algabraic notation (Nf3) or long form (g1f3) followed by
the enter key.  In the Time control menu, you can turn off Deep thinking
to disallow the computer to think about its next move during your turn.
The machine will play a stronger game if you allow it to think during
your move.
:p.Startup options : If the pgm seems to swap too much on your system you
can use the following arguments:
:p.
:p.UChess mini <small tables>
:p.UChess micro <smaller tables>
:p.UChess Max <very large tables>

:p.The larger the tables, the stronger the play
.*--------------------------------------------------------------*\
.*  Main Help menu                                              *
.*      res = PANEL_HELP                                        *
.*--------------------------------------------------------------*/
:h1 res=2910 name=PANEL_HELP.Help Menu
:i1 id=Help.Help Menu
:p.Use the choices on the Help pull-down to display:
:dl tsize=5 break=all.
:dt.:hp2.Help index:ehp2.
:dd.Displays the index of help menu.
:dt.:hp2.General Help:ehp2.
:dd.Displays some information about using UChess.
:dt.:hp2.Using Help:ehp2.
:dd.Provides detailed information on the kinds of help available and how to
use help.
:edl.

.*--------------------------------------------------------------*\
.*  Help menu item Help for help... help panel                  *
.*      res = PANEL_HELPHELPFORHELP                             *
.*--------------------------------------------------------------*/
:h1 res=2920 name=PANEL_HELPHELPFORHELP.Using Help
:dl tsize=5 break=all.
:i2 refid=Help.Using Help
:p.Use this choice to obtain information on how to
use the Help facility.

:edl

.*--------------------------------------------------------------*\
.*  Help menu item Extended help... help panel                  *
.*      res = PANEL_HELPEXTENDED                                *
.*--------------------------------------------------------------*/
:h1 res=2930 name=PANEL_HELPEXTENDED.General Help
:dl tsize=5 break=all.
:i2 refid=Help.General Help
:p. To move your pieces simply use the mouse or type in your moves in
either shortened algabraic notation (Nf3) or long form (g1f3) followed by
the enter key.  You can type "beep" followed by the enter key to toggle
the beep sound.  In the Time control menu, you can turn off Deep thinking
to disallow the computer to think about its next move during your turn.
The machine will play a stronger game if you allow it to think during
your move.

:edl

.*--------------------------------------------------------------*\
.*  Help menu item Help index... help panel                     *
.*      res = PANEL_HELPINDEX                                   *
.*--------------------------------------------------------------*/
:dl tsize=5 break=all.
:edl.
:h1 res=2950 name=PANEL_HELPINDEX.Index
:i2 refid=Help.Help Index
:p.Use this choice to display the help index.
:p.The help index lists the titles of the help information that is available.

.*--------------------------------------------------------------*\
.*  Help menu item Product... help panel                        *
.*      res = PANEL_HELPPRODUCTINFO                             *
.*--------------------------------------------------------------*/
:h1 res=2960 name=PANEL_HELPPRODUCTINFO.Product Information
:i2 refid=Help.Product Information
:p.This dialog displays information about UChess such as version
number and authors name.

.*--------------------------------------------------------------*\
.*  Help menu item Start... help panel                          *
.*      res = PANEL_HELPSKILLMENU                                   *
.*--------------------------------------------------------------*/
:h1 res=2981 name=PANEL_SKILLMENU.Skill Levels
:i2 refid=HELP.Skill Level Information
:p.Here you can choose to start the game with a material advantage.

.*--------------------------------------------------------------*\
.*  Help menu item Stop... help panel                           *
.*      res = PANEL_HELPTIMEMENU                                    *
.*--------------------------------------------------------------*/
:h1 res=2982 name=PANEL_TIMEMENU.Time Controls
:i2 refid=HELP.Time Control Information
:p.This Menu Selection allows you to set the chess clocks and various strength parameters.
You can choose to play a timed game, each side required to play <n> moves in <m> minutes,
or you can choose to have the computer search each of its moves to a fixed ply or depth.
The computer plays stronger if given more time, and/or deeper search depths.  This dialog
also allows you to choose deep thinking (on/off).  Deep thinking on means that the computer
will ponder its next move while it is your turn, turning it off means the computer will remain
inactive during your move.  The computer plays stronger with deep thinking on.  You can also
choose to allow the computer to use its opening book or not.  The opening book allows the
computer to start with some of its favorite moves, without having to waste its time thinking
about the opening portion of the game.

:h1 res=2983 name=PANEL_PLAYERMENU.Players
:i2 refid=HELP.Player Select Information
:p.This menu item allows you to choose who will play the game.  You can choose to play
white, with the computer playing as black.  Or you can play as black with the computer
playing as white.  Or you can choose to have the computer play against itself.  In order
to halt autoplay mode, simply click on the board with the left mouse button, or press
any key when the boards window is active. Note if it is the computers turn next,
it will immediately begin considering its next move, when it gets out of autoplay mode.
In addition you can choose to have the computer simply act as a referee, and play against 
another human opponent, the computer playing neither side.

:h1 res=2984 name=PANEL_HINT.Hint
:i2 refid=HELP.Ask Computer for a Hint
:p.This menu item allows you to ask the computer what it believes is a reasonable
choice for your next move.  The choice will appear on the upper right hand box.

:h1 res=2985 name=PANEL_MOVENOW.Move Now
:i2 refid=HELP.Force the Computer to Move
:p.This menu item allows you to force the computer to make his next move immediately
and cease thinking.  On slower machines or while examining complex positions, the 
computer may take a while to respond.

:h1 res=2986 name=PANEL_UNDO.Undo Last ply
:i2 refid=HELP.Undo Last half move
:p.This menu item allows you to take back the last ply, or 1/2 move.  This implicitly
swaps sides, so to take back a full move, and retain your color, choose this option
twice.

:h1 res=2987 name=PANEL_EDIT.Edit Board
:i2 refid=HELP.Edit the Board
:p.This menu item places you in edit mode, allowing you to place/remove any
pieces on the board.  You must have 1 black and 1 white king in any setup.
To exit edit mode, press the 'x' key.  To clear the board of all pieces, use the
<tab> key.  To place the pieces on the board, use the mouse and the left mouse
button.  To choose which piece you want, simply type in the chess letter of that
piece, lower case for White, upper case for Black.  Type <space> to choose "no piece"
e.g. to remove pieces from the board.   The chesspiece letters are p,n,b,r,q,k for Pawn
Knight, Bishop, Rook, Queen, King.

:h1 res=2988 name=PANEL_CALC.Calc nominal Pgm rating
:i2 refid=HELP.Calc this machines chess rating
:p.This menu item will destroy any current game in process.  What it does is
to measure the time it takes for UChess to calculate the first move, as white,
to a depth of 6 ply.  This gives you a rough idea of how fast your machine
is, and how strong its chess rating may be.  A Pentium 90 machine takes about
2.75 seconds to calculate this move.

:h1 res=2989 name=PANEL_TEST.Test CPU Speed
:i2 refid=HELP.Test CPU speed
:p.This menu item will not destroy the current game.  It measures the nodes/sec
that the host computer can calculate for various aspects of the chess engine.
The number is highly dependent upon the current board configuration, how
many pieces are on the board, how many ways to check the king there are, etc
etc.

:h1 res=2990 name=PANEL_BEEP.Toggle Beep
:i2 refid=HELP.Toggle the Beep sound
:p.This menu item will turn on/off the beep sound when the computer
completes a move.  The new beep state can be seen in the message
window on the lower right screen corner.

:h1 res=2991 name=PANEL_VERBOSE.Toggle Verbose
:i2 refid=HELP.Toggle Verbose Mode
:p.This menu item will toggle "Verbose" mode, which causes the computers
thought process to appear on the lower right hand corner of the screen,
in the message window.

:h1 res=3900 name=PANEL_PROBLEMS.Problems with UChess
:i2 refid=HELP.Problems
:p.If you are having troubles with UChess's performance on your machine,
it may be because if excessive swapping.  You can force UChess to use less
memory on startup by passing the following arguments into the program:
:p.UChess micro : This forces a very small memory model (default for <8M machines)
:p.UChess mini : This forces a small memory model (default for 8M machines)
:p.UChess MAX : This allows UChess to use oversized tables for computers with a lot
of free RAM.

:euserdoc.
