#ifndef SYS_BOBS_INCL

//*************************************************************
// Raster Object Primitives, for OS/2 PM
// CopyRight (c) 1994 W. Roger Uzun
// Avatar Consulting 
//*************************************************************


#define SYS_BOBS_INCL

#define INCL_DOS
#define INCL_WIN
#define INCL_GPI
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>

struct BOBSTRUCT {
LONG XPos,YPos; // where do I go next frame?
LONG OldX,OldY; // Where was I last time I was drawn on the screen?
LONG Width,Height,Depth; // Image dimensions
LONG Flags; // for future options, who  knows
struct BOBSTRUCT *Next;  // next BOB in the list of Graphics Element Objects (GELS)
HBITMAP Image;  // image data in bitmap format
HBITMAP SaveBuffer; // area to save background to
HBITMAP ShadowMask;
UCHAR *ShadowImage;
PBITMAPINFO2 bmi2; // bitmap info filled in by creation, semi priv
		  // OS/2 specific information
PBITMAPINFO2 sbmi2; // bitmap info for shadow masks
};

typedef unsigned char UBYTE;
typedef struct BOBSTRUCT BOB;

extern HPS hwClientPS; // we need to keep a PS around for the target
extern BOB *SystemBobList;
extern HPS hwCLientPS; // we need to keep a PS around for the target
extern HMTX DrawSemaphore; // have WM_PAINT and Gels go 1 at a time

int LoadBMPImage(char *,void *,ULONG,ULONG);
int InitGels(void);
int CloseGels(void);
void RepaintBobs(HPS); // for WM_Paint situations
BOB *CreateBob(LONG Width,LONG Height,LONG Depth,void *Image,UCHAR *);
int FreeBob(BOB *);
void DrawGList(void);
void AddBob(BOB *);
void RemBob(BOB *);
void RemBobNR(BOB *);
void EraseBob(BOB *);
int LoadFullBitmap(HPS,char *,int,UCHAR *);
void FreeFullBitmap(void);

#endif // SYS_BOBS_INCL

