/***************************************

  Functions for handling serials  

  Status: NOT REVUED, NOT TESTED

 Author(s):       Andrei Robachevsky

  ******************/ /******************
  Modification History:
        andrei (08/02/2000) Created.
  ******************/ /******************
  Copyright (c) 2000                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 ***************************************/
#include "ud.h"
#include "ud_int.h"
#include "ud_tr.h"

/************************************************************
* int UD_lock/unlock_serial()                               *
*                                                           *
* Performs lockind/unlocking of the relevant tables         *
*                                                           *
* Returns:                                                  *
* 0 - success                                               *
* Non-zero if error occured (XXX dies now)                  *
*                                                           *
************************************************************/
int UD_lock_serial(Transaction_t *tr)
{
int sql_err;

/* lock all tables we are going to update and commit */	
/* this also includes transaction_rec table, as we update the status */
   sql_err=SQ_execute_query(tr->sql_connection, "LOCK TABLES serials WRITE, failed_transaction WRITE, transaction_rec WRITE ", NULL);
   if (sql_err) { 
	ER_perror(FAC_UD, UD_SQL, "%s[%s]\n", SQ_error(tr->sql_connection), "LOCK TABLES serials WRITE, failed_transaction WRITE, transaction_rec WRITE ");
        die;
    }
 return(sql_err);
}

int UD_unlock_serial(Transaction_t *tr)
{
int sql_err;
	
   sql_err=SQ_execute_query(tr->sql_connection, "UNLOCK TABLES ", NULL);
   if (sql_err) { 
	ER_perror(FAC_UD, UD_SQL, "%s[%s]\n", SQ_error(tr->sql_connection), "UNLOCK TABLES");
        die;
    }
 return(sql_err);
}


/************************************************************
* UD_create_serial()                                        *     
*                                                           *
* Creates a serial record for given transaction             *
* For updates creates 2 serial records (DEL+ADD)            *
*                                                           *
* Important fields of transaction are:                      *
* tr->action        TR_CREATE/TR_UPDATE/TR_DELETE           *
* tr->object_id     should be filled in                     *
* tr->sequence_id   should be set to object updated         *
*                                                           *
* So given object with id=k and seq=n                       *
* Create:  ADD(k,n)                                         *
* Update:  ~S(k,n), ADD(k,n+1)                              *
* Delete:  ~S(k,n), DEL(k,n)                                *
*                                                           *
* Returns:                                                  *
*  currnt serial number.                                    *
*  -1 in case of an error                                   *
*                                                           *
*************************************************************/

long UD_create_serial(Transaction_t *tr)
{
GString *query;
long current_serial=0;
int sql_err;
int operation;
long timestamp;
long sequence_id;
   
   if ((query = g_string_sized_new(STR_XL)) == NULL){ 
      tr->succeeded=0;
      tr->error |= ERROR_U_MEM;
      ER_perror(FAC_UD, UD_MEM, "cannot allocate gstring\n");
      die;
   }
   
   /* Calculate the object_id - should be max+1 */
//   tr->serial_id = get_minmax_id(tr->sql_connection, "serial_id", "serials", 1) +1;
//   TR_update_id(tr);

/* fprintf(stderr, "creating serial\n"); */
  /* if the transaction failed store it in transaction table */
  if(tr->succeeded==0){
    if(ACT_DELETE(tr->action))operation=OP_DEL; else operation=OP_ADD;
    
    g_string_sprintf(query, "INSERT serials SET "
                   "thread_id=%d, object_id=%ld, sequence_id=0, "
		   "atlast=2, "
		   "operation=%d ", tr->thread_ins, tr->object_id, operation);
    
    sql_err = SQ_execute_query(tr->sql_connection, query->str, (SQ_result_set_t **)NULL);

    if (sql_err) { 
	ER_perror(FAC_UD, UD_SQL, "%s[%s]\n", SQ_error(tr->sql_connection), query->str);
	die;
        current_serial=-1;
    }
    else {
       current_serial=mysql_insert_id(tr->sql_connection);
       timestamp=time(NULL);
//       if(tr->serial_id!=current_serial) die; /* may be the implementation changed */
       g_string_sprintf(query, "INSERT failed_transaction SET "
                   "thread_id=%d, serial_id=%ld, timestamp=%ld, "
		   "object='%s' ", tr->thread_ins, current_serial, timestamp, tr->object->object->str);
       /* make a record in transaction table */
       sql_err = SQ_execute_query(tr->sql_connection, query->str, (SQ_result_set_t **)NULL);
       if (sql_err) { 
	 ER_perror(FAC_UD, UD_SQL, "%s[%s]\n", SQ_error(tr->sql_connection), query->str);
	 die;
         current_serial=-1;
       }
    }
    g_string_free(query, TRUE);   
    return(current_serial);
  }  


  /* if the transaction has succeeded */
  sequence_id=tr->sequence_id;
  /* If this is an update or delete */    
  if(!ACT_CREATE(tr->action)) { 
    /* Increase the sequence_id so we insert correct ADD serial in case of Update */
    sequence_id=tr->sequence_id + 1;
    /* set the atlast field of the latest record for this object to 0 */
    /* because it is moved to history */
    g_string_sprintf(query, "UPDATE serials SET atlast=0, thread_id=%d "
                   "WHERE object_id=%ld "
                   "AND sequence_id=%ld ", tr->thread_upd, tr->object_id, sequence_id-1);
    
    sql_err = SQ_execute_query(tr->sql_connection, query->str, (SQ_result_set_t **)NULL);
    if (sql_err) { // we can have empty updates, but not errors
	ER_perror(FAC_UD, UD_SQL, "%s[%s]\n", SQ_error(tr->sql_connection), query->str);
	die;
        current_serial=-1;
    }
  }  
  /* XXX below is a code for protocol v2, when updates are atomic */
  /* XXX this is fine (and should always be used) for NRTM, since we */
  /* XXX store failed transactions and playback stream exactly as it comes */
  /* XXX However, for update this may be configurable option */
  /* XXX In case v1 protocol both sections (DEL + ADD) should be executed */
  /* if this a DEL */ 
  if(ACT_DELETE(tr->action)) {   
    /* generate DEL serial */
    g_string_sprintf(query, "INSERT serials SET "
                   "thread_id=%d, object_id=%ld, "
                   "sequence_id=%ld, "
                   "atlast=0, "
                   "operation=%d ", tr->thread_ins, tr->object_id, sequence_id-1, OP_DEL);
    
    sql_err = SQ_execute_query(tr->sql_connection, query->str, (SQ_result_set_t **)NULL);
    if (sql_err) {
	ER_perror(FAC_UD, UD_SQL, "%s[%s]\n", SQ_error(tr->sql_connection), query->str);
	die;
        current_serial=-1;
    }    
    
    if(current_serial!=-1)current_serial=mysql_insert_id(tr->sql_connection);
    
  }
  else { /* otherwise this is an ADD */

   /* now insert creation serial */
   g_string_sprintf(query, "INSERT serials SET "
                  "thread_id=%d, object_id=%ld, "
                  "sequence_id=%ld, "
                  "atlast=1, "
                  "operation=%d ", tr->thread_ins, tr->object_id, sequence_id, OP_ADD);
    
   sql_err = SQ_execute_query(tr->sql_connection, query->str, (SQ_result_set_t **)NULL);
   if (sql_err) {
	ER_perror(FAC_UD, UD_SQL, "%s[%s]\n", SQ_error(tr->sql_connection), query->str);
	die;
        current_serial=-1;
   }    
    
   if(current_serial!=-1){ 
	   current_serial=mysql_insert_id(tr->sql_connection);
//	   if(tr->serial_id!=current_serial) die; /* may be the implementation changed */
   }

  }
  g_string_free(query, TRUE);        
return(current_serial);
}
/************************************************************
* UD_comrol_serial()                                        *     
*                                                           *
* Commits/Rollbacks a serial record for given transaction   *
* Returns:                                                  *
* 0 in success                                              *
*  -1 in case of an error                                   *
*                                                           *
*************************************************************/

char *Q_rollback_serial1="DELETE FROM serials WHERE thread_id=%ld ";
char *Q_rollback_serial2="UPDATE serials SET atlast=1, thread_id=0 WHERE thread_id=%ld ";
char *Q_rollback_transaction="DELETE FROM failed_transaction WHERE thread_id=%ld ";
char *Q_commit_serial="UPDATE serials SET thread_id=0 WHERE thread_id=%ld OR thread_id=%ld ";
char *Q_commit_transaction="UPDATE failed_transaction SET thread_id=0 WHERE thread_id=%ld ";



int UD_comrol_serial(Transaction_t *tr, int commit)
{
GString *query;
int sql_err;
char *Q_transaction;

   /* check if something is left in serials from the crash */
   
   if ((query = g_string_sized_new(STR_XL)) == NULL){ 
      ER_perror(FAC_UD, UD_MEM, "cannot allocate gstring\n"); 
      tr->succeeded=0;
      tr->error |= ERROR_U_MEM;
      return(ERROR_U_MEM); 
   }
   
   /* compose the appropriate query depending on operation (commit/rollback) */
   if(commit) {
	   /* commit changes to serials table */
	   g_string_sprintf(query, Q_commit_serial, tr->thread_ins, tr->thread_upd);
	   sql_err = SQ_execute_query(tr->sql_connection, query->str, (SQ_result_set_t **)NULL);
           if (sql_err) {
	     ER_perror(FAC_UD, UD_SQL, "%s[%s]\n", SQ_error(tr->sql_connection), query->str);
             die;
           }
	   Q_transaction=Q_commit_transaction;
   } else {
	   /* delete new insertions */
	   g_string_sprintf(query, Q_rollback_serial1, tr->thread_ins);
	   sql_err = SQ_execute_query(tr->sql_connection, query->str, (SQ_result_set_t **)NULL);
           if (sql_err) {
	     ER_perror(FAC_UD, UD_SQL, "%s[%s]\n", SQ_error(tr->sql_connection), query->str);
             die;
           }
	   /* restore modified atlast */ 
           g_string_sprintf(query, Q_rollback_serial2, tr->thread_upd);
	   sql_err = SQ_execute_query(tr->sql_connection, query->str, (SQ_result_set_t **)NULL);
           if (sql_err) {
	     ER_perror(FAC_UD, UD_SQL, "%s[%s]\n", SQ_error(tr->sql_connection), query->str);
             die;
           } 
	   Q_transaction=Q_rollback_transaction;
   }
   
    /* clean up transaction  table */
    g_string_sprintf(query, Q_transaction, tr->thread_ins);
    sql_err = SQ_execute_query(tr->sql_connection, query->str, (SQ_result_set_t **)NULL);
    if (sql_err) {
	ER_perror(FAC_UD, UD_SQL, "%s[%s]\n", SQ_error(tr->sql_connection), query->str);
        die;
    }
 g_string_free(query, TRUE);        
 return(0);
} 
    

