/***************************************

  Protocol mirror module (pw). 

  Status: NOT REVUED, NOT TESTED

  ******************/ /******************
  Filename            : protocol_mirror.c
  Author              : andrei
  OSs Tested          : Solaris
  ******************/ /******************
  Copyright (c) 2000                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/
#include <stdio.h>
#include <glib.h>

#include "protocol_mirror.h"
#include "mysql_driver.h"
#include "constants.h"

//#include "access_control.h"
#include "sk.h"
#include "stubs.h"
#include "ud.h"
#include "ta.h"

#include "ca_configFns.h"
#include "ca_dictSyms.h"
#include "ca_macros.h"
#include "ca_srcAttribs.h"

#include "erroutines.h"

#define MIN_ARG_LENGTH  6
#define NRTM_DELIM "-:"
/*
* parses input and fills nrtm_q_t structure
*
* Returns:
*  -1 in case of garbage
*  0  in case of valid -g
*  1  in case of -q sources
*
*/
static int parse_request(char *input, nrtm_q_t *nrtm_q)
{
 char *ptr=input;
 char *token;
 char **tokens;
 char **tokens2;
 int res=0;
 
// return(-1);
 
 if(strlen(input)<MIN_ARG_LENGTH) return(-1);
 g_strchug(input);
 res=strncmp(input, "-g", 2);
 if(res!=0) {
	 /* may be this is -q source query */
	 res=strncmp(input, "-q", 2);
	 if(res!=0)return(-1);
	 ptr+=2;
	 g_strchug(ptr);
	 res=strncmp(ptr, "sources", 7);
	 if(res!=0)return(-1);
	 ptr+=7;
	 g_strchug(ptr);
	 token=ptr;
	 if ((*token=='\0') || (*token=='\n'))nrtm_q->source=NULL;
	 else {
	   ptr=index(token, ' ');
	   if (ptr) nrtm_q->source=g_strndup(token, (ptr-token));
	   else {
	    ptr=index(token, 13); /* search for ctrl-M - telnet loves this */
	     if (ptr) nrtm_q->source=g_strndup(token, (ptr-token));
	       else {
                  ptr=index(token, '\n');
		   if (ptr) nrtm_q->source=g_strndup(token, (ptr-token));
	            else 
		       nrtm_q->source=g_strdup(token);
	       }
           }
	 }
	 return(1);
 }

 /* this is -q query */
 ptr+=2;
 
 
 g_strchug(ptr);
 g_strdelimit(ptr, NRTM_DELIM, ':');
 tokens=g_strsplit(ptr, ":", 4);
 if(tokens==NULL) return(-1);
 
 if(tokens[0]) {
    /* first token is source name */	 
    nrtm_q->source=g_strdup(tokens[0]);
    if(tokens[1]) {
      /* second token is version number */
      nrtm_q->version=atoi(tokens[1]);
      if(tokens[2]) {
	/* this is first serial */      
        nrtm_q->first=atol(tokens[2]);
	if (nrtm_q->first>0) {
          if(tokens[3]) {
            /* this is last serial */
              nrtm_q->last=atol(tokens[3]);
	      if (nrtm_q->last==0) 
	       if (strncasecmp(tokens[3], "LAST", 4)!=0) res=-1;
          } else res=-1;
	} else res=-1;    
      } else res=-1; 
    } else res=-1;  
 } else res=-1;   
 g_strfreev(tokens);
 
return(res);
}


/* PM_interact() */
/*++++++++++++++++++++++++++++++++++++++
  Interact with the client.

  int sock Socket that client is connected to.

  More:
  +html+ <PRE>
  Authors:
        ottrey
        andrei

  +html+ </PRE><DL COMPACT>
  +html+ <DT>Online References:
  +html+ <DD><UL>
  +html+ </UL></DL>

  ++++++++++++++++++++++++++++++++++++++*/
void PM_interact(int sock) {
  char input[MAX_INPUT_SIZE];
  char buff[STR_L];
  ca_dbSource_t *source_hdl;
  int read_result;
  int parse_result;
  ip_addr_t address;

  char *hostaddress=NULL;
  sk_conn_st condat;
  nrtm_q_t nrtm_q;
  long current_serial;
  long oldest_serial;
  
  char *object;
  int operation;
  
  
  char *db_host;
  int  db_port;
  char *db_name;
  char *db_user;
  char *db_pswd;

  GString *gbuff;
  
  SQ_connection_t *sql_connection;     

  /* make a record for thread accounting */
  TA_add(sock, "nrtm_srv");

  
  /* Get the IP of the client */
  hostaddress = SK_getpeername(sock);
  
  /* initialise the connection structure */
  memset( &condat, 0, sizeof(sk_conn_st));
  /* initialise the nrtm structure */
  memset( &nrtm_q, 0, sizeof(nrtm_q_t));
  /* set the connection data: both rIP and eIP to real IP */
  condat.sock = sock;
  condat.ip = hostaddress;
  SK_getpeerip(sock, &(condat.rIP));
  memcpy( &(condat.eIP), &(condat.rIP), sizeof(ip_addr_t));


  /* Read input */
  read_result = SK_cd_gets(&(condat), input, MAX_INPUT_SIZE);
    
  /* read_result < 0 is an error and connection should be closed */
  if (read_result < 0 ) {
      /* log the fact, rtc was set */
  }

    
  parse_result = parse_request(input, &nrtm_q);

  
  if (parse_result < 0 ) {
      ER_dbg_va(FAC_PM, ASP_PM_ERESP,"[%s] -- Garbage received: %s", hostaddress, input);
      /* log the fact and exit */
      /* Free the hostaddress */
      sprintf(buff, "\n%%ERROR:1: Syntax error\n\n");
      SK_cd_puts(&condat, buff);
      SK_cd_close(&(condat));
      free(hostaddress);
      free(nrtm_q.source);
      return;
  }
  
  ER_dbg_va(FAC_PM, ASP_PM_INPUT,"[%s] -- input: [%s]", hostaddress, input); 
    
  if (parse_result == 1 ) {
	  
     gbuff=PM_get_nrtm_sources(&(condat.rIP), nrtm_q.source);
     SK_cd_puts(&condat, gbuff->str);
     /* Free allocated memory  */
     g_string_free(gbuff, TRUE);
     free(hostaddress);
     free(nrtm_q.source);
     SK_cd_close(&(condat));
     return;
  }
 
  ER_dbg_va(FAC_PM, ASP_PM_INPUT,"[%s] -- input parsed: %s:%d:%ld-%ld", hostaddress, nrtm_q.source, nrtm_q.version, nrtm_q.first, nrtm_q.last);
   
  source_hdl = ca_get_SourceHandleByName(nrtm_q.source); 
  if (source_hdl == NULL){
     ER_dbg_va(FAC_PM, ASP_PM_ERESP,"[%s] --  Unknown source %s", hostaddress, nrtm_q.source);
     sprintf(buff, "\n%%ERROR:4: Unknown source\n\n");
     SK_cd_puts(&condat, buff);
     free(hostaddress);
     free(nrtm_q.source);
     SK_cd_close(&(condat));
     return;
  }
	 
  /* check if the client is authorized to mirror */
  SK_getpeerip(sock, &address);
  if(!AA_can_mirror(&address, nrtm_q.source)){
     ER_inf_va(FAC_PM, ASP_PM_ERESP,"[%s] --  Not authorized to mirror the source %s", hostaddress, nrtm_q.source);
     sprintf(buff, "\n%%ERROR:3: You are not authorized to mirror the database\n\n");
     SK_cd_puts(&condat, buff);
     free(hostaddress);
     free(nrtm_q.source);
     SK_cd_close(&(condat));
     return;
  }

      
    
  /* get database */
  db_name = ca_get_srcdbname(source_hdl);
  /* get database host*/
  db_host = ca_get_srcdbmachine(source_hdl);      
  /* get database port*/
  db_port = ca_get_srcdbport(source_hdl);        
  /* get database user*/
  db_user = ca_get_srcdbuser(source_hdl);          
  /* get database password*/
  db_pswd = ca_get_srcdbpassword(source_hdl);
  
  sql_connection = SQ_get_connection(db_host, db_port,db_name, db_user, db_pswd);
  if(!sql_connection) {
      ER_perror(FAC_PM, PM_NOSQLC," database='%s' [%d] %s",db_name, SQ_errno(sql_connection), SQ_error(sql_connection));
      return;
  }
  ER_dbg_va(FAC_PM, ASP_PM_INPUT,"[%s] --  Made SQL connection to %s@%s", hostaddress, db_name, db_host); 

  /* free copies of the variables */
  free(db_host);
  free(db_name);
  free(db_user);
  free(db_pswd);
                                                        
  current_serial=PM_get_current_serial(sql_connection);
  oldest_serial=PM_get_oldest_serial(sql_connection);
    
  if((current_serial==-1) || (oldest_serial==-1)) {
      ER_perror(FAC_PM, PM_NOSERN," database='%s' [%d] %s",db_name, SQ_errno(sql_connection), SQ_error(sql_connection));
      /* Free the hostaddress */
      SK_cd_close(&(condat));
      /* close the connection to SQL server */
      SQ_close_connection(sql_connection); 
      free(hostaddress);
      free(nrtm_q.source);
      return;
  }
  
  /* zero indicates that LAST keyword has been used */    
  if(nrtm_q.last==0)nrtm_q.last=current_serial;
  
    
  if((nrtm_q.first>nrtm_q.last) || (nrtm_q.first<oldest_serial) || (nrtm_q.last>current_serial) ||
     (nrtm_q.first<=0) || (nrtm_q.last<=0) ) 
  {
      ER_dbg_va(FAC_PM, ASP_PM_ERESP,"[%s] --  Invalid range: %ld-%ld", hostaddress, nrtm_q.first, nrtm_q.last);
      /* write error message back to the client */
      sprintf(buff, "\n%%ERROR:2: Invalid range: Not within %ld-%ld\n\n", oldest_serial, current_serial);
      SK_cd_puts(&condat, buff);
      SK_cd_close(&(condat));
      
      /* close the connection to SQL server */
      SQ_close_connection(sql_connection); 

      /* Free the hostaddress */
      free(hostaddress);
      free(nrtm_q.source);
      return;
  }
  
  current_serial=nrtm_q.first;
 
  /* print banner */
  {
  /* get the header string */
  char *resp_header = ca_get_pw_resp_header;
/*  sprintf(buff, "\n%% Rights restricted by copyright. See http://www.ripe.net/ripencc/pub-services/db/copyright.html\n\n"); */
  SK_cd_puts(&condat, resp_header);
  free(resp_header);
  SK_cd_puts(&condat, "\n");
  } 
   
  sprintf(buff, "%%START Version: %d %s %ld-%ld\n", nrtm_q.version, nrtm_q.source, nrtm_q.first, nrtm_q.last);
  SK_cd_puts(&condat, buff);

  /* make a record for thread accounting */
  TA_setactivity(buff);
  
/* now start feeding client with data */    
  do {    

    object=PM_get_serial_object(sql_connection, current_serial, &operation);
    if (operation == OP_ADD) SK_cd_puts(&condat, "\nADD\n\n");
    else SK_cd_puts(&condat, "\nDEL\n\n");
    
    SK_cd_puts(&condat, object);
      
    free(object);
    current_serial++;


  } /* do while there are more serials, connection was not reset and XXX do_server is on*/
   while((current_serial<=nrtm_q.last) && (condat.rtc == 0));

  
  sprintf(buff, "\n%%END %s\n\n", nrtm_q.source);
  SK_cd_puts(&condat, buff);

  ER_inf_va(FAC_PM, ASP_PM_INPUT,"[%s] -- <%s:%ld-%ld (%ld)> ", 
           hostaddress, nrtm_q.source, nrtm_q.first, nrtm_q.last, nrtm_q.last-nrtm_q.first+1); 

  /* make a record for thread accounting */
  TA_delete();

  SK_cd_close(&(condat));

  /* close the connection to SQL server */
  SQ_close_connection(sql_connection); 
  /* Free the hostaddress */
  free(hostaddress);
  free(nrtm_q.source);

  
  
} /* PM_interact() */
