/* on some machines the AF_INET6 definition is needed, on most systems not */
#include <sys/socket.h>

#ifndef AF_INET6 
#define AF_INET6        24              /* Internet Protocol version 6 */
#endif

#ifndef _LINUX
typedef uint32_t u_int32_t ;
#endif

int inet_pton(int af, const char *src, void *dst);
const char *inet_ntop(int af, const void *src, char *dst, size_t size);
