/*
 * Copyright 1993,1994 Globetrotter Software, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Globetrotter Software not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Globetrotter Software makes
 * no representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * GLOBETROTTER SOFTWARE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO
 * EVENT SHALL GLOBETROTTER SOFTWARE BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 *
 * Author:  Jim McBeath, Globetrotter Software, jimmc@globes.com
 */
/* appconf.c - read all the conf files in the appconf dir
 *
 * Jim McBeath, November 19, 1993
 */

#include <dirent.h>
#include <sys/param.h>	/* get MAXPATHLEN */
#include "htimp.h"
#include "app.h"

#define DIRENT struct dirent

extern char *ImpStrSave();
extern AppInfo *ImpNewApp();

char *ImpAppConfDir = DEFAULT_APP_CONF_DIR;
char *ImpAppBinDir = DEFAULT_APP_BIN_DIR;

void
ImpSetAppConfDir(s)
char *s;
{
	ImpAppConfDir = ImpStrSave(ImpGetAbsoluteDir(ImpGetImpRoot(),s));
}

void
ImpSetAppBinDir(s)
char *s;
{
	ImpAppBinDir = ImpStrSave(ImpGetAbsoluteDir(ImpGetImpRoot(),s));
}

void
ImpAppSetHeader(app,s)
AppInfo *app;
char *s;
{
	if (strcmp(s,"none")==0) {
		app->headerstyle = HEADER_NONE;
	} else if (strcmp(s,"mime")==0) {
		app->headerstyle = HEADER_MIME;
	} else if (strcmp(s,"html")==0) {
		app->headerstyle = HEADER_HTML;
	} else if (strcmp(s,"isindex")==0) {
		app->headerstyle = HEADER_ISINDEX;
	} else if (strcmp(s,"plaintext")==0) {
		app->headerstyle = HEADER_PLAINTEXT;
	} else {
		ImpFatal("Bad header mode %s",s);
		/* NOTREACHED */
	}
}

void
ImpAppSetFormatOut(app,n)
AppInfo *app;
int n;
{
	app->formatout = n;
}

void
ImpAppSetKillTimeout(app,n)
AppInfo *app;
int n;
{
	app->killtimeout = n;
}

void
ImpAppSetCleanupTimeout(app,n)
AppInfo *app;
int n;
{
	app->cleanuptimeout = n;
}

void
ImpAppSetReadTimeout(app,n)
AppInfo *app;
int n;
{
	app->readtimeout = n;
}

void
ImpAppSetTitle(app,s)
AppInfo *app;
char *s;
{
	app->title = ImpStrSave(s);
}

void
ImpAppSetSubtitle(app,s)
AppInfo *app;
char *s;
{
	app->subtitle = ImpStrSave(s);
}

void
ImpAppSetLastOut(app,s)
AppInfo *app;
char *s;
{
	app->lastout = ImpStrSave(s);
	app->lastoutlen = strlen(s);
}

void
ImpAppSetStripLastOut(app,n)
AppInfo *app;
int n;
{
	app->striplastout = n;
}

void
ImpAppSetExecPath(app,s)
AppInfo *app;
char *s;
{
	app->execpath = ImpStrSave(ImpGetAbsoluteDir(ImpAppConfDir,s));
}

OpInfo appoptab[] = {
	{ "execpath", CALL_DS, ImpAppSetExecPath },
	{ "killtimeout", CALL_DN, ImpAppSetKillTimeout },
	{ "cleanuptimeout", CALL_DN, ImpAppSetCleanupTimeout },
	{ "readtimeout", CALL_DN, ImpAppSetReadTimeout },
	{ "header", CALL_DS, ImpAppSetHeader },
	{ "title", CALL_DS, ImpAppSetTitle },
	{ "subtitle", CALL_DS, ImpAppSetSubtitle },
	{ "lastout", CALL_DS, ImpAppSetLastOut },
	{ "striplastout", CALL_DN, ImpAppSetStripLastOut },
	{ "formatout", CALL_DS, ImpAppSetFormatOut },
	{ 0 }
};

void
ImpReadAppConfFile(fn,name)
char *fn;	/* full path to the file to open */
char *name;	/* the app name as we will refer to it */
{
	AppInfo *app;

	app = ImpNewApp(name);
	/* set up defaults */
	app->readtimeout = DEFAULT_APP_READ_TIMEOUT;
	ImpConfFile(fn,appoptab,(void *)app);	/* read the app conf file */
	if (!app->execpath)	/* post-process values */
		app->execpath =
			ImpStrSave(ImpGetAbsoluteDir(ImpAppBinDir,name));
	if (!app->title)
		app->title = app->name;
}

void
ImpReadAppConfNamedDir(dir)
char *dir;
{
	DIR *dp;
	DIRENT *de;
	char *name;
	char fn[MAXPATHLEN+1];
	char *fnp;

	dp = opendir(dir);
	if (!dp) {
		ImpFatal("+Can't open configuration directory %s",dir);
		/* NOTREACHED */
	}
	strcpy(fn,dir);
	fnp = fn+strlen(fn);
	*fnp++ = '/';
	while (de=readdir(dp)) {
		name = de->d_name;
		if (name[0]=='.')
			continue;	/* ignore files starting with dot */
		strcpy(fnp,name);	/* build dir/name */
		ImpReadAppConfFile(fn,name);
	}
	closedir(dp);
}

void
ImpReadAppConfDir()
{
	/* Make sure appbindir is absolute */
	if (ImpAppBinDir[0]!='/')
		ImpAppBinDir = ImpStrSave(ImpGetAbsoluteDir(
				ImpGetImpRoot(),ImpAppBinDir));
	/* Make sure appconfdir is absolute */
	if (ImpAppConfDir[0]!='/')
		ImpAppConfDir = ImpStrSave(ImpGetAbsoluteDir(
				ImpGetImpRoot(),ImpAppConfDir));
	ImpReadAppConfNamedDir(ImpAppConfDir);
}

/* end */
