static char rcsid[] = "ftpenum.c,v 1.28 1996/01/08 09:08:23 duane Exp";
/*
 *  ftpenum.c - Wrapper for the Perl-based ftp enumerator
 *
 *  Call ftpenum.pl to get a remote listing and turn it into a listing 
 *  of "<url> <tab> <timestamp>"
 *
 *  DEBUG: section  45, level 1         Gatherer enumeration for FTP
 *
 *  Jim Guyton & Darren Hardy, hardy@cs.colorado.edu, April 1994
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include "util.h"
#include "url.h"

static void usage()
{
    fprintf(stderr, "Usage: ftpenum ftp-URL\n");
    exit(1);
}

int main(argc, argv)
     int argc;
     char *argv[];
{
    char cmd[BUFSIZ], *thishost;
    char opt[BUFSIZ];
    URL *up;
    char *username = "anonymous";
    char *passwd = getmylogin();
    FILE *logfp = NULL;


#ifdef USE_HOST_CACHE
    host_cache_init();
#endif

    debug_init();		/* from $HARVEST_DEBUG */
    for (argc--, argv++; argc > 0 && **argv == '-'; argc--, argv++) {
	if (strncmp(*argv, "-D", 2) == 0) {
	    debug_flag(*argv);
	}
    }

    if (argc != 1)
	usage();

    if (getenv("HARVEST_GATHERER_LOGFILE") != (char *) NULL)
	logfp = fopen(getenv("HARVEST_GATHERER_LOGFILE"), "a+");
    if (logfp == (FILE *) NULL)
	logfp = stderr;
    init_log3("ftpenum", logfp, stderr);
    init_url();

    Debug(45, 1, ("Enumerating %s\n", *argv));

    if ((up = url_open(*argv)) == NULL) {
	fatal("Invalid URL: %s\n", *argv);
    }
    if (up->type != URL_FTP)
	usage();

    if ((thishost = getfullhostname()) == NULL) {
	fatal("getfullhostname returned NULL\n");
    }
    if (up->user != (char *) NULL)
	username = up->user;
    if (up->password != (char *) NULL)
	passwd = up->password;

    memset(opt, '\0', BUFSIZ);
    if (up->flags & URL_FLAG_PASS_USERINFO)
	strcat(opt, " --keep-userinfo");

    sprintf(cmd, "ftpenum.pl %s \"%s\" \"%s\" \"%s\" \"%s\"",
	opt, up->host, up->pathname, username, passwd);

    /* Clean up */
    url_close(up);
    finish_url();

    /* Run program */
    Debug(45, 1, ("Running command: %s\n", cmd));
    exit(run_cmd(cmd));		/* save an extra fork by using run_cmd() */
}
