static char rcsid[] = "string.c,v 1.17 1996/01/05 20:28:35 duane Exp";
/*
 *  string.c - Simple string manipulation 
 *
 *  DEBUG: section  85, level 1         Common utilities string processing
 * 
 *  Darren Hardy, hardy@cs.colorado.edu, June 1994
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "util.h"

#ifndef isquote
#define isquote(c)	(((c) == '\"') || ((c) == '\''))
#endif

/*
 *  parse_argv() - Parses the command string to build an argv list.  
 *  Supports simple quoting.  argv is large enough to support the 
 *  command string.
 */
void parse_argv(argv, cmd)
     char *argv[];
     char *cmd;
{
    char *tmp, *p, *q;
    int i = 0;

    Debug(85, 1, ("parse_argv: parsing: %s\n", cmd));
    p = q = tmp = xstrdup(cmd);
    while (1) {
	if (isquote(*q)) {
	    p++;
	    q++;
	    while (*q && !isquote(*q))
		q++;
	    if (isquote(*q))
		*q++ = '\0';
	    else if (*q == '\0')
		break;
	} else {
	    while (*q && !isspace((unsigned char) *q))
		q++;
	}
	while (isspace((unsigned char) *q) && !isquote(*q))
	    *q++ = '\0';
	if (*q == '\0') {
	    argv[i++] = xstrdup(p);
	    break;
	}
	if (*p)
	    argv[i++] = xstrdup(p);
	p = q;
    }
    argv[i] = NULL;
    xfree(tmp);
    if (debug_ok(85, 1)) {
	int z;
	for (z = 0; argv[z] != NULL; z++)
	    Log("parse_argv: argv[%d], len %d: '%s'\n",
		z, strlen(argv[z]), argv[z]);
    }
}
