static char rcsid[] = "gopher.c,v 1.19 1996/01/05 20:28:25 duane Exp";
/*
 *  gopher.c - URL processing for gopher-specific URLs
 *
 *  Darren Hardy, hardy@cs.colorado.edu, April 1994
 *
 *  DEBUG: section 24, level 1          Common liburl Gopher routines
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/wait.h>
#include "util.h"
#include "url.h"

/*
 *  gopher_get() - retrieves the URL and prints into the file up->fp.
 *  Returns non-zero on error; 0 on success.
 */
int gopher_get(up)
     URL *up;
{
	static char buf[BUFSIZ];
	int pid;
	int status;
	char *argv[6];
	char *path = NULL;

	Debug(24, 1, ("gopher_get: %s\n", up->url));

	if ((up->gophertype != 0) && (up->gophertype != 1)) {
		errorlog("Unsupported gopher type: %d: %s\n",
		    up->gophertype, up->url);
		return 1;
	}
/*      NOTE: can't use run_cmd() here because it calls parse_argv()    */
/*      and parse_argv() tries to obey quotes.  Gopher URLs may         */
/*      contain apostrophe's, etc.  So we do it the hard way...         */

	if ((pid = fork()) < 0) {
		log_errno("run_cmd: fork");
		return (1);
	}
	if (pid == 0) {		/* child */
		sprintf(buf, "%d", up->port);
		path = strlen(up->pathname) < 3 ? "1/" : up->pathname + 2;

		argv[0] = xstrdup("gopherget.pl");
		argv[1] = xstrdup(up->filename);
		argv[2] = xstrdup(up->host);
		argv[3] = xstrdup(buf);
		argv[4] = xstrdup(path);
		argv[5] = 0;

		execvp(argv[0], argv);
		sprintf(buf, "execvp: %s", argv[0]);
		log_errno(buf);
		_exit(1);
	}
	/* parent */
	(void) waitpid(pid, &status, (int) NULL);
	return (WEXITSTATUS(status));
}
