static char rcsid[] = "ccache_test.c,v 1.11 1995/11/29 00:48:32 duane Exp";
/*
 *  ccache_test.c - test program for the ccache
 *
 *  David Merkel & Mark Peterson, University of Colorado - Boulder, July 1994  
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include "url.h"
#include "ccache.h"

void main(argc, argv)
     int argc;
     char *argv[];
{
	DataReturn *theReturn;
	char aUrl[1024], *tempError;
	CacheErr myErr;
	FILE *inputFile;
	Boolean noCache = FALSE;
	int timeOutVal = MIN_TIMEOUT;
	int mflag = FALSE;
	extern char *optarg;
	char c;
	URL *up;

	InitConfigRec myConfiguration;

#ifdef HAVE_SETLINEBUF
	setlinebuf(stdout);
	setlinebuf(stderr);
#endif

	if (argc < 2) {
		printf("Usage: ccache_test [-t timeout] [-nm] <url_filename>\n");
		exit(1);
	}
	while ((c = getopt(argc, argv, "t:nm")) != EOF) {
		switch (c) {
		case 't':
			sscanf(optarg, "%d", &timeOutVal);
			if (timeOutVal <= MIN_TIMEOUT)
				printf("Timeout value too small\n");
			break;
		case 'n':
			noCache = TRUE;
			break;
		case 'm':
			mflag = TRUE;
			break;
		default:
			printf("Usage: sockcache [-t timeout] [-nm] <url_filename>\n");
			exit(1);
		}
	}

	if ((inputFile = fopen(argv[argc - 1], "r")) == NULL) {
		printf("File not found.\n");
		exit(1);
	}
	myConfiguration.maxConnections = 10;
	myConfiguration.timeOut = timeOutVal;

	SockInit(&myConfiguration);

	while (fgets(aUrl, 1024, inputFile) != NULL) {

		aUrl[strlen(aUrl) - 1] = '\0';

		printf("URL:%s\n", aUrl);

		if ((up = url_open(aUrl)) == NULL)
			continue;
		theReturn = SockGetData(up, mflag ? MEMORY_ONLY : FILE_ONLY, NULL);
		if (theReturn == NULL) {
			myErr = GetError();
			printf("ERROR - %d\n", myErr);
			tempError = GetFTPError();
			if (tempError) {
				printf("FTP Error: %s\n", tempError);
				free((char *) tempError);
			}
		} else {
			printf("fileName: %s\n", theReturn->fileName);
			DestroyDataReturn(theReturn);
		}
		printf("\n");

		if (noCache)
			(void) DisconnectOne();
		url_close(up);

	}


	fclose(inputFile);


	ShutDownCache();
}
