/*
 *   log.h -- Collects statistics information for the broker and logs them.
 *
 *   log.h,v 1.20 1995/09/05 18:25:41 hardy Exp
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */

/* ========== Logging Types in hex ========= */

#define L_UPDATE    	0x00000001
#define L_DELETE    	0x00000002
#define L_REFRESH   	0x00000004
#define L_QUERY     	0x00000008
#define L_QUERY_R   	0x00000010
#define L_CLEAN     	0x00000020
#define L_COLTNG    	0x00000040
#define L_ADMINC    	0x00000080
#define L_ADMINC_R  	0x00000100
#define L_BULK      	0x00000200
#define L_BULK_R    	0x00000400
#define L_CLEANS    	0x00000800
#define L_QUERYERR  	0x00001000
#define L_BULKERR   	0x00002000
#define L_COMPRESS  	0x00004000
#define L_GID	  	0x00008000
#define L_CONNECT	0x00010000

/* ========== Logging Names ========= */

#define L_ADMINC_RS   	"ADMIN-RETURN"
#define L_ADMINC_S    	"ADMIN"
#define L_BULK_RS     	"BULK-RETURN"
#define L_BULK_S      	"BULK-TRANSFER"
#define L_CLEANS_S    	"CLEANER-ON"
#define L_CLEAN_S     	"CLEANED"
#define L_COLTNG_S    	"COLLECTION"
#define L_COMPRESS_S  	"COMPRESSING-REGISTRY"
#define L_DELETE_S    	"DELETE"
#define L_QUERY_RS    	"QUERY-RETURN"
#define L_QUERY_S     	"QUERY"
#define L_REFRESH_S   	"REFRESH"
#define L_UPDATE_S    	"UPDATE"
#define L_GID_S    	"GATHERER-ID"
#define L_CONNECT_S    	"CONNECTION"

/* ========== Logging Macros ========= */

int LOG_statlog();

#define LOGUPDATE(X) \
	{LOG_statlog(L_UPDATE,L_UPDATE_S,(X)->url,(X)->FD,(X)->GID);}

#define LOGQUERY_R(X) \
	{LOG_statlog(L_QUERY_R,L_QUERY_RS,(X)->url,(X)->FD,(X)->GID);}

#define LOGBULK_R(X) \
	{LOG_statlog(L_BULK_R,L_BULK_RS,(X)->url,(X)->FD,(X)->GID);}

#define LOGDELETE(X) \
	{LOG_statlog(L_DELETE,L_DELETE_S,(X)->url,(X)->FD,(X)->GID);}

#define LOGREFRESH(X) \
	{LOG_statlog(L_REFRESH,L_REFRESH_S,(X)->url,(X)->FD,(X)->GID);}

#define LOGCLEAN(X) \
	{LOG_statlog(L_CLEAN,L_CLEAN_S,(X)->url,(X)->FD,(X)->GID);}

#define LOGQUERY(X) \
	{LOG_statlog(L_QUERY,L_QUERY_S, (X));}

#define LOGADMIN(X) \
	{LOG_statlog(L_ADMINC,L_ADMINC_S, (X));}

#define LOGBULK(X) \
	{LOG_statlog(L_BULK,L_BULK_S, (X));}

#define LOGADMIN_R(X) 	\
	{LOG_statlog(L_ADMINC_R,L_ADMINC_RS, (X));}

#define LOGQUERYERR(X) 	\
	{LOG_statlog(L_QUERYERR,L_QUERY_RS, (X));}

#define LOGBULKERR(X) 	\
	{LOG_statlog(L_BULKERR,L_BULK_RS, (X));}

#define LOGCLEANER  	\
	{LOG_statlog(L_CLEANS,L_CLEANS_S);}

#define LOGCOMPRESSION  \
	{LOG_statlog(L_COMPRESS, L_COMPRESS_S);}

#define LOGCOLLECT(S,X, Y) \
	{LOG_statlog(L_COLTNG, L_COLTNG_S, S, (X), Y);}

#define LOGCONNECT(X) \
	{LOG_statlog(L_CONNECT, L_CONNECT_S, (X));}

#define LOGGID(GID,GN,GH,GV) \
	{LOG_statlog(L_GID, L_GID_S, (GID), (GN), (GH), (GV));}

/* Log particular type? */
#define LOG_do_logging(type) \
        (((log_master & (type)) == 00) ? FALSE : TRUE)

