static char rcsid[] = "event.c,v 1.32 1996/01/30 00:55:30 duane Exp";
/*
 *  event.c -- event manager., William G. Camargo, Penn State Univ.,
 *  Broker event queue managment.
 *
 *  DEBUG: section  76, level 1		Broker event management routines
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#include "broker.h"
#include "log.h"
#if defined(_HARVEST_AIX_)
#include <sys/select.h>		/* AIX def for fd_set */
#endif

eventq_t EVENTQ;
int Num_Ev = 0;
extern time_t Cur_Time;
extern int max_events;
extern int ReadQueryTimeout;

int EV_Init()
{
	int i;

	for (i = 0; i < NUM_PRTY; i++) {
		EVENTQ.pri[i].top = NULL;
		EVENTQ.pri[i].tail = NULL;
		EVENTQ.pri[i].qnum = 0;

	}

	Num_Ev = 0;
	return SUCCESS;
}

int EV_add_sevent(sock)
int sock;
{
	event_t *tmp;
	char *sptr;
	int n;
	int x;
        fd_set R;
	struct timeval rdqto;
        int ntimeouts = 0;

	tmp = (event_t *) xmalloc(sizeof(event_t));
	tmp->sock = sock;
	tmp->next = NULL;
	sptr = tmp->queri;
	memset(sptr, '\0', MAX_QUERY);
        n = 0;
	while (n < MAX_QUERY) {
		FD_ZERO (&R);
		FD_SET (sock, &R);
        	rdqto.tv_sec  = ReadQueryTimeout / 1000000;
        	rdqto.tv_usec = ReadQueryTimeout % 1000000;
		if ((x = select (sock+1, &R, 0, 0, &rdqto)) == 0) {
			if (n > 0)
				break;
			if (++ntimeouts > 60)
				break;
		}
		else if (x > 0 && FD_ISSET (sock, &R)) {
			x = read(sock, sptr+n, MAX_QUERY-n);
			if (x > 0)
				n += x;
			else if (x == 0)
				break;
			else if (x < 0) {
				log_errno("EV_add_sevent: read");
				xfree(tmp);
				close(sock);
				return ERROR;
			}
		} else {
			log_errno("EV_add_sevent: select");
			xfree(tmp);
			close(sock);
			return ERROR;
		}
	}
	if (strncasecmp(sptr, USEREV, USEREV_S) == 0) {
		tmp->type = UQUERY;
		if (EV_enq(tmp, 2) == ERROR) {
			xfree(tmp);
			SWRITE(sock, LOADERR, LOADERR_S);
			close(sock);
			return ERROR;
		}
		return SUCCESS;
	}
	if (strncasecmp(sptr, BULKEV, BULKEV_S) == 0) {
		tmp->type = QBULK;
		if (EV_enq(tmp, 3) == ERROR) {
			xfree(tmp);
			(void)QM_send_bulk_err(sock);
			close(sock);
			return ERROR;
		}
		return SUCCESS;
	}
	if (strncasecmp(sptr, ADMINEV, ADMINEV_S) == 0) {
		tmp->type = ADMIN;
		if (EV_enq(tmp, 1) == ERROR) {
			xfree(tmp);
			SWRITE(sock, LOADERR, LOADERR_S);
			close(sock);
			return ERROR;
		}
		return SUCCESS;
	}
	xfree(tmp);
	close(sock);
	return ERROR;
}

int EV_add_aevent(action)
int action;
{
	event_t *tmp;

	tmp = (event_t *) xmalloc(sizeof(event_t));
	tmp->sock = -1;
	tmp->next = NULL;
	tmp->type = action;

	return (EV_enq(tmp, 3));
}

int EV_enq(add_ev, prty)
event_t *add_ev;
int prty;
{

	Debug(76,1,("Enqueue\n"));

	if ((Num_Ev >= max_events) && (prty > 1)) {
		return ERROR;
	}
	add_ev->qtime = Cur_Time;
	if (EVENTQ.pri[prty].tail == NULL) {
		EVENTQ.pri[prty].top = add_ev;
		EVENTQ.pri[prty].tail = add_ev;
	} else {
		EVENTQ.pri[prty].tail->next = add_ev;
		EVENTQ.pri[prty].tail = add_ev;
	}

	EVENTQ.pri[prty].qnum++;
	Num_Ev++;
	return SUCCESS;
}

int EV_Do_Event()
{
	event_t *cur;

	if (Num_Ev == 0)
		return SUCCESS;

	if ((cur = EV_deq()) == NULL)
		return ERROR;

	switch (cur->type) {
	case UQUERY:
	case QBULK:
	case ADMIN:
		(void)QM_query_manager(cur);
		break;
	case COLLECTION:
		(void)Do_Collection();
		break;
	case CLEANING:
		(void)Do_Cleaning();
		break;
	case RCOMP:
		(void)Do_Compression();
		break;
	default:
		break;
	}

	(void)close(cur->sock);	/* verify that socket to client is closed */
	xfree(cur);
	return SUCCESS;
}

event_t *EV_deq()
{
	event_t *tmp;
	int i = 0;

	Debug(76,1,("Dequeue\n"));
	while (i < NUM_PRTY) {
		if (EVENTQ.pri[i].top) {
			tmp = EVENTQ.pri[i].top;
			if (tmp->next) {
				EVENTQ.pri[i].top = tmp->next;
				EVENTQ.pri[i].qnum--;
			} else {
				EVENTQ.pri[i].top = NULL;
				EVENTQ.pri[i].tail = NULL;
				EVENTQ.pri[i].qnum = 0;
			}
			Num_Ev--;
			return (tmp);
		}
		i++;
	}

	Num_Ev = 0;
	return NULL;
}
